﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();
    
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar"">
    <div class="row-fluid form-inline">
        <label class="control-label" for="searchTbx">
            <asp:localize runat="server" meta:resourcekey="heat_picker_label" />
        </label>
        <div class="input-prepend input-append pull-left">
            <button type="button" id="getPreviousItemBtn" class="btn btn-search-prev" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=previous_eafProcess_btn_title />"><i class="fa fa-play fa-rotate-180"></i></button>
            <input type="text" id="searchTbx" style="width:100px;" data-bind="value: trim(search), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=process_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
            <button type="button" id="getNextItemBtn" class="btn btn-search-next" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=next_eafProcess_btn_title />"><i class="fa fa-play"></i></button>
            <button type="button" class="btn" data-bind="clickSet: 'heatId', clickSetValue: -1, disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=current_eafProcess_btn_title />"><i class="fa fa-step-forward"></i></button>
        </div>
        <div class="pull-left" style="margin-left:30px;">
            <a class="anchor-link btn" data-anchor-target=".anchor-target-eaf" data-area-code="eaf">
                <asp:localize runat=server meta:resourcekey=eaf_anchor_label />
            </a>
            <a class="anchor-link btn disabled" data-bind="classes: { hide: not(isLoadingLfProcesses), }">
                <asp:localize runat=server meta:resourcekey=loading_process_info_legend />
            </a>
            <div class="pull-left" data-bind="collection: $lfProcesses, itemView: 'lfProcessAnchorLinkView', classes: { hide: not(not(isLoadingLfProcesses)), }"></div>
            <%--<a class="anchor-link btn" data-anchor-target=".anchor-target-caster" data-area-code="caster"><asp:localize runat=server meta:resourcekey=caster_anchor_label /></a>--%>
            <a class="anchor-link btn" data-anchor-target=".anchor-target-chemistries" data-area-code="chemistries">
                <asp:localize runat=server meta:resourcekey=chemistries_anchor_label />
            </a>
        </div>
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="row-fluid process-container">
        <a class="anchor-target-eaf"></a>
        <div class="row-fluid process-title-container">
            <h3><asp:Localize runat=server meta:resourcekey=process_info_eaf_title /></h3>
            <button id="eafEditBtn" class="eaf-anchor-target btn btn-default edit-process-btn pull-left" data-bind="enabled: any(equals(eafFurnaceCode, -1), equals(eafFurnaceCode, eafProcess_furnaceCode))," title="<asp:Localize runat=server meta:resourcekey=process_edit_btn_title />">
                <i class="fa fa-edit"></i>
            </button>
            <label class="control-label">
                <asp:localize runat="server" meta:resourcekey="process_info_furnace_label" />
                <span class="input-static" data-bind="text: select(eafProcess_id, trim(eafProcess_furnaceName), '<asp:localize runat=server meta:resourcekey=loading_process_info_legend />'),"></span>
            </label>
        </div>
        <div id="eafProcessInfoContainer" class="row-fluid process-info-container"></div>
        <div id="eafChartContainer" class="id-chart-container" style="margin-left:1%;margin-top:15px;height:400px;width:98%;"></div>
    </div>
    <div class="row-fluid lf-processes-container" data-bind="collection: $lfProcesses, itemView: 'lfProcessView'"></div>
    <div class="row-fluid process-container">
        <div id="lfChartContainer" class="id-chart-container" style="margin-left:1%;margin-top:15px;height:400px;width:98%;"></div>
    </div>
    <div class="row-fluid process-container" style="margin-top:30px;">
        <a class="anchor-target-chemistries"></a>
        <div class="row-fluid process-title-container">
            <h3><asp:Localize runat=server meta:resourcekey=chemistry_title /></h3>
            <button id="chemistryEditBtn" class="btn btn-default edit-process-btn pull-left" title="<asp:Localize runat=server meta:resourcekey=chem_edit_btn_title />">
                <i class="fa fa-edit"></i>
            </button>
        </div>
        <div id="chemistriesSamplesInfoContainer" class="row-fluid" style="overflow-x:auto;"></div>
    </div>
</div>

<script id="lf_process_template" type="text/x-handlebars-template">
    <%--<div class="row-fluid lf-process-view"> Classes to be added on the className prop of the view definition.--%>
    <div class="row-fluid process-container">
        <a class="anchor-target-lf-{{HBExp "treatment"}}"></a>
        <div class="row-fluid process-title-container">
            <h3 class="lf-anchor-target-{{HBExp "treatment"}}"><asp:Localize runat=server meta:resourcekey=process_info_lf_title /></h3>
            <button class="btn btn-default edit-process-btn pull-left" data-bind="enabled: any(equals(data_ladleFurnaceCode, -1), equals(data_ladleFurnaceCode, ladleFurnaceCode))," title="<asp:Localize runat=server meta:resourcekey=process_edit_btn_title />">
                <i class="fa fa-edit"></i>
            </button>
            <label class="control-label">
                <asp:localize runat="server" meta:resourcekey="process_info_ladle_furnace_label" />
                <span class="input-static" data-bind="text: select(id, trim(ladleFurnaceName), '<asp:localize runat=server meta:resourcekey=loading_process_info_legend />'),"></span>
            </label>
        </div>
        <div class="row-fluid process-info-container"></div>
    </div>
</script>

<script id="lf_process_anchor_link_template" type="text/x-handlebars-template">
    <%--<a class="anchor-link btn"> Classes to be added on the className prop of the view definition.--%>
    {{HBExp "#ifEquals treatment 1"}}
    <asp:localize runat=server meta:resourcekey=lf_anchor_label />
    {{HBExp "else"}}
    <asp:localize runat=server meta:resourcekey=lf_anchor_label />-{{HBExp "treatment"}}
    {{HBExp "/ifEquals"}}
</script>