﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-timepicker/css/bootstrap-timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />


<div class="row-fluid subnavbar fixed-subnavbar" style="min-width:1305px;"> 
    <div class="form-inline pull-left span12" style="min-width:1500px;"> 

        <%-- Start-End Date pickers --%>
          <label class="control-label" for="dateStartTbx" > 
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend" > 
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: start">
        </label>
        <label class="control-label" for="dateEndTbx" > 
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend" > 
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: end">
        </label>
        
        <%-- Ladles multiselect picker --%>   
        
        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="ladles_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="ladles-picker-multi-select" style="width: 160px !important;max-width:350px !important"></div>
       </label>


        <%-- Event types multiselect picker --%>   
        
        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="ladle_event_types_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="event-types-picker-multi-select" style="width: 250px !important;max-width:350px !important"></div>
       </label>

          <%-- Event source multiselect picker --%>   
        
        <label class="control-label">
            <div class="float-left"><asp:localize runat="server" meta:resourcekey="ladle_event_source_data_entry_label" /></div>
        </label>
        <label class="control-label">
            <div id="event-source-picker-multi-select" style="width: 200px !important;max-width:350px !important"></div>
       </label>



        <%-- Search picker --%>        
        <label class="control-label">
            <asp:localize runat="server" meta:resourcekey="search_label" />
             <input type="text" id="search" class="input-medium clear-search"  style="margin-top: -4px; width: 180px; height: 26px;border-radius: 0px;"  data-bind="value: trim(searchText),events:['keyup']" placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
        </label>

         <%-- Abnormal Events Button--%>  

        <button id="abnormalEventsBtn" style="width:100px !important; height:35px !important;" class="button-4">
                <asp:Localize runat="server" meta:resourcekey="abnormal_events_item_btn_label" />
        </button>

          <%-- Melt Order Changes Button--%>  

        <button id="moChangeEventsBtn" style="width:110px !important; height:35px !important;" class="button-4">
                <asp:Localize runat="server" meta:resourcekey="mo_changes_events_item_btn_label" />
        </button>


        <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
            <span class="excel-export-state fa fa-file-excel-o"></span>
            <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
        </button>      
   
        
    </div>
</div>
<div style="margin-top:50px;">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div id="grid-ladle-tracking-events" class="items-grid-container backgrid-container infinite-container" data-bind="classes: { hideAll: any(not(hasData), isLoading), }"></div>
</div>
       