﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/app/custom-screens/oee/oee.css") %>" rel="stylesheet" />

<style>

    .circle{
        display: inline-block;
        position: relative;
        text-align: center;
    }

    .setpoint-text {
        color:#0072d7; 
    }

    .circle .sub-sub-text-centered-in-circle{
        position: absolute;
        top: 12%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .circle .main-text-centered-in-circle{
        position: absolute;
        top: 30%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .circle .sub-text-centered-in-circle{
        position: absolute;
        top: 52%;
        left: 0;
        width: 100%;
        text-align: center;
    }

        .circle .font55.main-text-centered-in-circle {
            top: 35%;
        }

        .circle .font35.sub-text-centered-in-circle {
            top: 60%;
        }

    .dashboard-font{
        font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
    }

    /* desktop */
    @media (min-width: 1100px) { 
        .font55{
            font-size:4em;
        }

        .font45{
            font-size:3em;
        }

        .font35 {
            font-size:2em;
        }
    
        .font18 {
            font-size:1.2em;
        }

        .font20 {
            font-size:1.5em;
        }

        .font15 {
            font-size:1em;
        }

        .font10 {
            font-size:0.9em;
        }
    }

    /* table and phones */
    @media (max-width: 1100px) { 
        .font55{
            font-size:3.8em;
        }

        .font45{
            font-size:2.6em;
        }

        .font35 {
            font-size:1.8em;
        }
    
        .font18 {
            font-size:1em;
        }

        .font20 {
            font-size:1.3em;
        }

        .font15 {
            font-size:0.8em;
        }

        .font10 {
            font-size:0.7em;
        }
    }

    

    .time-progressbar-container{
        height:10px; 
        width:100px;
    }

    .separator-bar{
        width:100%;height:2px;background-color:#ccc;margin-top:2px;margin-bottom:2px;
    }

    .production-item-container:hover{
        background-color:#e8e8e8;
    }

    .lightcolor-white {
        color:#fff;
    }

    .lightcolor-green {
        color:#1ad91a; 
    }

    .lightcolor-red {
        color:#de2e27; 
    }

    .lightcolor-yellow {
        color:#ecee12; 
    }

</style>

<div class="dashboard-container dashboard-font">
    <div class="row-fluid">
        {{#ifEquals id "NOT" -1}} 
            <a href="{{mainRoute}}"><span style="font-size:18px;"><asp:Localize runat="server" meta:resourcekey="plant_label" /></span></a> >
        {{/ifEquals}}
        <span style="font-size:18px;">{{title}}</span>
    </div>
    {{#ifEquals display "3cols"}} 
        {{#each rows}}
        <div class="row-fluid">
            {{#each columns}}
            <div data-productionitemid="{{productionItemId}}" style="margin-bottom:20px;cursor:pointer;" class="
                span4
                production-item-container">
                <h5>{{title}} [{{type}}]</h5>
                <div class="separator-bar"></div>
                <div style="margin-top:10px;" class="row-fluid">
                    <div style="text-align:center;position:relative;" class="span4 circle-container text-center">
                        <div data-setpoint-value="{{setpoint}}" class="set-point" style="position:absolute;left:25px;top:15px;">
                        </div>
                        <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="oee" data-circle-thickness="15" data-circle-gradient='["#29D65A", "#5feba3"]' data-circle-value="{{oee}}" class="circle">
                            <span class="font35 main-text-centered-in-circle progress-display"></span>
                            <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="OEE_label" /></span>
                        </div>
                    </div>
                    <div class="span8">
                        <div class="row-fluid">
                            <div class="span4 circle-container text-center">
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="ava" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{availability}}" class="circle">
                                    <span class="font15 main-text-centered-in-circle progress-display"></span>
                                    <span class="font10 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="AVA_label" /></span>
                                </div>
                            </div>
                            <div class="span4 circle-container text-center">
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="per" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{performance}}" class="circle">
                                    <span class="font15 main-text-centered-in-circle progress-display"></span>
                                    <span class="font10 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="PER_label" /></span>
                                </div>
                            </div>
                            <div class="span4 circle-container text-center">
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="qua" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{quality}}" class="circle">
                                    <span class="font15 main-text-centered-in-circle progress-display"></span>
                                    <span class="font10 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="QUA_label" /></span>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div data-pidlights="{{productionItemId}}" class="span12 text-center status-lights-container">
                                <span data-lightstatus="STOPPED" data-lightcolor="red" class="fa-stack fa-lg fa-1x light-icon-red">
                                    <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                                    <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                                </span>
                                <span data-lightstatus="MAINTENANCE" data-lightcolor="yellow" class="fa-stack fa-lg fa-1x light-icon-yellow">
                                    <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                                    <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                                </span>
                                <span data-lightstatus="RUNNING" data-lightcolor="green" class="fa-stack fa-lg fa-1x light-icon-green">
                                    <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                                    <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{/each}}
        </div>
        {{/each}}
    {{/ifEquals}}
    {{#ifEquals display "2cols"}}
        {{#each rows}}
        <div class="row-fluid">
            {{#each columns}}
            <div data-productionitemid="{{productionItemId}}" style="margin-bottom:20px;cursor:pointer;" class="
                span6
                production-item-container">
                <h5>{{title}} [{{type}}]</h5>
                <div class="separator-bar"></div>
                <div style="margin-top:10px;" class="row-fluid">
                    <div style="text-align:center;position:relative;" class="span4 circle-container">
                            <div class="set-point" style="position:absolute;left:20px;top:20px;">
                            </div>
                            <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="oee" data-circle-thickness="15" data-circle-gradient='["#29D65A", "#5feba3"]' data-circle-value="{{oee}}" class="circle">
                            <span class="font55 main-text-centered-in-circle progress-display"></span>
                            <span class="font35 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="OEE_label" /></span>
                        </div>
                    </di>
                    <div class="span8">
                        <div class="row-fluid">
                            <div class="span4 circle-container">
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="ava" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{availability}}" class="circle">
                                    <span class="font20 main-text-centered-in-circle progress-display"></span>
                                    <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="AVA_label" /></span>
                                </div>
                            </div>
                            <div class="span4 circle-container">
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="per" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{performance}}" class="circle">
                                    <span class="font20 main-text-centered-in-circle progress-display"></span>
                                    <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="PER_label" /></span>
                                </div>
                            </div>
                            <div class="span4 circle-container">
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="qua" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{quality}}" class="circle">
                                    <span class="font20 main-text-centered-in-circle progress-display"></span>
                                    <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="QUA_label" /></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{/each}}
        </div>
        {{/each}}
    {{/ifEquals}}
    {{#ifEquals display "lines-oee"}}
        {{#each rows}}
            <div class="row-fluid">
                {{#each columns}}
                    <div data-productionitemid="{{productionItemId}}" style="margin-bottom:20px;cursor:pointer;" class="
                    span3
                    production-item-container">
                        <div class="row-fluid">
                            <h5>{{title}} [{{type}}]</h5>
                        </div>
                        <div class="row-fluid">
                            <div style="text-align:center;position:relative;" class="offset2 span8 circle-container">
                                <div data-setpoint-value="{{setpoint}}" class="set-point" style="position:absolute;left:20px;top:10px;">
                                </div>
                                <div data-circle-productionitemid="{{productionItemId}}" data-circle-name="oee" data-circle-thickness="10" data-circle-gradient='["#29D65A", "#5feba3"]' data-circle-value="{{oee}}" class="circle">
                                    <span class="font18 sub-sub-text-centered-in-circle setpoint-text"></span>
                                    <span class="font45 main-text-centered-in-circle progress-display"></span>
                                    <span class="font45 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="OEE_label" /></span>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div data-pidlights="{{productionItemId}}" class="span12 text-center status-lights-container">
                                <span data-lightstatus="STOPPED" data-lightcolor="red" class="fa-stack fa-lg fa-2x light-icon-red">
                                    <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                                    <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                                </span>
                                <span data-lightstatus="MAINTENANCE" data-lightcolor="yellow" class="fa-stack fa-lg fa-2x light-icon-yellow">
                                    <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                                    <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                                </span>
                                <span data-lightstatus="RUNNING" data-lightcolor="green" class="fa-stack fa-lg fa-2x light-icon-green">
                                    <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                                    <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                {{/each}}
            </div>
        {{/each}}
    {{/ifEquals}}
</div>

</script>


