﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<% 
    if (Session["SecurityData"] == null)
    {
        Session["SecurityData"] = WebApp.GetSecurityData();
    }
    
    WebApp.SecurityData securityData = (WebApp.SecurityData) Session["SecurityData"];
    bool writePermission = securityData.GetModuleActionValue("OEE.oee", "write"); 
%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/app/custom-screens/modules/OEE/oee/oee.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/modules/OEE/bootstrap-toggle/bootstrap2-toggle.min.css") %>" rel="stylesheet" />

<style>

    .not-visible {
        visibility:hidden;
    }

    .clickeable-row{
        cursor:pointer; 
    }

    .set-point {
        display: inline-block;
        position: relative;
        text-align: center;
        margin:0 auto;
    }

    .set-point-label {
        position: absolute;
        background-color: transparent;
        color: #000;
        font: 11px/16px Arial, sans-serif;
        margin-top: -8px;
        padding: 0 4px 0 30px;
        border-radius: 2px;
        white-space: nowrap;
    }

    .set-point-text {
        color:#0072d7; 
    }

    .set-point-label::before {
        content: '';
        color: #fff;
        background-color: #15a1cb;
        font-size: 18px;
        position: absolute;
        left: 0;
        top: 50%;
        display: block;
        line-height: 24px;
        width: 24px;
        height: 24px;
        margin-left: -12px;
        margin-top: -11px;
        text-align: center;
        border-radius: 50%;
    }

    .circle{
        display: inline-block;
        position: relative;
        text-align: center;
        margin:0 auto;
    }

    .circle-container {
        text-align:center;
    }

    .overlay-loading,
    .overlay {
        width:100%;
        height:100%;
        position:absolute; 
        background-color:rgba(238, 238, 238, 1);
        opacity:0.5; 
        filter:alpha(opacity=50); 
        z-index:100;
    }

    .overlayed-circle {
        opacity:0.3;
    }

    .circle .main-text-centered-in-circle{
        position: absolute;
        top: 35%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .circle .sub-text-centered-in-circle{
        position: absolute;
        top: 55%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .circle .sub-sub-text-centered-in-circle{
        position: absolute;
        top: 15%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .dashboard-font{
        font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
    }

    .font55{
        font-size:55px;
    }

    .font35 {
        font-size:35px;
    }
    
    .font20 {
        font-size:20px;
    }

    .font15 {
        font-size:15px;
    }

    .font16 {
        font-size:16px;
    }

    .time-progressbar-container{
        height:10px; 
        /*width:100px;*/
    }

    /*.progress .bar-red{background-color:#f11d1d;background-image:-moz-linear-gradient(top, #f11d1d, #cc0000);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#f11d1d), to(#cc0000));background-image:-webkit-linear-gradient(top, #f11d1d, #cc0000);background-image:-o-linear-gradient(top, #f11d1d, #cc0000);background-image:linear-gradient(to bottom, #f11d1d, #cc0000);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#f11d1d', endColorstr='#cc0000', GradientType=0);}
    .progress .bar-green{background-color:#00ff21;background-image:-moz-linear-gradient(top, #00ff21, #00b300);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#00ff21), to(#00b300));background-image:-webkit-linear-gradient(top, #00ff21, #00b300);background-image:-o-linear-gradient(top, #00ff21, #00b300);background-image:linear-gradient(to bottom, #00ff21, #00b300);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#00ff21', endColorstr='#00b300', GradientType=0);}
    .progress .bar-blue{background-color:#1a1aff;background-image:-moz-linear-gradient(top, #1a1aff, #0000e6);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#1a1aff), to(#0000e6));background-image:-webkit-linear-gradient(top, #1a1aff, #0000e6);background-image:-o-linear-gradient(top, #1a1aff, #0000e6);background-image:linear-gradient(to bottom, #1a1aff, #0000e6);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#1a1aff', endColorstr='#0000e6', GradientType=0);}*/

    .progress .bar-custom-color{background-color:none;background-image:none;background-repeat:initial;filter:initial;}
    .progress .bar-red{background-color:#de2e27;background-image:-moz-linear-gradient(top, #de2e27, #c43c35);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#de2e27), to(#c43c35));background-image:-webkit-linear-gradient(top, #de2e27, #c43c35);background-image:-o-linear-gradient(top, #de2e27, #c43c35);background-image:linear-gradient(to bottom, #de2e27, #c43c35);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#de2e27', endColorstr='#ffc43c35', GradientType=0);}
    .progress .bar-green{background-color:#3aea3a;background-image:-moz-linear-gradient(top, #3aea3a, #57a957);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#3aea3a), to(#57a957));background-image:-webkit-linear-gradient(top, #3aea3a, #57a957);background-image:-o-linear-gradient(top, #3aea3a, #57a957);background-image:linear-gradient(to bottom, #3aea3a, #57a957);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#3aea3a', endColorstr='#ff57a957', GradientType=0);}
    .progress .bar-blue{background-color:#15a1cb;background-image:-moz-linear-gradient(top, #15a1cb, #339bb9);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#15a1cb), to(#339bb9));background-image:-webkit-linear-gradient(top, #15a1cb, #339bb9);background-image:-o-linear-gradient(top, #15a1cb, #339bb9);background-image:linear-gradient(to bottom, #15a1cb, #339bb9);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#15a1cb', endColorstr='#ff339bb9', GradientType=0);}
    .progress .bar-yellow{background-color:#ecee12;background-image:-moz-linear-gradient(top, #ecee12, #f89406);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#ecee12), to(#f89406));background-image:-webkit-linear-gradient(top, #ecee12, #f89406);background-image:-o-linear-gradient(top, #ecee12, #f89406);background-image:linear-gradient(to bottom, #ecee12, #f89406);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ecee12', endColorstr='#fff89406', GradientType=0);}
    .progress .bar-orange{background-color:#ffae00;background-image:-moz-linear-gradient(top, #ffae00, #fe9b00);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#ffae00), to(#fe9b00));background-image:-webkit-linear-gradient(top, #ffae00, #fe9b00);background-image:-o-linear-gradient(top, #ffae00, #fe9b00);background-image:linear-gradient(to bottom, #ffae00, #fe9b00);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffae00', endColorstr='#fffe9b00', GradientType=0);}
    .progress .bar-light-blue{background-color:#0088FF;background-image:-moz-linear-gradient(top, #0088FF, #0c67b7);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#0088FF), to(#0c67b7));background-image:-webkit-linear-gradient(top, #0088FF, #0c67b7);background-image:-o-linear-gradient(top, #0088FF, #0c67b7);background-image:linear-gradient(to bottom, #0088FF, #0c67b7);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#0088FF', endColorstr='#ff0c67b7', GradientType=0);}
    .progress .bar-white{background-color:#FFFFFF;background-image:-moz-linear-gradient(top, #FFFFFF, #FFFFFF);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#FFFFFF), to(#FFFFFF));background-image:-webkit-linear-gradient(top, #FFFFFF, #FFFFFF);background-image:-o-linear-gradient(top, #FFFFFF, #FFFFFF);background-image:linear-gradient(to bottom, #FFFFFF, #FFFFFF);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFFFFF', endColorstr='#FFFFFF', GradientType=0);}

    .progress .no-data-bar {background: rgba(255, 255, 255, 1);} 
    .progress .no-data-bar {background-color: rgba(255, 255, 255, 1); background-image: -webkit-gradient(linear,0 100%,100% 0,color-stop(0.25,rgba(77, 77, 77, 0.31),color-stop(0.25,transparent),color-stop(0.5,transparent),color-stop(0.5,rgba(77, 77, 77, 0.31)),color-stop(0.75,rgba(77, 77, 77, 0.31)),color-stop(0.75,transparent),to(transparent))); background-image: -webkit-linear-gradient(45deg,rgba(77, 77, 77, 0.31) 25%,transparent 25%,transparent 50%,rgba(77, 77, 77, 0.31) 50%,rgba(77, 77, 77, 0.31) 75%,transparent 75%,transparent); background-image: linear-gradient(45deg,rgba(77, 77, 77, 0.31) 25%,transparent 25%,transparent 50%,rgba(77, 77, 77, 0.31) 50%,rgba(77, 77, 77, 0.31) 75%,transparent 75%,transparent); background-size: 27px 27px;}

    .progress .bar-hover {
    }

    .progress .bar-hover:hover {
        border:2px dashed #2b2b2b; 
        padding:2px; 
    }

    .title-h-condensed {
        margin:4px auto;
    }

        h1.title-h-condensed, h2.title-h-condensed, h3.title-h-condensed, h4.title-h-condensed, h5.title-h-condensed, h6.title-h-condensed{
            line-height:15px;
        }

        h1.title-h-condensed, h2.title-h-condensed, h3.title-h-condensed{
            line-height:30px;
        }

    .title-h-condensed-extra {
        margin:2px auto;
    }
        
        h1.title-h-condensed-extra, h2.title-h-condensed-extra, h3.title-h-condensed-extra, h4.title-h-condensed-extra, h5.title-h-condensed-extra, h6.title-h-condensed-extra {
            line-height:10px;
        }

        h1.title-h-condensed-extra, h2.title-h-condensed-extra, h3.title-h-condensed-extra{
            line-height:20px;
        }

    .lightcolor-white {
        color:#fff;
    }

    .lightcolor-green {
        color:#1ad91a; 
    }

    .lightcolor-red {
        color:#de2e27; 
    }

    .lightcolor-yellow {
        color:#ecee12; 
    }

    .blinkyellow {
        color:#ecee12; 
    }

    table.time-accounts-table {
        font-size:13px;
    }

    table.batch-info-table {
        font-size:13px;
    }

        table.batch-info-table span {
            min-height:15px !important;
        }


    .batch-indicators-container {
        margin-bottom:2px;
        width:100%;
        height:9px;
        position:relative;
    }
    
    .batch-line {
        width:80px;
        height:9px;
        float:left;
        position:relative;
        cursor:pointer;
    }

        .batch-line.yellow {
            background-color:#ffae00;
        }

        .batch-line.green {
            background-color:#3aea3a;
        }

        .batch-line.blue {
            background-color:#15a1cb;
        }

        .batch-line.orange {
            background-color:#ff6a00; 
        }

        .batch-line.purple {
            background-color:#b200ff; 
        }

    .full-overlay {
        position:absolute;
        top:0; 
        right:0; 
        bottom:0;
        left:0;
        z-index:102; 
        background-color:#fff; 
        opacity: 0.6;
        filter: alpha(opacity=60);
    }

    .full-overlay-text {
        position:absolute;
        top:0; 
        right:0; 
        bottom:0;
        left:0;
        z-index:105; 
        text-align:center; 
    }

    .backgrid tr.disabled-row {
            background-color:rgba(238, 238, 238, 1);
            color:rgba(153, 153, 153, 1); 
        }

        .backgrid tbody tr.disabled-row:hover > td,
        .backgrid tbody tr.disabled-row:hover > th {
            background-color:rgba(238, 238, 238, 1);
            color:rgba(153, 153, 153, 1); 
        }

    .unit-legend {
        margin-top:3px;
        margin-left:5px;
        color:#b7b6b6;
        font-style:italic;
    }

</style>

<div style="position:relative;" class="dashboard-container dashboard-font">
    <div class="out-of-production-mode-overlay full-overlay hide">
    </div>
    <div class="out-of-production-mode-actions full-overlay-text hide">
        <div style="position:relative;top:20%;width:50%;margin:0 auto;border:1px solid #ccc;background-color:#fff;padding:5%;">
            <h1><asp:Localize runat="server" meta:resourcekey="machine_is_out_of_production_msg" /></h1><br />
            <button class="btn btn-success btn-large btn-start-production-mode"><asp:Localize runat="server" meta:resourcekey="start_production_mode" /></button>
            <div style="text-align:center;margin-top:10px;" class="loading-icon hide">
                <i class="fa fa-5x fa-cog fa-spin"></i><br />
            </div>
        </div>
    </div>
    <div style="margin-bottom:10px;margin-top:-5px;" class="row-fluid">
        <a data-bind="attr: { href: productionItemParentOverviewLink }"><span style="font-size:16px;font-weight:bold;margin:0;" data-bind="text: productionItemParentName"></span></a>
        >
        <span style="font-size:16px;font-weight:bold;margin:0;" data-bind="text: productionItemName"></span>
    </div>
    <div style="margin-top:-5px;" class="row-fluid">
        <div class="span12">
            <div class="span9" style="position:relative;">
                <div class="span4 circle-container" style="position:relative;">
                    <div class="overlay hide"></div>
                    <div data-circle-name="oee" data-circle-size="65" data-circle-thickness="20" data-circle-gradient='["#29D65A", "#5feba3"]' data-circle-value="{{oee}}" class="circle main-oee-circle">
                        <div class="set-point" style="position:absolute;left:20px;top:20px;">
                        </div>
                        <span class="font20 sub-sub-text-centered-in-circle set-point-text"></span>
                        <span class="font55 main-text-centered-in-circle progress-display"></span>
                        <span class="font35 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="OEE_label" /></span>
                    </div>
                    <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(isLoadingProdData), },"></div>
                </div>
                <div class="span8" style="position:relative;">
                    <div class="row-fluid" style="position:relative;">                        
                        <div class="span4 circle-container">
                            <div data-circle-name="ava" data-circle-size="60" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{availability}}" class="circle main-oee-circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="AVA_label" /></span>
                            </div>
                        </div>
                        <div class="span4 circle-container">
                            <div data-circle-name="per" data-circle-size="60" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{performance}}" class="circle main-oee-circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="PER_label" /></span>
                            </div>
                        </div>
                        <div class="span4 circle-container">
                            <div data-circle-name="qua" data-circle-size="60" data-circle-thickness="10" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{quality}}" class="circle main-oee-circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="QUA_label" /></span>
                            </div>
                        </div>
                        <div class="overlay hide" style="padding-left:3.9%;left:-3.9%;top:0;"></div>
                        <div class="overlay-text-no-batch overlay-group-data hide" style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide-overlay': not(not(isLoadingProdData)), },">
                            <span style="position:relative;font-size:32px;top:40%;">
                                <asp:Localize runat="server" meta:resourcekey="no_batch_selected_label" />
                            </span>
                        </div>
                        <div class="overlay-text-maintenance-mode overlay-group-data hide" style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide-overlay': not(not(isLoadingProdData)), },">
                            <span style="position:relative;font-size:32px;top:40%;">
                                <asp:Localize runat="server" meta:resourcekey="maintenance_mode_message_label" />
                            </span>
                        </div>
                        <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(isLoadingProdData), },"></div>
                        <div style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide': not(isLoadingProdData), },">
                            <span style="position:relative;font-size:32px;top:40%;">
                                <asp:Localize runat="server" meta:resourcekey="loading_label" />
                            </span>
                        </div>
                    </div>
                    <div style="margin-top:5px;" class="row-fluid">
                        <div class="row-fluid" style="margin-bottom:5px;">
                            <h4 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="product_qty_label" /></h4>
                        </div>
                        <div class="row-fluid">
                            <div style="position:relative;height:25px;">
                                <div class="progressbar-trail" style="height:25px;top:0px;width:100%;background-color:#eee;position:absolute;"></div>
                                <div class="progressbar-target" style="height:25px;top:0px;width:100%;position:absolute;"></div>
                                <div class="progressbar-actual" style="height:25px;top:0px;width:100%;position:absolute;"></div>
                            </div>
                        </div>
                        <div style="margin-top:3px;" class="row-fluid">
                            <div class="span4 pull-left">
                                <h3 class="good-qty-display title-h-condensed"></h3>
                                <h5 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="good_qty_label" /></h5>
                            </div>
                            <div class="span4 pull-left">
                                <h3 class="bad-qty-display title-h-condensed" data-bind="classes: { hide: not(any(not(batchNumber), not(productionItemBadUnitProducedManualEnabled))), },"></h3>
                                <h5 class="title-h-condensed" data-bind="classes: { hide: not(any(not(batchNumber), not(productionItemBadUnitProducedManualEnabled))), },"><asp:Localize runat="server" meta:resourcekey="bad_qty_label" /></h5>
                                <button class="btn btn-bad-qty-add-manual" style="min-width:95px;text-align:left;" data-bind="classes: { hide: not(all(batchNumber, productionItemBadUnitProducedManualEnabled)), },">
                                    <h3 class="bad-qty-display title-h-condensed"></h3>
                                    <h5 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="bad_qty_label" /></h5>
                                </button>
                            </div>
                            <div class="span4 pull-right">
                                <h3 class="target-qty-display title-h-condensed"></h3>
                                <h5 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="target_qty_label" /></h5>
                            </div>
                        </div>
                        <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(isLoadingProdData), },"></div>
                    </div>
                </div>
            </div>
            <div class="span3" style="position:relative;">
                <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide-overlay': not(isLoadingProdData), },"></div>
                <div style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide-overlay': not(isLoadingProdData), },">
                    <span style="position:relative;font-size:32px;top:40%;">
                        <asp:Localize runat="server" meta:resourcekey="loading_label" />
                    </span>
                </div>
                <h4 style="margin-top:0px;margin-bottom:0px;"><asp:Localize runat="server" meta:resourcekey="production_rate_label" /></h4>
                <div style="width:100%;height:1px;background-color:#ccc;margin-top:1px;margin-bottom:1px;"></div>
                <div class="row-fluid">
                    <div class="span6">
                        <h5 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="current_rate_label" /></h5>
                        <h3 style="margin-bottom:2px;" class="half-circle-progress-display actual-production-rate-display title-h-condensed"></h3>
                        <h6 style="margin:0; line-height:15px;"><asp:Localize runat="server" meta:resourcekey="prod_per_minute_label" /></h6>
                    </div>
                    <div class="span6" style="text-align:right;">
                        <h5 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="target_rate_label" /></h5>
                        <h3 style="min-width:35px;" class="title-h-condensed target-production-rate-display">{{targetProductionRate}}</h3>
                        <h6 style="margin:0; line-height:15px;"><asp:Localize runat="server" meta:resourcekey="prod_per_minute_label" /></h6>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span12 circle-container">
                        <div data-circle-name="productionRate" data-circle-value="{{actualProductionRate}}" data-circle-size="85" data-circle-thickness="25" class="half-circle">
                        </div>
                    </div>
                </div>
                <div class="row-fluid text-center">
                    <div style="position:relative;top:-35px;" class="in-maintenance-switch not-visible">
                        <input id="in-maintenance-toggle" type="checkbox" data-onstyle="warning" data-offstyle="success" data-on="<asp:Localize runat="server" meta:resourcekey="maintenance_label" />" data-off="<asp:Localize runat="server" meta:resourcekey="production_label" />" data-toggle="toggle">
                    </div>
                </div>
                <div class="row-fluid" style="position:relative;height:0px;">
                    <div style="text-align:center;top:-20px;position:relative;">
                        <span data-lightstatus="STOPPED" data-lightcolor="red" class="fa-stack fa-lg fa-2x light-icon-red">
                            <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                            <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                        </span>
                        <span data-lightstatus="MAINTENANCE" data-lightcolor="yellow" class="fa-stack fa-lg fa-2x light-icon-yellow">
                            <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                            <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                        </span>
                        <span data-lightstatus="RUNNING" data-lightcolor="green" class="fa-stack fa-lg fa-2x light-icon-green">
                            <i class="fa fa-circle fa-stack-2x lc-indicator lightcolor-white"></i>
                            <i style="color:#ebebeb;" class="fa fa-circle-thin fa-stack-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div style="position:relative;margin-top:-5px;" class="row-fluid">
        <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(isLoadingProdData), },"></div>
        <div style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide': not(isLoadingProdData), },">
            <span style="position:relative;font-size:32px;top:40%;">
                <asp:Localize runat="server" meta:resourcekey="loading_label" />
            </span>
        </div>
        <div class="row-fluid">
            <div class="span4">
                <h4 class="pull-left"><asp:Localize runat="server" meta:resourcekey="information_title" /></h4>
                <div class="batch-toolbar pull-right">
                    <%--<div class="in-maintenance-switch">
                        <span>Manteminiento:</span>
                        <input disabled="disabled" id="in-maintenance-toggle" type="checkbox" data-onstyle="warning" data-on="Activado" data-off="Desactivado" data-toggle="toggle">
                    </div>--%>
                    <button <% = (!writePermission) ? "disabled='disabled'" : "" %> class="btn btn-open-batch btn-primary hide" data-bind="classes: { 'hide-button': not(not(isLoadingProdData)), },"><asp:Localize runat="server" meta:resourcekey="open_batch_btn_label" /></button>
                    <button <% = (!writePermission) ? "disabled='disabled'" : "" %> class="btn btn-close-batch btn-danger hide" data-bind="classes: { 'hide-button': not(not(isLoadingProdData)), },"><asp:Localize runat="server" meta:resourcekey="close_batch_btn_label" /></button>
                    <%--<% if (writePermission) { %>--%>
<%--                        <div style="text-align:center;margin-top:10px;" class="loading-icon" data-bind="classes: { 'hide-button': not(isLoadingProdData), },">
                            <i class="fa fa-cog fa-spin"></i><br />
                        </div>--%>
                    <%--<% } %>--%>
                </div>
                <div class="row-fluid">
                    <table style="margin-bottom:-8px;" class="table table-condensed batch-info-table">
                        <thead>
                        </thead>
                        <tbody>
                            <tr>
                                <td><asp:Localize runat="server" meta:resourcekey="product_label" /></td>
                                <td><span class="batch-product-name-span">{{batchProduct}}</span></td>
                            </tr>
                            <tr>
                                <td><asp:Localize runat="server" meta:resourcekey="batch_label" /></td>
                                <td><span class="batch-number-span">{{batchNumber}}</span></td>
                            </tr>
                            <tr>
                                <td>Start</td>
                                <td><strong class="batch-start-span">{{batchStart}}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>    
            </div>
            <div class="span8" style="position:relative;">
                <h4><asp:Localize runat="server" meta:resourcekey="progress_title" /></h4>
                <div style="width:100%;height:1px;background-color:#ccc;margin-top:1px;margin-bottom:1px;"></div>
                <div class="row-fluid">
                    <div class="row-fluid">
                        <div style="margin-top:5px;" class="progress-bar-container">
                            <div class="row-fluid">
                                <div class="batch-indicators-container">
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="progress">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 progress-bar-timeline" style="position:relative;height:0;min-height:0;max-height:0;">
                        </div>
                    </div>
                </div>
                <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(isLoadingDelaysData), },"></div>                    
                <div style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide': not(isLoadingDelaysData), },">
                    <span style="position:relative;font-size:32px;top:40%;">
                        <asp:Localize runat="server" meta:resourcekey="loading_label" />
                    </span>
                </div>
            </div>
        </div>
        <div class="row-fluid" style="position:relative;">
            <div class="span4">
                <h4><asp:Localize runat="server" meta:resourcekey="timeaccounts_title" /></h4>
                <div style="width:100%;height:1px;background-color:#ccc;margin-top:1px;margin-bottom:1px;"></div>
                <div class="row-fluid">
                    <div class="time-accounts-grid-container">
                    </div>
                </div>
            </div>
            <div class="span8">
                <div class="row-fluid">
                    <h4 style="float:left;display:inline-block;"><asp:Localize runat="server" meta:resourcekey="events_title" /></h4>
                    <div data-bind="text: format('<asp:Localize runat=server meta:resourcekey=current_delay_duration_label />', duration(delaysInformation_currentDelayDuration, 's', 'h:m:s')), toggle: delaysInformation_currentDelayDuration," style="display:inline-block;float:left;font-weight:bold;font-size:14px;margin:12px 10px 8px 10px;"></div>
                    <div style="display:inline-block; float:right;">
                        <button <% =(!writePermission) ? "disabled='disabled'" : "" %> class="btn btn-medium btn-danger btn-end-production-mode hide"><asp:Localize runat="server" meta:resourcekey="stop_production_mode" /></button>
                    </div>
                </div>
                <div style="width:100%;height:1px;background-color:#ccc;margin-top:1px;margin-bottom:1px;"></div>
                <div class="row-fluid">
                    <div style="height:190px;overflow-y:auto;" class="events-grid-container"></div>                    
                </div>
            </div>
            <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(isLoadingDelaysData), },"></div>                    
            <div style="width:100%;height:100%;position:absolute;z-index:101;text-align:center;left:0;top:0;" data-bind="classes: { 'hide': not(isLoadingDelaysData), },">
                <span style="position:relative;font-size:32px;top:40%;">
                    <asp:Localize runat="server" meta:resourcekey="loading_label" />
                </span>
            </div>
        </div>
    </div>
</div>

</script>

<script id="open_batch_loading_modal_template" type="text/x-handlebars-template">
    <style>
        .modal-wider {
            width:780px;
            margin-left:-390px;
            margin-top:-30px;
        }
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="open_batch_title" /></h3>
    </div>
    <div style="max-height:450px;min-height:350px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;"><asp:Localize runat="server" meta:resourcekey="loading_label" /></span>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="open_batch_opening_modal_template" type="text/x-handlebars-template">
    <style>
        .modal-wider {
            width:780px;
            margin-left:-390px;
            margin-top:-30px;
        }
    </style>
    <div class="modal-header noselect">
        <h3><asp:Localize runat="server" meta:resourcekey="open_batch_title" /></h3>
    </div>
    <div style="height:150px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;"><asp:Localize runat="server" meta:resourcekey="opening_batch_label" /></span>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="open_batch_modal_template" type="text/x-handlebars-template">
    <style>
        .modal-wider {
            width:780px;
            margin-left:-390px;
            margin-top:-30px;
        }

        .clickeable-row{
            cursor:pointer; 
        }
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true" data-bind="enabled: not(promptingConfirmation),">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="open_batch_title" /></h3>
    </div>
    <div style="max-height:450px;min-height:200px;" class="modal-body noselect">
        <div class="overlay-loading" style="padding-left:3.9%;left:-3.9%;top:0;" data-bind="classes: { 'hide': not(promptingConfirmation), },"></div>
        <div class="container-fluid">
            <div class="row-fluid batches-section hide">
                <div class="row-fluid">
                    <div class="batches-table span12">
                    </div>
                </div>
            </div>
            <div class="row-fluid no-batches-section hide text-center" style="margin-top:12%;position:relative;">
                <span style="position:relative;font-size:32px;">
                    <asp:Localize runat="server" meta:resourcekey="no_available_batches" />
                </span>
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">        
        <div class="row-fluid">
            <div class="row-fluid">
                <div class="span4"> 
                </div>
                <div class="span4">
                    <button style="height:52px;" class="btn-close btn-block btn btn-large" data-bind="enabled: not(promptingConfirmation),">
                        <asp:Localize runat="server" meta:resourcekey="cancel_label" />
                    </button>
                </div>
                <div class="span4"> 
                </div>
            </div>
        </div>
    </div>
</script>

<script id="add_bad_manual_modal_template" type="text/x-handlebars-template">


    <%--<div class="modal hide fade add-bad-manual-modal"> Classes to be added on the className prop of the view definition.--%>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=add_bad_manual_modal_title /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div style="display:inline-block;margin-right:20px;min-width:300px;">
                <span style="font-weight:600;display:inline-block;">
                    <asp:Localize runat="server" meta:resourcekey="add_bad_manual_modal_current_quantity_label" />:
                </span>
                <span style="margin-left:8px;" data-bind="text: coalesce(currentQuantity, 0),"></span>
                <span data-bind="text: coalesce(unitsLegend, '')" class="unit-legend"></span>
            </div>
            <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
        </div>
        <div class="row-fluid">
            <div class="control-group">
                <label class="control-label">
                    <asp:localize runat="server" meta:resourcekey="add_bad_manual_modal_items_count" />
                    <div class="controls">
                        <input type="number" id="productionQtyTbx" class="autofocus" style="float:left;width:70px;" data-bind="value: productionQty, events: ['change', 'keyup'], enabled: not(processing)," data-select-on-focus />
                        <span data-bind="text: coalesce(unitsLegend, '')" class="unit-legend" style="float:left;"></span>
                    </div>
                </label>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <%--<div class="modal-status-msg text-3dots hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>--%>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='add_bad_manual_modal_processing_msg' />
                <i class="fa fa-3x fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(inRangeMin(productionQty, 0, false), notEquals(processing, true))," class="btn btn-primary btn-large">
            <asp:Localize runat='server' meta:resourcekey='add_bad_manual_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn btn-large" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='add_bad_manual_modal_cancel_btn_label' />
        </button>
    </div>
</script>

<script id="close_batch_modal_template" type="text/x-handlebars-template">


    <%--<div class="modal hide fade close-batch-modal"> Classes to be added on the className prop of the view definition.--%>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=close_batch_modal_title /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        {{#if badManualEnabled}}
        <div class="row-fluid" data-bind="html: format('<asp:Localize runat=server meta:resourcekey=close_batch_modal_body_text_bad_manual />', batchNumber, batchProduct), classes: { hide: not(not(processing)), }"></div>
        {{else}}
        <div class="row-fluid" data-bind="html: format('<asp:Localize runat=server meta:resourcekey=close_batch_modal_body_text />', batchNumber, batchProduct), classes: { hide: not(not(processing)), }"></div>
        {{/if}}
        {{#if badManualEnabled}}
        <div class="row-fluid" data-bind="classes: { hide: not(not(processing)), }">
            <div style="display:inline-block;margin-top:15px;margin-right:20px;min-width:300px;">
                <span style="font-weight:600;display:inline-block;">
                    <asp:Localize runat="server" meta:resourcekey="close_batch_modal_current_bad_quantity_label" />:
                </span>
                <span style="margin-left:8px;" data-bind="text: coalesce(currentQuantity, 0),"></span>
                <span data-bind="text: coalesce(unitsLegend, '')" class="unit-legend"></span>
            </div>
            <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
        </div>
        <div class="row-fluid" data-bind="classes: { hide: not(not(processing)), }">
            <div class="control-group">
                <label class="control-label">
                    <asp:localize runat="server" meta:resourcekey="close_batch_modal_bad_quantity" />
                    <div class="controls">
                        <input type="number" id="productionQtyTbx" style="float:left;width:70px;" data-bind="value: productionQty, events: ['change', 'keyup'], enabled: not(processing)," data-select-on-focus />
                        <span data-bind="text: coalesce(unitsLegend, '')" class="unit-legend" style="float:left;"></span>
                    </div>
                </label>
            </div>
        </div>
        {{/if}}
        <div class="row-fluid" style="margin-top:15px;" data-bind="classes: { hide: not(not(processing)), }">
            <div class="control-group">
                <label class="control-label">
                    <asp:localize runat="server" meta:resourcekey="close_batch_modal_comments" />
                    <div class="controls">
                        <textarea id="commentsTxt" style="width:400px;height:70px;" data-bind="value: comments, enabled: not(processing),"></textarea>
                    </div>
                </label>
            </div>
        </div>
        <div class="row-fluid" data-bind="classes: { hide: not(processing), }">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;">
                        <asp:localize runat="server" meta:resourcekey="close_batch_modal_loading" />
                    </span>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
<%--        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg text-3dots hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='close_batch_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>--%>
        <button id="acceptBtn" data-bind="enabled: all(inRangeMin(productionQty, 0), notEquals(processing, true))," class="btn btn-primary btn-large">
            <asp:Localize runat='server' meta:resourcekey='close_batch_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn btn-large" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='close_batch_modal_cancel_btn_label' />
        </button>
    </div>
</script>