﻿//SCREEN-BOILERPLATE

//this boilerplate builds screens that are gonna be shown in the <div class="content"> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  "app",

  //templates-loader: this loads templates async.
  "js/templates-loader",

  "modules/modal"

],

function (app, T, Modal) {

    //replace all "NotAvailable" with your view's name.
    var NotAvailable = { Model: {}, Views: {} }

    NotAvailable.Model = Backbone.Model.extend({
        defaults: {
            procedure: ''
        }
    });

    //the generate id method is called everytime a view is going to be shown by the router and returns and id that
    //is used by the router to store in cache (if it is cacheable) and to know the current shown view.
    //this is useful in case your view is reusable, and displays different data depending on url parameters 
    //(such as a catalog view, or a report that doesnt change in terms of UI but it does change in terms of data)
    //so you can always use the same view on the router but the cache can tell which view is which by using differents ids.
    NotAvailable.generateID = function (viewParams) {
        try {
            //if the viewparams change the view id, then evaluate the viewparams here
            //and return the appropiate id.
            return "not-available"; 
        } catch (Error) { }
    }

    NotAvailable.Views.Main = Backbone.View.extend({
        template: "not-available"
        , id: "not-available"
        , title: "Reporte no disponible"
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        , isCacheable: false
        , initialize: function () {
            if (this.options.viewParams) {
            }

            var model = new NotAvailable.Model({
                procedure: "dbo.procedureName"
            });

            this.model = model;

            this.bindEvents();
        },

        events: {
        }, 

        render: function (container) {
            var that = this;
            var thatContainer = container;
            this.options.MYREFERENCES = {};

            
        }

        , refresh: function () {
            try {

            } catch (Error) { }
        }

        , bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
        }

        , close: function () {
            this.remove();
            this.unbind();
        }

        , show: function () {
            this.bindEvents();
            this.$el.show();
        }

        , hide: function () {
            this.$el.hide();
            this.unbind();
            this.stopListening();
        }

        , preRender: function () {
            app.models.subnavbar.set("dateControl", false);
            app.models.subnavbar.set("notificationBar", false);
            app.models.subnavbar.set("subnavbar", false);
        }

        , reRender: function () {
        }
    });

    // Required, return the module for AMD compliance.
    return NotAvailable;

});
