﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" id="subnavbar_controls" style="margin-bottom: 0px;padding: 5px 0px;">
    <div class="row-fluid form-inline">
        <div class="span10">
           

        </div>
        <div class="span2"> 
            <button id="refreshBtn" class="btn btn-primary pull-right" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
            <button id="settingsBtn" class="btn btn-primary pull-right" style="margin-right: 10px;" 
                title="<asp:localize runat=server meta:resourcekey=config_btn_title />">
                <i class="fa fa-cog"></i>
            </button>
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content" style="margin-top: 20px !important;">
    <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="row-fluid" style="position: relative;" data-bind="classes: { hide: any(not(hasData), isLoading), }">       
            <canvas id="myChartPJM" height="40"></canvas>  
        </div>
        <div class="row-fluid" style="position: relative;" data-bind="classes: { hide: any(not(hasData), isLoading), }">       
            <canvas id="myChartAEP" height="40"></canvas>  
        </div>
        <div class="row-fluid" style="position: relative;" data-bind="classes: { hide: any(not(hasData), isLoading), }">       
            <canvas id="myChartSDI" height="40"></canvas>  
        </div>
        <div class="row-fluid" style="position: relative;" data-bind="classes: { hide: any(not(hasData), isLoading), }">       
            <canvas id="myChartPrice" height="40"></canvas>  
        </div>       
      
        

        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>
    </div>
</div>
<script id="power_load_monitoring_settings_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3> <asp:Localize runat=server meta:resourcekey=settings_modal_title /></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">         
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;display: inline-flex;" class="span4 control-group form-inline">
                    <div style="background-color: #de7d7d;width: 40px;height: 20px;border: 2px #c4274c solid;margin-right: 5px">&nbsp;</div>
                    <div><asp:Localize runat=server meta:resourcekey=pjmWarn_label /></div>
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span2 control-group form-inline">
                    <input type="text" style="width:60px;text-align: right;" data-bind="value: pjmWarn," />
                </div>
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;display: inline-flex;" class="span4 control-group form-inline">
                    <div style="background-color: #f3d32b;width: 40px;height: 20px;border: 2px #FFEE7E solid;margin-right: 5px">&nbsp;</div>
                    <div><asp:Localize runat=server meta:resourcekey=pjmWatch_label /></div>
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span2 control-group form-inline">
                    <input type="text" style="width:60px;text-align: right;" data-bind="value: pjmWatch," />
                </div>
            </div> 
        </div>
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">         
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;display: inline-flex;" class="span4 control-group form-inline">
                    <div style="background-color: #de7d7d;width: 40px;height: 20px;border: 2px #c4274c solid;margin-right: 5px">&nbsp;</div>
                    <div><asp:Localize runat=server meta:resourcekey=aepWarn_label /></div>
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span2 control-group form-inline">
                    <input type="text" style="width:60px;text-align: right;" data-bind="value: aepWarn," />
                </div>
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;display: inline-flex;" class="span4 control-group form-inline">
                    <div style="background-color: #f3d32b;width: 40px;height: 20px;border: 2px #FFEE7E solid;margin-right: 5px">&nbsp;</div>
                    <div><asp:Localize runat=server meta:resourcekey=aepWatch_label /></div>
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span2 control-group form-inline">
                    <input type="text" style="width:60px;text-align: right;" data-bind="value: aepWatch,"/>
                </div>
            </div> 
        </div>
    </div>
    <div class="modal-footer">
        <button id="settingsSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>