﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="min-width:1305px;margin-top: -1px;""> 
    <div class="form-inline pull-left span11" style="min-width:1260px;"> 
        
        <label class="control-label" for="dateStartTbx">
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: start">
        </label>
        <label class="control-label" for="dateEndTbx">
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: end">
        </label>       

        <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />"  data-bind=" disabled: isLoading">
            <i class="fa fa-refresh"></i>
        </button>
        <div class="pull-right" style="margin-right:10px;">
            <button id="printBtn" class="btn btn-primary"  style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                <i class="fa fa-print"></i>
            </button>
            <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content" style="min-width:1260px;">
   <div id="pageborder" style="margin-bottom:5px !important"></div>
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div> 
 
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="row entry-row body-print" style="margin-left:30px;">
        <div class="entry-div-label" data-bind="classes: { hide: any(not(hasData), isLoading), }" >

            <!--STEEL DYNAMICS LOGO HTML-->
            <div class="row fluid">           
                <div id ="img-logo-main" class="span6 not-print" style="max-width:350px; margin-top: 0px; margin-left: 30px;" >
                    <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + 
                    Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".jpg") %>' />
                </div>
                <div class="span6 page-title not-print " style="font-size:40px; margin-top:20px; margin-left:24%;color:black;  "
                    data-bind="classes: { hide: any(not(hasData), isLoading), }">
                    <h2>
                        <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
                    </h2>
                </div>
            </div>

             <!--STEEL DYNAMICS LOGO PRINT OPTION-->
            <div class="container-logo-title">
                <div class="badge-logo-title">
                    <div id ="img-logo" style="margin-left:-40px; /*margin-top:-100px;*/">
                        <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + 
                        Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".jpg") %>' />
                    </div>
                </div>
                <div class="badge-logo-title" style="margin-left: 80px; margin-top:100px;">
                    <h2 id="pdf-title">
                        <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
                    </h2>
                </div>
            </div>

             <!--Last Update Datetime-->

             <div style="margin-top:30px; margin-left:-15px; display:block !important">
                <div style="float:left;">
                    <label class="print-label" style="font-size:18px;">
                        <asp:localize runat="server" meta:resourcekey="last_update_datetime_label" />
                    </label>
                </div>
                <div style="font-size:18px; font-weight:bold;">
                    <span data-bind="text: lastUpdateDatetime" class="print-label" style="margin-left:20px !important"></span>
                </div>
            </div>     

            <div class="row-fluid" style="margin-left:-15px; margin-top:10px;">
                
                <div class="span4">
                    <!---SOUTH FLUX SILOS GRID-->
                    <div data-bind="classes: { hide: any(not(hasData_south), isLoading_south), }">
                        <h4>SOUTH FLUX SILOS</h4>
                        <div class="items-grid-container-south" style="max-width:90%; font-size:13px;"></div>
                    </div>
                </div>
                <div class="span4">                    
                        <!---NORTH FLUX SILOS GRID-->
                    <div data-bind="classes: { hide: any(not(hasData_north), isLoading_north), }">
                        <h4>NORTH FLUX SILOS</h4>
                        <div class="items-grid-container-north" style="max-width:90%; font-size:13px;"></div>
                    </div>
                </div>
                <div class="span4">
                    <!---INJ FLUX SILOS GRID-->
                    <div data-bind="classes: { hide: any(not(hasData_inj), isLoading_inj), }">
                        <h4>EAF INJECTION AND LMF LIME</h4>
                        <div class="items-grid-container-inj" style="max-width:90%; font-size:13px;"></div>
                    </div>
                </div>

            </div>
                

            <!--- SOUTH FLUX SILOS-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span12 print-chart" data-bind="classes: { hide: any(not(hasData_silos)), }">
                    <label class="print-label" style="margin-left:25px !important">SOUTH FLUX SILOS</label>
                    <div style="margin-left: 0%;" class="southSilos"></div>
                </div>
            </div>

            
            
            <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">   
                <div  data-bind="classes: { hide: any(not(hasData_silos)), }">
                    <label class="print-label" style="margin-left:35px !important">SOUTH FLUX SILOS</label>
                    <div class="southSilos_print"></div>
                </div>
            </div>
            
            <div class="pagebreak"> </div>
             <!--- NORTH FLUX SILOS-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span12 print-chart" data-bind="classes: { hide: any(not(hasData_silos)), }">
                    <label class="print-label" style="margin-left:25px !important">NORTH FLUX SILOS</label>
                    <div style="margin-left: 0%;" class="northSilos"></div>
                </div>
            </div>

            
            
            <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">   
                <div  data-bind="classes: { hide: any(not(hasData_silos)), }">
                    <label class="print-label" style="margin-left:35px !important">NORTH FLUX SILOS</label>
                    <div class="northSilos_print"></div>
                </div>
            </div>

            
             <!--- EAF INJECTION + LMF LIME-->
            <div class="row fluid not-print" style="margin-bottom:50px;margin-top:50px;">
                <div class="span12 print-chart" data-bind="classes: { hide: any(not(hasData_silos)), }">
                    <label class="print-label" style="margin-left:25px !important">EAF INJECTION AND LMF LIME</label>
                    <div style="margin-left: 0%;" class="injectionLime"></div>
                </div>
            </div>

            
            
            <div class="row fluid print" style="margin-bottom:50px;margin-top:50px;margin-left:-50px;">   
                <div  data-bind="classes: { hide: any(not(hasData_silos)), }">
                    <label class="print-label" style="margin-left:35px !important">EAF INJECTION AND LMF LIME</label>
                    <div class="injectionLime_print"></div>
                </div>
            </div>


        </div>
    </div>   
   

</div>