USE [IHBoxSystem]
GO


IF DATABASE_PRINCIPAL_ID('silosreport_readWrite') IS NULL
BEGIN
	CREATE ROLE silosreport_readWrite;
end
go


INSERT INTO [FrontEnd].[Routes]
           ([Route]
           ,[ModuleName]
           ,[ModulePath]
           ,[RequiredRole]
       )
     VALUES
           (
		   '!/silos-report(/:productionDate)(/:shiftId)(/:crewId)'
           , 'silos-report'
		   , 'custom-screens/silos-report/'
           , 'silosreport_readWrite'
           
		   )



INSERT INTO [FrontEnd].[Menu]
           ([Parent]
           ,[Name]
           ,[RouteID]
           ,[SortOrder]
           ,[Enabled]
           ,[Visible]
           ,[RequiredRole]
           ,[Group]
          )
     VALUES
           (
		   (select top 1 Id from FrontEnd.menu where Name = 'MES' and Parent is null)
		   ,'Silos Report'
           ,@@IDENTITY
           ,(select Max(SortOrder)+1 from FrontEnd.Menu where Parent = (select Id from frontend.Menu where [Name] = 'MES'))
           ,1
           ,1
           ,'silosreport_readWrite'
           ,NULL
         )
GO

USE IHBoxSystem

EXEC sp_addrolemember 'silosreport_readWrite', 'admin'

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [silosreport_readWrite] -- The role
,@name = N'securedsp-MES.GetSilosReport' -- the procedure
,@value = N'' 

Go


USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'silosreport_readWrite', 'SDI/australtek'
GO


/*------------------------------------------------------Profiles------------------------------------------------------*/
USE [IHBoxSystem]
GO

DECLARE @ModuleId INT

INSERT INTO [SECURITY].[Modules]
		   ([Code]
		   ,[Name])
	 VALUES
		   ('mes_silos_report'
		   ,'MES Silos Report')

		  SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'readWrite'
		   ,'Read/Write'
		   ,'silosreport_readWrite')
GO


update FrontEnd.Routes
	set [Route] = '!/silos-report(/:start)(/:end)'
where ModuleName = 'silos-report'


/*-----------------------------------------------------------------------------------------------------------------------*/
