﻿define([
  'app',
  'modules/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.AlarmCategory = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    name: null,
                    description: null,
                    color: null,
                    active: null,

                }
            ),
            procedures: {
                get: app.DatabaseNames.ELT + '.CAT.GetAlarmCategories',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    name: obj.Name,
                    description: obj.Description,
                    color: obj.Color,
                    active: obj.Active,
                });
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.AlarmCategories = classRef = superRef.extend({
            model: Main.Models.AlarmCategory,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch event type.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});