﻿define([
  'app',
  'modules/catalog/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.Material = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    area: null,
                    furnace: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.CAT.GetMaterials',
            },
            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    area: obj.Area,
                    furnace: obj.Furnace
                });
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.Materials = classRef = superRef.extend({
            model: Main.Models.Material,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch materials.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});