﻿/// <reference path="http://localhost:65492/IndustrialDashboard/Scripts/IndustrialDashboard-debug.js" />
define([
  // Application.
  "app",

  "modules/dateControl",
  "modules/notificationBar",
  "modules/dateTimeScopeControl", 

  //templates-loader
  "js/templates-loader"

],

function (app, DateControl, NotificationBar, DateTimeScopeControl, T) {

    var SubNavBar = { Model: {}, Views: {} }

    SubNavBar.Model = Backbone.Model.extend({
        defaults: {
            dateControl: false
            , notificationBar: false
            , subnavbar: false
            , dateTimeScopeControl: false
            , sections: "4-4-4"
            , span: "12"
            , offset: "0"
        }
        , setAll: function (boolOpt) {
            //sets all subnavbar widgets that are hideable using the same boolean
            var vv = {
                dateControl: boolOpt
                , notificationBar: boolOpt
                , dateTimeScopeControl: boolOpt
            }

            this.set(vv); 
        }
    });

    SubNavBar.Views.Main = Backbone.View.extend({
        template: "subnavbar/subnavbar"
        , id: "subnavbar"
        , title: ""
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        //refreshing only the data, maybe?
        , isCacheable: false
        , initialize: function () {
            this.listenTo(this.model, "change", this.refreshFromModel); 
            this.listenTo(this.model, "change:sections", this.refreshSectionsLayout);
            this.listenTo(this.model, "change:span change:offset", this.refreshSpanOffsetLayout); 

            this.options.subviews = {}; 

            _.bindAll(this); 

            //dateControl model is initialized first cause other views are going to async use it.
            app.models.dateControl = new DateControl.Model();
            
        },

        events: {
            "dblclick #subnavbar-inner": "scrollToTop"
        }, 
        // global view variable (seen in this scope, public to the view, and SHARED BETWEEN OTHER INSTANCES OF THE SAME VIEW)
        // containing all the variables for this view

        //properties that you wanna scope as private variables for each instance of a view should not be placed here
        //the only way i found to maintain the variables between instances of the same view, is either using models,
        // (each view will have its own model so data is not shared between them), or in case you don't want to use a model
        // you can use the Backbone.View.options object, and doing something like
        // this.options.attributes = {}
        // and storing every single variable inside attributes.

        render: function (container, callback) {
            var that = this;
            var thatContainer = container;
            T.render.call(this, this.template, function (tmp) {
                //getInternationalizationData
                if (!that.options.i18n) that.options.i18n = {};
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                    //end:

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp());

                    //start: the view was already loaded an is on a div element, but not appended to the main container
                    //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")

                    app.views.dateControl = new DateControl.Views.Main({ model: app.models.dateControl });
                    app.views.dateControl.render(that.$el.find("#dateControlView_holder"));
                    app.views.dateControl.hide();

                    app.models.dateTimeScopeControl = new DateTimeScopeControl.Model({});
                    app.views.dateTimeScopeControl = new DateTimeScopeControl.Views.Main({ model: app.models.dateTimeScopeControl });
                    app.views.dateTimeScopeControl.render(that.$el.find("#dateTimeScopeControlView_holder")); 
                    app.views.dateTimeScopeControl.hide(); 

                    app.models.notificationBar = new NotificationBar.Model(); 
                    app.views.notificationBar = new NotificationBar.Views.Main({ model: app.models.notificationBar, el: that.$el.find("#notificationBarView_holder") });
                    app.views.notificationBar.render();
                    app.views.notificationBar.hide(); 

                    //:end

                    that.refreshSectionsLayout();
                    that.refreshSpanOffsetLayout(); 
                    that.refreshFromModel(); 

                    //appending view to the main container
                    thatContainer.append(that.$el);

                    if (_.isFunction(callback)) {
                        callback.call(that); 
                    }
                }, false);
            });
        }

        , refreshSectionsLayout: function () {
            try {
                var stylingDict = {
                    "6-6": "sections-span-6-6"
                    , "4-4-4": "sections-span-4-4-4"
                    , "12": "sections-span-12"
                }

                var code = this.model.get("sections");

                var sectionsContainer = this.$("#sections_container");
                sectionsContainer.attr("class", "row-fluid");
                sectionsContainer.addClass(stylingDict[code]);

                //IE8 workaround
                if (Core.Browser.IE == true && Core.Browser.VersionNumber < 9) {
                    switch (code) {
                        case "6-6":
                            sectionsContainer.find(".sections").hide();
                            sectionsContainer.find(".sections.span6").show().first().css("margin-left", 0);
                            break;
                        case "4-4-4":
                            sectionsContainer.find(".sections").hide();
                            sectionsContainer.find(".sections.span4").show().first().css("margin-left", 0);
                            break;
                        case "12":
                            sectionsContainer.find(".sections").hide(); 
                            sectionsContainer.find(".sections.span12").show().first().css("margin-left", 0);
                            break; 
                    }
                }

            } catch (Error) { }
        }

        , refreshSpanOffsetLayout: function () {
            var spanOffset = $(document).find(".subnavbar-span-offset");
            spanOffset.attr("class", "subnavbar-span-offset");
            spanOffset.addClass("span" + this.model.get("span"));
            spanOffset.addClass("offset" + this.model.get("offset")); 
        }

        , refreshFromModel: function (info) {
            //if all addons are loaded then execute, else delay its execution
            if (app.views.dateControl
                && app.views.notificationBar) {

                if (!info || info.changed.dateControl !== undefined) {
                    if (this.model.get("dateControl") == true) {
                        app.views.dateControl.show();
                        this.model.set("subnavbar", true); 
                    } else {
                        app.views.dateControl.hide();
                    }
                }

                if (!info || info.changed.dateTimeScopeControl !== undefined) {
                    if (this.model.get("dateTimeScopeControl") == true) {
                        app.views.dateTimeScopeControl.show();
                        this.model.set("subnavbar", true);
                    } else {
                        app.views.dateTimeScopeControl.hide();
                    }
                }

                if (!info || info.changed.notificationBar !== undefined) {
                    if (this.model.get("notificationBar") == true) {
                        app.views.notificationBar.show();
                        this.model.set("subnavbar", true);
                    } else {
                        app.views.notificationBar.hide();
                    }
                }

                if (!info || info.changed.subnavbar !== undefined) {
                    (this.model.get("subnavbar") == true) ? this.self_show() : this.self_hide();
                }

            } else {
                //delaying execution until all views are instanced correctly.
                setTimeout(this.refreshFromModel, 50); 
            }
        }

        , self_show: function () {
            $(document).find("#content_container").removeClass("hide-subnavbar");
        }

        , self_hide: function () {
            $(document).find("#content_container").addClass("hide-subnavbar");
        }

        , getSectionContainer: function (sectionNumber, spanNumber) {
            try {
                spanNumber = (spanNumber === undefined) ? 4 : spanNumber;

                return this.$("#section" + sectionNumber + "span" + spanNumber).children(".custom_holder");
            } catch (Error) { }
        }

        , scrollToTop: function (params) {
            $('html, body').animate({
                scrollTop: 0
            }, "fast");
        }

        , close: function () {
            this.remove();
            this.unbind();
        }
        , show: function () {
            this.$el.show();
        }
        , hide: function () {
            this.$el.hide();
        }
    });

    // Required, return the module for AMD compliance.
    return SubNavBar;

});
