﻿define([
  'app',
  'modules/catalog/catalog',
],
function (app, Catalog) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Models.Catalog;
        superProto = superRef.prototype;

        Main.Models.Supplier = classRef = superRef.extend({
            defaults: {
                address: null,
                tel: null,
                city: null,
                state: null,
                zip: null,
                country: null,
                contactName: null,
                mail: null,
            },
            parse: function (obj) {
                return {
                    id: obj.Id,

                    active: obj.Active,
                    //description: $.trim(obj.Description),
                    name: $.trim(obj.Name),

                    address: obj.Address,
                    tel: obj.Tel,
                    city: obj.City,
                    state: obj.State,
                    zip: obj.Zip,
                    country: obj.Country,
                    contactName: obj.ContactName,
                    mail: obj.Mail,
                };
            },
            procedures: {
                get: app.DatabaseNames.MES + '.CAT.GetSuppliers',
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Catalog.Collections.Catalogs;
        superProto = superRef.prototype;

        Main.Collections.Suppliers = classRef = superRef.extend({
            model: Main.Models.Supplier,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if (resp.Table) {
                                opt.success(_.map(resp.Table, classRef.prototype.model.prototype.parse));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch suppliers.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});