﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"];
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />


<script id="modal_trigger_acceptance_wrong_mo" type="text/x-handlebars-template">            
    <link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
    
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <span style="font-weight:bold;font-size: 22px;" data-bind="text: ModalTitle"> </span> 
    </div>
    <div style="height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="min-height:300px;padding-bottom:0;" class="modal-body">      

            <div class="row-fluid">
                <div class="span2" style="font-weight:bold;margin-top:10px">
                    <asp:Localize runat=server meta:resourcekey=melt_order_label />
                </div>
                <div class="span10">                    
                    <div id="meltOrders" style="margin-left:13px"></div>
                </div>
            </div>
            <div style="margin-top:10px;margin-bottom:10px">             
               <label style="margin-left:0px;margin-bottom:0 !important; ">
                    <span style="font-weight:bold;margin-right:10px">                     
                        <asp:Localize runat=server meta:resourcekey=steel_weight_label />
                    </span>                 
                    <input type="text" id="steelWeight" style="width:90px; text-align:center" data-bind="value: SteelWeight," />
                </label>   
           </div>

    
           
            <hr style="margin-top:50px"/>

            <div class="row-fluid">     
                <div class="span2"></div>           
                <div class="span8">                      
                     <label style="margin-left:5px;margin-bottom:0 !important; ">
                         <span style="margin:10px; font-weight:bold;margin-right:24px">                     
                            <asp:Localize runat=server meta:resourcekey=grade_label />
                         </span>                 
                            <input type="text" id="gradeName" style="width:180px; text-align:left" data-bind="value: GradeName,"  disabled/>
                    </label>
                </div>
            </div>
             <div class="row-fluid">
                <div class="span2"></div>
                <div class="span8">                    
                    <label style="margin-left:5px;margin-bottom:0 !important; ">
                         <span style="margin:10px; font-weight:bold;margin-right:36px">                     
                            <asp:Localize runat=server meta:resourcekey=size_label />
                         </span>                 
                        <input type="text" id="size" style="width:180px; text-align:left" data-bind="value: Size,"  disabled/>
                    </label>
                </div>
            </div>

            <hr />



        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" class="btn btn-primary pull-left" style="width:200px;height:50px;">
            <asp:Localize runat='server' meta:resourcekey='save_btn_label' />
        </button>
        <button id="cancelBtn" class="btn btn-secondary" data-dismiss="modal" style="height:50px">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>
