﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<link href="<%= ResolveUrl("~/assets/css/animate.css") %>" rel="stylesheet" />

<style type="text/css">

    .nb-container {
        width:100%;
        border-radius:3px; 
        background-color: rgba(0,0,0,.05);
        background-clip: padding-box;
        border: solid transparent;
        border-width: 1px 1px 1px 6px;
        height:auto;
        padding: 2px 0px 2px 0px;
        box-shadow: inset 1px 1px 1px rgba(0,0,0,.1),inset 0 -1px 0 rgba(0,0,0,.07); 
    }

        .nb-container .nb-container-ul {
            width:100%; 
        }

            .nb-container .nb-container-ul li {
                width:100%;    
            }

            .nb-container .nb-container-ul li.nb-li:hover {
                background-color:#fef6d7; 
                cursor:pointer;
            }

            .nb-container .nb-container-ul a {
                text-decoration:none;
                width:100%;
                height:100%; 
                display:inline-block; 
            }

            .nb-container .nb-container-ul .nb-msg-datetime {
                margin-left:5px; 
                margin-right:5px;
                color:#808080; 
                font-size:11px; 
            }

            .nb-container .nb-container-ul .nb-msg-placeholder {
                margin-left:5px; 
                margin-right:5px;
                color:#808080; 
                font-size:13px; 
            }

            .nb-container .nb-container-ul .nb-msg-body {
                color: #262626; 
                font-size:13px; 
                overflow:hidden; 
            }

    .notifications-count-badge {
        position:absolute;
        margin-left:-25px;
    }

</style>

<div class="span8">
    <span id="notifications_count_badge" class="badge badge-important notifications-count-badge animated bounceIn"></span>
    <div id="notification_bar_container" class="nb-container">
        <div id="ticker1_container">
            <ul id="ticker1_ul" class="nb-container-ul">
                <li class="nb-start"><span id="no-new-notifications" class="nb-msg-placeholder">No new notifications.</span></li>
                <li class="nb-start"></li>

                <%--<li class="nb-li firstElem"><span class="nb-msg-datetime">12:04</span><span class="nb-msg-body">Message 1 has happened!</span></li>
                <li class="nb-li"><span class="nb-msg-datetime">12:25</span><span class="nb-msg-body">Message 2 has happened! Message 1 sucks!</span></li>

                <li class="nb-li"><span class="nb-msg-datetime">12:04</span><span class="nb-msg-body">Message 3 has happened!</span></li>
                <li class="nb-li"><span class="nb-msg-datetime">12:25</span><span class="nb-msg-body">Message 4 has happened! Message 1 sucks!</span></li>

                <li class="nb-li"><span class="nb-msg-datetime">12:04</span><span class="nb-msg-body">Message 5 has happened!</span></li>
                <li class="nb-li"><span class="nb-msg-datetime">12:25</span><span class="nb-msg-body">Message 6 has happened! Message 1 sucks!</span></li>--%>

                <li class="nb-end"></li>

            </ul>
        </div>
    </div>
</div>
<div class="span3">
    <div class="row-fluid">
    <a id="nb_button_prev" class="btn btn-mini" style="margin:0;"><i class="icon-chevron-up"></i></a>
    <a id="nb_button_top" data-toggle="tooltip" data-placement="right" data-original-title="Go to top"  class="btn btn-mini tooltip-this" style="margin:0;"><i class="icon-arrow-up"></i></a>
    </div>
    <div class="row-fluid">
    <a id="nb_button_next" class="btn btn-mini" style="margin:0;"><i class="icon-chevron-down"></i></a>
    <a id="nb_button_seeAll" data-toggle="tooltip" data-placement="right" data-original-title="See all" class="btn btn-mini tooltip-this" style="margin:0;"><i class="icon-plus"></i></a>
    </div>
</div>