/*
  backgrid-infinator
  https://github.com/bhvaleri/backgrid-infinator

  Copyright (c) 2013 Bill Valeriote
  Licensed under the MIT @license.
*/

(function ($, _, Backbone, Backgrid) {

    //added by jsantaana cause underscore is not defined when getting it from amd
    _ = this._;

    "use strict";

    /**
       Infinator is footer element that allows for "infinite scroll" until the
       data runs out.
  
       The optional Scroll to Top overlay assume that there is only 1 element 
       with an infinite-container class.
  
       @class Backgrid.Extension.Infinator
    */
    Backgrid.Extension.Infinator = Backgrid.Footer.extend({

        /** @property */
        className: "infinator",

        /** @property */
        throttleWait: 100,

        /** @property */
        scrollToTop: false,

        /** @property */
        enabled: true, 

        __toTopShowing: false,

        initialize: function (options) {
            var that = this; 
            Backgrid.Footer.prototype.initialize.call(this, options);

            var collection = this.collection;

            this.scrollToTop && this.initializeToTop();
            
            var that = this; 
            this.event_onscroll = _.throttle(function () {
                //do not process anything if enabled is false
                if (!that.enabled) return;

                var docHeight = $(document).height();
                var viewportHeight = $(window).height();
                var scrollTop = $(window).scrollTop();
                var containerTop = $('.infinite-container').position().top;

                //ADD SCROLLTOP != 0 'CAUSE WITHOUT THIS , A BACKGRID THAT HIS WIDTH IS BIGGER THAN THE SCREEN
                //ON SCROLLING , THIS EXECUTES THE PAGINATION.
                if ((scrollTop != 0) && (viewportHeight + scrollTop > docHeight - 100)) {
                    collection.getNextPage();
                }
            }, this.throttleWait)

            this.attachEvents({ tryDettach: false }); 

            _.bindAll(this); 
        },

        event_onscroll: function () { },

        event_totop_onscroll: function () {
            var scrollTop = $(window).scrollTop();
            var containerTop = $('.infinite-container').position().top;

            if ((scrollTop > containerTop) && !this._toTopShowing) {
                this.showToTop();
            }

            if ((scrollTop < containerTop) && this._toTopShowing) {
                this._toTopShowing = false;
                $('.to-top').animate({ bottom: '-100px' });
            }
        }, 

        initializeToTop: function () {
            $('.infinite-container').append('<button class="to-top">Scroll to Top</button>');

            var containerTop = $('.infinite-container').position().top;

            $('.to-top').click(_.bind(function () {
                $('body, html').animate({ scrollTop: containerTop },
                  _.bind(function () { this._toTopShowing = false; }, this));
                $('.to-top').animate({ bottom: '-100px' });
            }, this));
        },

        showToTop: function () {
            this._toTopShowing = true;
            $('.to-top').animate({ bottom: 0 });
        },

        attachEvents: function (opt) {
            var options = {
                tryDettach: true, 
            };

            options = _.extend(options, opt); 

            if (!this.enabled && !options.tryDettach) return; 

            if (options.tryDettach) {
                $(window).off("scroll", this.event_onscroll);
                $(window).off("scroll", this.event_totop_onscroll); 
            }

            if (this.enabled) {
                $(window).on("scroll", this.event_onscroll); 
                if (this.scrollToTop) {
                    $(window).on("scroll", this.event_totop_onscroll); 
                }
            }
        }, 

        setEnabled: function (enabled) {
            this.enabled = enabled;
            this.attachEvents(); 
        }, 
    });

}(jQuery, _, Backbone, Backgrid));
