﻿using Helpers.Log;
using log4net;
using System;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Web.UI;

public partial class landing_systemInitialConfiguration : Page
{
    private JavaScriptSerializer jss = new JavaScriptSerializer();
    private ILog logger = Logger.GetLogger(MethodBase.GetCurrentMethod().DeclaringType.Name);
        
    protected void Page_Load(object sender, EventArgs e)

    {
        Response response;

        try
        {
            string action = Request.Form["action"];

            if (action != null)
            {
                switch (action.ToString().ToUpper())
                {
                    case "GET_CONFG_OPER_STATUS":
                        response = new Response
                        {
                            Data = new 
                            {
                                ConfigurationStatus = IhBoxSystemtConfiguration.InitialConfigurationStatus.ToString(),
                                PreviousConfigurationResult = IhBoxSystemtConfiguration.PreviousConfigurationResult,
                                PreviousConfigurationResultId = IhBoxSystemtConfiguration.PreviousConfigurationResultId,
                            },
                        };
                        break;
                    //case "GET_SYSTEM_TIME_ZONES":
                    //    response = new Response
                    //    {
                    //        Data = IhBoxSystemtConfiguration.GetSystemTimeZones(),
                    //    };
                    //    break;
                    case "SET_INIT_SYSTEM_CONFIG":
                        NetworkInterfaceInfo ethernetConfig = jss.Deserialize<NetworkInterfaceInfo>(Request.Form["networkEthernet"]);
                        WifiNetworkInterfaceInfo wifiConfig = jss.Deserialize<WifiNetworkInterfaceInfo>(Request.Form["networkWifi"]);

                        ethernetConfig.Name = this.GetNicName(ethernetConfig.Name);
                        wifiConfig.Name = this.GetNicName(wifiConfig.Name); 

                        SystemDatetimeConfiguration sysDatetimeConf = jss.Deserialize<SystemDatetimeConfiguration>(Request.Form["datetime"]);

                        response = IhBoxSystemtConfiguration.SetInitialConfiguration(ethernetConfig, wifiConfig, sysDatetimeConf);
                        break;
                    case "RESET_TO_FACTORY_DEFAULTS":
                        response = IhBoxSystemtConfiguration.ResetToFactoryDefaults(); 
                        break; 
                    default:
                        response = new Response
                        {
                            Success = false,
                            Message = string.Format("Action '{0} is not supported'.", action),
                        };
                        break;
                }
            }
            else
            {
                response = new Response
                {
                    Success = false,
                    Message = "Parameter 'Action' can not be empty or null.",
                };
            }
        }
        catch (Exception ex)
        {
            response = new Response
            {
                Success = false,
                Message = "Exception.",
            };

            this.logger.Error(ex);
        }


        Response.Clear();
        Response.ContentType = "application/json; charset=utf-8";
        Response.Write(jss.Serialize(response));
        Response.End();
    }

    private String GetNicName(String type)
    {
        String nicName = IhBoxSystemtConfiguration.NETWORK_ETHERNET_NIC_NAME;
        switch (type.ToUpper())
        {
            case IhBoxSystemtConfiguration.NETWORK_TYPE_ETHERNET:
                nicName = IhBoxSystemtConfiguration.NETWORK_ETHERNET_NIC_NAME;
                break;
            case IhBoxSystemtConfiguration.NETWORK_TYPE_WIFI:
                nicName = IhBoxSystemtConfiguration.NETWORK_WIFI_NIC_NAME;
                break;
        }

        return nicName;
    }

}