﻿<%@ Page Title="" Language="C#" MasterPageFile="~/landing/landing_base.master" AutoEventWireup="true" CodeFile="login.aspx.cs" Inherits="landing_login" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
    string siteLang = "EN";
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        siteLang = (lang != null) ? lang.Value : siteLang;
        UICulture = siteLang;
        Culture = siteLang;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(siteLang);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(siteLang);
        base.InitializeCulture();
    }
</script>
<asp:Content ID="head" ContentPlaceHolderID="content_head" runat="Server">

    <link rel="stylesheet" type="text/css" href="<%= ResolveUrl("../boostrap-panel.css") %>">

    <style>

        body {
            background:#FFF !important; 
        }

        div.member_signin {
            text-align: center;
        }

        div.member_signin  i.fa.fw-icon-user {
            color: #FFF;
            background-color: #0f8aa5;
            border-radius: 500px;
            font-size: 36px;
            padding: 15px 20px 15px 20px;
        }

        div.fa_user {
            margin-top: -32px;
            margin-bottom: 30px;
        }

        p.member {
            font-size: 19px;
            color: #888888;
            margin-bottom: 20px;
        }

        button.login {
            width: 100%;
            text-transform: uppercase;
        }

        form.loginform div.input-group {
            width: 100%;
        }

        form.loginform input[type="text"], form.loginform input[type="password"] {
            color: #6C6C6C;
            text-align: center;
        }

        p.forgotpass {
            margin-top: 10px;
        }

        p.forgotpass a {
            color: #F5683D;
        }

        .click-to-autologin {
            color:#1f8cba !important;
        }

        .click-to-autologin:hover, .click-to-autologin:focus{
            text-decoration:underline !important;
        }

    </style>

    <script src="<%= ResolveUrl("~/assets/libs/js/sweetalert/lib/sweet-alert.js") %>"></script>
    <link rel="stylesheet" type="text/css" href="<%= ResolveUrl("~/assets/libs/js/sweetalert/lib/sweet-alert.css") %>">

    <script src="<%= ResolveUrl("~/assets/libs/js/jqBootstrapValidation/jqBootstrapValidation.js") %>"></script>

    <script src="<%= ResolveUrl("login.js?v=1.0.0.1") %>"></script>

    <script type="text/javascript">
        var _Includer = new window.Includer({
            Widgets: [
                'SecurityLogin'
            ]
            , ExternalWidgets: [
            ]
            , XML: { Available: false }
        });
    </script>

    <script>
        function tryAutoLogin() {
            if (window && window["autoLogin"]) {
                setTimeout(autoLogin, 500);
            } else {
                setTimeout(tryAutoLogin, 200); 
            }
        }
        //tryAutoLogin(); 
    </script>

</asp:Content>
<asp:Content ID="body" ContentPlaceHolderID="content_body" runat="Server">

    
    <div class="container" style="margin-top: 4%;">
        <div class="row-fluid">
            <div class="span4 offset4">
                <div class="big-blue-header">
                    <div style="padding-bottom:0px; " class="panel member_signin">
                    <div id="login_panel" class="panel-body login-panel" runat="server">
                        <div class="fa_user">
                            <i class="fa fw-icon-user"></i>
                        </div>
                        <label><asp:Localize ID="Localize1" runat="server" meta:resourcekey="log_into_ih_box_label" /></label>
                        <hr />

                        <form role="form" class="loginform">
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" class="form-control span10" id="username" autofocus="autofocus"
                                        placeholder="<asp:Localize ID="Localize10" runat="server" meta:resourcekey="email_placeholder" />">
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="password" class="form-control span10" id="password"
                                        placeholder="<asp:Localize ID="Localize11" runat="server" meta:resourcekey="password_placeholder" />">
                                </div>
                            </div>
                            <a class="click-to-autologin hide" href="javascript: void(0)" onclick="tryAutoLogin()"><span style="font-size:14px;"><asp:Localize runat="server" meta:resourcekey="or_login_using_domain" /></span></a>
                            <button style="margin-top:10px;" type="submit" class="btn btn-primary btn-md login"><asp:Localize ID="Localize2" runat="server" meta:resourcekey="login_btn_label" /></button>
                            <div style="display:none;" class="login-spinner">
                                <img style="width:32px;height:32px;padding:5px; margin-top:0px; margin-bottom:0; " src="../../assets/img/spinner32.gif" />
                            </div>
                        </form>
                    </div>

                    <div id="login_with_domain_panel" style="display:none;" class="panel-body login-with-domain-panel" runat="server">
                        <div class="fa_user">
                            <i class="fa fw-icon-user"></i>
                        </div>
                        <label><asp:Localize runat="server" meta:resourcekey="log_into_ih_box_with_domain_label" /></label>
                        <hr />

                        <form role="form" class="loginform">
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" class="form-control span10" id="domain_username"
                                        placeholder="<asp:Localize runat="server" meta:resourcekey="user_domain_placeholder" />">
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="password" class="form-control span10" id="domain_password"
                                        placeholder="<asp:Localize runat="server" meta:resourcekey="password_placeholder" />">
                                </div>
                            </div>
                            <button style="margin-top:10px;" type="submit" class="btn btn-primary btn-md login-with-domain"><asp:Localize runat="server" meta:resourcekey="login_btn_label" /></button>
                            <div style="display:none;" class="login-spinner">
                                <img style="width:32px;height:32px;padding:5px; margin-top:0px; margin-bottom:0; " src="../../assets/img/spinner32.gif" />
                            </div>
                        </form>
                    </div>

                    <div id="forgot_password_panel" style="display:none;" class="panel-body forgot-password-panel" runat="server">
                        <div class="fa_user">
                            <i class="fa fw-icon-user"></i>
                        </div>
                        <label><asp:Localize ID="Localize3" runat="server" meta:resourcekey="recover_password_label" /></label>
                        <hr />
                        <h6><asp:Localize ID="Localize4" runat="server" meta:resourcekey="recover_password_msg" /></h6>

                        <hr />
                        
                        <div class="recover-admin-default-password-main-panel">
                            <div class="recover-admin-default-password-spinner">
                                <%--<img style="width:32px;height:32px;padding:5px; margin-top:0px; margin-bottom:0; " src="<%= ResolveUrl("../../assets/img/spinner32.gif") %>" />--%>
                                <span style="font-size:32px;">...</span>
                            </div>
                            <div class="recover-admin-default-password-panel hide">
                                <span style="font-size:14px;">
                                    <asp:Localize runat="server" meta:resourcekey="enter_provided_code_to_reset_message" />
                                </span>
                                <form class="form recover-password-admin-form" style="margin-top:5px;">
                                    <input required id="recover-password-input" type="text" placeholder="<asp:Localize runat="server" meta:resourcekey="enter_code_placeholder" />" />
                                    <button type="submit" class="btn btn-small"><asp:Localize runat="server" meta:resourcekey="reset_password_btn_label" /></button>
                                </form>
                            </div>
                            <div class="has-default-password-panel hide">
                                <span style="font-size:14px;color:red;">
                                    <asp:Localize ID="Localize9" runat="server" meta:resourcekey="using_default_password_message" />
                                </span>
                            </div>
                        </div>

                        <%--<form role="form" class="forgot-password-form" novalidate>
                            
                            <div class="form-group">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="input-group">
                                            <input required data-validation-required-message="Este campo es requerido" data-validation-email-message="No es una dirección de e-mail válida" type="email" class="form-control span10" id="email-forgot-password" placeholder="E-mail">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button style="margin-top:10px;" type="submit" class="btn btn-primary btn-md forgot-password-next">Siguiente</button>
                            <div style="display:none;" class="forgot-password-spinner">
                                <img style="width:32px;height:32px;padding:5px; margin-top:0px; margin-bottom:0; " src="<%= ResolveUrl("../../assets/img/spinner32.gif") %>" />
                            </div>
                        </form>--%>
                    </div>

                    <div id="recovering_password_panel" class="panel-body recovering-password-panel hide" runat="server">
                        <div class="processing-code">
                            <h5>
                                <asp:Localize runat="server" meta:resourcekey="processing_code_message" />
                            </h5>
                            <div class="reset-password-spinner">
                                <img style="width:32px;height:32px;padding:5px; margin-top:0px; margin-bottom:0; " src="<%= ResolveUrl("../../assets/img/spinner32.gif") %>" />
                            </div>
                            <br />
                            <span style="font-size:12px;font-weight:bold;">
                                <asp:Localize runat="server" meta:resourcekey="this_process_could_take_up_to_message" />
                            </span>
                        </div>
                        <div class="code-process-success" style="display:none;">
                            <h5>
                                <asp:Localize runat="server" meta:resourcekey="the_administrator_password_reset_success" /><br />
                                <br />
                                <asp:Localize runat="server" meta:resourcekey="to_continue_message" />
                            </h5>
                        </div>
                        <div style="display:none;" class="error-in-code">
                            <span style="font-size:18px;">
                                <asp:Localize runat="server" meta:resourcekey="something_went_wrong_processing_code" />
                            </span>
                            <br />
                            <br />
                            <a href="login.aspx?action=forgot_password">
                                <asp:Localize runat="server" meta:resourcekey="try_again_message" />
                            </a>
                        </div>
                    </div>

                    <div id="reset_password_panel" style="display:none;" class="panel-body reset-password-panel" runat="server">
                        <div class="fa_user">
                            <i class="fa fw-icon-user"></i>
                        </div>
                        <label><asp:Localize ID="Localize5" runat="server" meta:resourcekey="new_password_label" /></label>
                        <hr />
                        <form role="form" class="reset-password-form" novalidate>
                            <div class="form-group">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="input-group">
                                            <input name="new-password" required data-validation-required-message="<asp:Localize ID="Localize12" runat="server" meta:resourcekey="field_required_validation_msg" />" type="password" class="form-control span10" id="new-password"
                                                placeholder="<asp:Localize ID="Localize13" runat="server" meta:resourcekey="password_placeholder" />">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="input-group">
                                            <input required data-validation-required-message="<asp:Localize ID="Localize14" runat="server" meta:resourcekey="field_required_validation_msg" />" data-validation-matches-match="new-password" data-validation-matches-message="<asp:Localize ID="Localize15" runat="server" meta:resourcekey="must_match_password_validation_msg" />" type="password" class="form-control span10" id="new-password-repeat"
                                                placeholder="<asp:Localize ID="Localize16" runat="server" meta:resourcekey="repeat_password_label" />">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button style="margin-top:10px;" type="submit" class="btn btn-primary btn-md reset-password-next"><asp:Localize ID="Localize6" runat="server" meta:resourcekey="change_password_btn_label" /></button>
                            <div style="display:none;" class="reset-password-spinner">
                                <img style="width:32px;height:32px;padding:5px; margin-top:0px; margin-bottom:0; " src="<%= ResolveUrl("../../assets/img/spinner32.gif") %>" />
                            </div>
                        </form>
                    </div>

                </div>
                </div>
                <div class="text-center">
                    <p><a style="display:none;" id="login_link" href="../login/login.aspx" runat="server"><asp:Localize ID="Localize7" runat="server" meta:resourcekey="log_in_label" /></a></p>
                    <p><a id="forgot_password_link" href="login.aspx?action=forgot_password" runat="server"><asp:Localize ID="Localize8" runat="server" meta:resourcekey="forgot_your_password_label" /></a></p>
                </div>
            </div>
        </div>
    </div>
</asp:Content>

