﻿using Helpers.Log;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Web;
using System.Web.Script.Serialization;
using System.Web.UI;
using System.IO;
using System.Web.UI.WebControls;
using System.Xml.Linq;

public partial class app_custom_screens_IHConfiguration_data_sources_configuration_v2_api_add_local_plc : System.Web.UI.Page
{
    private JavaScriptSerializer jss = new JavaScriptSerializer();
    private ILog logger = Logger.GetLogger(MethodBase.GetCurrentMethod().DeclaringType.Name);
    
    protected void Page_Load(object sender, EventArgs e)
    {
        object response = null;

        try
        {
            string action = Request.Form["action"];
            string name = Request.Form["PLCName"];
            string accountNumber = Request.Form["accountNumber"]; 

            if (action != null)
            {
                switch (action.ToString().ToUpper())
                {
                    case "ADD_LOCAL_PLC":
                        this.AddLocalPLC(name); 
                        response = new Response();
                        break;
                    case "REMOVE_LOCAL_PLC":
                        this.RemoveLocalPLC(name);
                        response = new Response();
                        break;
                }
            }
            else
            {
                response = new Response
                {
                    Success = false,
                    Message = "Parameter 'Action' can not be empty or null.",
                };
            }
        }
        catch (Exception ex)
        {
            response = new Response
            {
                Success = false,
                Message = ex.Message,
            };

            this.logger.Error(ex);
        }

        Response.Clear();
        Response.ContentType = "application/json; charset=utf-8";
        Response.Write(jss.Serialize(response));
        Response.End();
    }

    private void AddLocalPLC(string name, string accountNumber = "100020")
    {
        IhBoxSystemtConfiguration.AddLocalPLC(name, accountNumber); 
    }

    private void RemoveLocalPLC(string name)
    {
        IhBoxSystemtConfiguration.RemoveLocalPLC(name);
    }
}