﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link class="css-load" href="<%= ResolveUrl("~/assets/libs/js/codemirror/lib/codemirror.css") %>" rel="stylesheet" />
<link class="css-load" href="<%= ResolveUrl("~/assets/libs/js/codemirror/addon/lint/lint.css") %>" rel="stylesheet" />
<link class="css-load" href="<%= ResolveUrl("~/assets/libs/js/codemirror/addon/hint/show-hint.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
    
<div class="row-fluid">
    <div class="offset3 span9 subnavbar fixed-subnavbar">
        <div class="row-fluid form-inline">
            <label class="control-label">
                <asp:localize runat=server meta:resourcekey=dot_program_combo_label/>
                <select class="input-medium" data-bind="value: integer(dotProgramId), options: dotPrograms, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=dot_programs_combo_def_opt />', value: 0 }, enabled: hasDotPrograms,"></select>
            </label>
<%--                <label class="control-label">
                <asp:localize runat="server" meta:resourcekey="dot_combo_label" />
                <select class="input-medium" data-bind="value: integer(dotId), options: dots,
                        optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=dot_combo_def_opt />', value: 0 }, 
                        enabled: hasDots"></select>
            </label>--%>
            <button id="compileBtn" class="btn btn-success"><asp:localize runat=server meta:resourcekey=compile_btn_title/></button>
        </div>
    </div>
</div>

<div class="row-fluid content-under-fixed-sbunavbar">
    <div style="position:relative;width:100%;">
        <div style="width:34%;float:left;top:200px;left:200px;">
            <div id="code"></div>
            <%--<textarea id="code">
D1 = D2 && D3
jump(D1;"test")
D3 = D4 && D5
::test
D1 = D2 && D3</textarea>--%>
        </div>
        <textarea id="frames" style="position:relative;float:right;width:53%;height:293px;margin-left:1%;overflow-y:auto;border:1px solid #d5d5d5;background-color:#fff;font-size:10px;"></textarea>
        <textarea id="bytesCode" style="position:relative;float:right;width:8%;height:293px;margin-left:5px;overflow-y:auto;border:1px solid #d5d5d5;background-color:#fff;font-size:12px;"></textarea>
    </div>
    <%--<div style="position:relative;float:left;width:100%;">
        <div style="position:relative;float:left;margin-left:30px;">
            <h5 style="margin:0;">Variables Input</h5>
            <ul>
                {{#each variablesInput}}
                <li>{{this}}</li>
                {{/each}}
            </ul>
        </div>
        <div style="position:relative;float:left;margin-left:30px;">
            <h5 style="margin:0;">Variables Output</h5>
            <ul>
                {{#each variablesOutput}}
                <li>{{this}}</li>
                {{/each}}
            </ul>
        </div>
        <div style="position:relative;float:left;margin-left:30px;">
            <h5 style="margin:0;">Methods</h5>
            <ul>
                {{#each functions}}
                <li>{{this}}</li>
                {{/each}}
            </ul>
        </div>
        <div style="position:relative;float:left;margin-left:30px;">
            <h5 style="margin:0;">Keyboard</h5>
            <ul>
                <li>Ctrl + Space: Autocomplete</li>
                <li>Ctrl + Y: Redo</li>
                <li>Ctrl + Z: Undo</li>
            </ul>
        </div>
        <div style="position:relative;float:left;margin-left:60px;">
            <h5 style="margin:0;">Code Example</h5>
            <div>
                <span>D1 = D2 && D3</span><br />
                <span>jump(D1;"test")</span><br />
                <span>D3 = D4 && D5</span><br />
                <span>::test</span><br />
                <span>D1 = D2 && D3</span><br />
            </div>
        </div>
    </div>--%>
</div>

<%--<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar">
            <div class="form-inline">
                <label class="control-label">
                    <asp:localize runat="server" meta:resourcekey="dot_combo_label" />
                    <select class="input-medium" data-bind="value: integer(dotId), options: dots,
                            optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=dot_combo_def_opt />', value: 0 }, 
                            enabled: hasDots"></select>
                </label>
            </div>
        </div>
    </div>
</script>--%>


