﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span6">
            <h5><asp:Localize runat="server" meta:resourcekey="delay_codes_title" /></h5>
<%--            <div style="margin-bottom:5px;">
                <button class="btn btn-mini btn-add-code"><asp:Localize runat="server" meta:resourcekey="add_code_label" /></button>
            </div>--%>
            <div style="height:90vh;overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span6">
            <div class="code-configuration-container row-fluid">
            </div>
        </div>
    </div>
</div>

</script>

<script id="code_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="row-fluid">
                <h5><asp:Localize runat="server" meta:resourcekey="code_label" /> [ {{code}} ]</h5>
                <hr />
            </div>
            <div class="row-fluid">
                <form class="form-horizontal">
                    {{#ifEquals hasChildren false}}
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="category_label" /></label>
                        <div class="controls">
                            <select style="float:left;" data-bind="value: integer(category), options: categoriesBinding, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-medium" >
                            </select>
                            <div data-bind="css: { 'background-color': categoryColor }" style="border:1px solid #ccc; margin-top:2px; margin-left:10px;width:25px;height:25px;float:left;">
                            </div>
                        </div>
                    </div>
                    {{/ifEquals}}
                    <div class="control-group">
                        <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="description_label" /></label>
                        <div class="controls">
                            <textarea rows="5" data-bind="value: description,events:['keyup']">
                            </textarea>
                        </div>
                    </div>
                    {{#ifEquals hasChildren false}}
                   <%-- <div class="control-group">
                        <label class="control-label" for="checkboxes"><asp:Localize runat="server" meta:resourcekey="use_tag_to_declare" /></label>
                        <div class="controls">
                            <input data-bind="checked: useTagToDeclare" type="checkbox" name="checkboxes" id="checkbox-1">
                        </div>
                    </div>--%>
                    {{/ifEquals}}
                    <!-- AUTO DECLARE CONFIGURATION -->
                    <div data-bind="toggle: useTagToDeclare">
                        <div class="control-group">
                            <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="tag_to_declare_id" /></label>
                            <div class="controls">
                                <select data-bind="value: integer(tagToDeclareId), options: tagsBindingDigital, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" id="select2" name="selectbasic" class="input-xlarge" >
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- END AUTO DECLARE CONFIGURATION -->
                    {{#ifEquals hasChildren false}}
                 <%--   <div class="control-group">
                        <label class="control-label" for="checkboxes"><asp:Localize runat="server" meta:resourcekey="exclude_from_ava_label" /></label>
                        <div class="controls">
                            <input data-bind="checked: excludeFromAvailability" type="checkbox" name="checkboxes" id="checkboxes-0">
                        </div>
                    </div>--%>
                    {{/ifEquals}}
                    <!-- MAX TIME ALLOWED CONFIGURATION -->
                    {{#ifEquals hasChildren false}}
                    <div data-bind="toggle: excludeFromAvailability">
                        <div class="control-group">
                            <label class="control-label" for="max_time_allowed_checkbox"><asp:Localize runat="server" meta:resourcekey="max_time_allowed_label" /></label>
                            <div class="controls">
                                <input data-bind="checked: configureMaxTimeAllowed" type="checkbox" name="max_time_allowed_checkbox">
                            </div>
                        </div>
                        <div data-bind="toggle: configureMaxTimeAllowed" class="control-group">
                            <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="max_time_label" /></label>
                            <div class="controls">
                                <input type="text" class="input-small" data-bind="value: maxTimeAllowed, events: ['keyup']" />
                                <select data-bind="value: maxTimeAllowedTime, optionsDefault: 'DEFAULT'" class="input-small">
                                    <option value='DEFAULT'>...</option>
                                    <option value='SECOND'><asp:Localize runat="server" meta:resourcekey="seconds_option_label" /></option>
                                    <option value='MINUTE'><asp:Localize runat="server" meta:resourcekey="minutes_option_label" /></option>
                                    <option value='HOUR'><asp:Localize runat="server" meta:resourcekey="hours_option_label" /></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    {{/ifEquals}}
                    <!-- END MAX TIME ALLOWED CONFIGURATION -->
                </form>
            </div>
        </div>
        <div style="margin-top:8px;" class="row-fluid">
            <div class="span6 offset3">
                <div class="span6">
                    <button disabled="disabled" class="btn btn-primary btn-block btn-save"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6">
                    <button disabled="disabled" class="btn btn-block btn-cancel"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>