﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<%--<script id="main_template" type="text/x-handlebars-template">--%>
    
    
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/caster-equipments-tree/caster-equipments-tree.css")%>" rel="stylesheet" />


<div class="screen-content">
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="span4 tree-border ">
                <h4 class="tree-title-label">Online</h4>  
                <hr class="hr-tree"/>
                <div style="height:83vh;overflow-y:auto;" class="onlineTree" id="online">
                </div>
            </div>
            <div class="span4 tree-border ">
                <h4 class="tree-title-label">Offline</h4>     
                <hr class="hr-tree"/>
                <div style="height:83vh;overflow-y:auto;" class="offlineTree" id="offline">
                </div>

            </div>
            <div class="span4 details-border ">
                <div class="equipment-details-container row-fluid" style="height:90vh;padding-left:5px">
                </div>
            </div>
        </div>
        <div class="loading-script-container" >

        </div>
     <%--   <div class="loading-bar loading-poster text-center modal-backdrop fade in" data-bind="classes: { hide: not(treeDataLoading), }" >
            <h4 class="loading-text">Loading...</h4>
            <div style="width:40%;margin-left: 60vh;" class="progress progress-striped active">
                <div class="bar" style="width: 100%;"></div>
            </div>
        </div>--%>


    </div>
</div>

<script id="loading_script" type="text/x-handlebars-template">
      <div class="loading-bar loading-poster text-center modal-backdrop fade in" >
            <h4 class="loading-text">Loading...</h4>
            <div style="width:40%;margin-left: 60vh;" class="progress progress-striped active">
                <div class="bar" style="width: 100%;"></div>
            </div>
        </div>
</script>

<script id="equipment_details" type="text/x-handlebars-template">
      <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>
    </div>

    <div class="details-info" data-bind="classes: { hide: any(not(hasData), isLoading), }" >
        <div data-bind="classes: { 'status-ok':       showStatusOk, }"          style="float: left;margin-top: 0px !important;"></div>
        <div data-bind="classes: { 'status-empty':    showStatusEmpty, }"       style="float: left;margin-top: 0px !important;"></div>
        <div data-bind="classes: { 'status-warning':  showStatusWarning, }"     style="float: left;margin-top: 0px !important;"></div>
        <div data-bind="classes: { 'status-alert':    showStatusAlert, }"       style="float: left;margin-top: 0px !important;"></div>


        <h4 data-bind="text: title" class="details-labels"></h4>
        <hr />
        <div class="container-fluid" style="margin-top:2vh !important;">      
            <div class="row-fluid"> 
                <div class="main-info-grid-container grids-container"></div>
            </div>
        </div>    
        <div class="container-fluid" data-bind="classes: { hide: not(hasL2PartId), }" style="margin-top:2vh !important;">
            <h4 class="details-labels">Metrics</h4>
            <hr />
         <%--   <div class="row-fluid"> 
                <div class="metrics-grid-container grids-container"></div>
            </div>--%>
            <div class="row-fluid">
                <div class="grids-container">
                    <table class="grid-styles table">
                        <thead>
                           
                            <tr>
                                 <th rowspan="2" class="sortable renderable">
                                    <a>Metric</a>
                                    <b class="sort-caret"></b>
                                 </th>
                                 <th colspan="2" class="sortable renderable">
                                    <a>Campaign</a>
                                    <b class="sort-caret"></b>                            
                                </th>
                                <th colspan="2" class="sortable renderable">
                                    <a>Partial</a>
                                    <b class="sort-caret"></b>                            
                                </th>
                                 <th colspan="2" class="sortable renderable">
                                    <a>Total</a>
                                    <b class="sort-caret"></b>                            
                                </th>
                            </tr>
                            <tr>
                                <th class="sortable renderable">
                                    <a>Current</a>
                                    <b class="sort-caret"></b>
                                </th>
                                <th class="sortable renderable">
                                    <a>Limits</a>
                                    <b class="sort-caret"></b>
                                </th>
                                <th class="sortable renderable">
                                    <a>Current</a>
                                    <b class="sort-caret"></b>
                                </th>
                                <th class="sortable renderable">
                                    <a>Limits</a>
                                    <b class="sort-caret"></b>
                                </th>
                                <th class="sortable renderable">
                                    <a>Current</a>
                                    <b class="sort-caret"></b>
                                </th>
                                <th class="sortable renderable">
                                    <a>Limits</a>
                                    <b class="sort-caret"></b>
                                </th>
                            </tr>
                        </thead>
                        <tbody data-bind="collection: $metricsTableColl, itemView: 'metricsTableView'">
                
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="container-fluid" data-bind="classes: { hide: not(hasL2PartId), }" style="margin-top:2vh !important;">            
            <h4 class="details-labels">History</h4>
            <hr />
            <div class="row-fluid"> 
                <div class="metrics-history-grid-container grids-container" style="height:34vh;overflow-y:auto;"></div>
            </div>
        </div>
    </div>

    <script id="metricsTableViewTemplate" type="text/x-handlebars-template">
        <td class="spanrow1 gray-style" data-bind="text:metric"></td>
        <td class="spanrow2" data-bind="text:campaignCurrent, classes: { 'metric-status-alert': campaignStatusAlert, 'metric-status-warning':campaignStatusWarning }"></td>
        <td data-bind="text:campaignLimit,classes: { 'limit-max': limitMax, 'limit-min':limitMin }" class="gray-style"></td>
        <td class="spanrow3" data-bind="text:partialCurrent, classes: { 'metric-status-alert': partialStatusAlert, 'metric-status-warning':partialStatusWarning }"></td>
        <td data-bind="text:partialLimit,classes: { 'limit-max': limitMax, 'limit-min':limitMin }" class="gray-style"></td>
        <td class="spanrow4" data-bind="text:totalCurrent, classes: { 'metric-status-alert': totalStatusAlert, 'metric-status-warning':totalStatusWarning }"></td>
        <td data-bind="text:totalLimit,classes: { 'limit-max': limitMax, 'limit-min':limitMin }" class="gray-style"></td>

      
    </script>
    
</script>


