﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />

<style>

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .backgrid tr td{
        overflow:visible !important; 
    }

    .backgrid tr td button{
        font-size:12px !important;
    }

</style>

<div class="container-fluid">
    <div class="span12">
        <div class="row-fluid">
            <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
                <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
            <div class="delays-grid-container hide">
            </div>
        </div>
    </div>
</div>

</script>

<%--<script id="delay_split_info_modal_loading" type="text/x-handlebars-template">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_information_title" /></h3>
    </div>
    <div style="max-height:450px;min-height:350px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;"><asp:Localize runat="server" meta:resourcekey="loading_label" /></span>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="delay_split_info_modal_template" type="text/x-handlebars-template">
    <style>
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_information_title" /></h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid" style="font-size:12px;">
            <div class="row-fluid">
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="line_label" /></span><span style="margin-left:8px;">{{line}}</span>
                </div>
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="machine_label" /></span><span style="margin-left:8px;">{{productionItem}}</span>
                </div>
                <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
            </div>
            <div class="row-fluid">
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="start_label" /></span><span style="margin-left:8px;">{{startDate}} {{startTime}}</span>
                </div>
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="duration_label" /></span><span style="margin-left:8px;">{{durationText}}</span>
                </div>
                <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
            </div>
        </div>
        <div class="row-fluid text-center" style="margin-top:8px;">
            <div style="position:relative;margin:0 auto;display:inline-block;">
                <div class="control-group">
                    <label style="font-size:16px;font-weight:bold;" class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="select_code_label" /></label>
                    <div class="controls">
                        <select class="delaycodes-select input-large selectpicker">
                            <option {{selected delayCodeId "-1"}} value="-1"><asp:Localize runat="server" meta:resourcekey="not_declared_category_label" /></option>
                            {{#each delayCodesSelect}}
                            <option {{selected ../delayCodeId value}} value="{{value}}">{{label}}</option>
                            {{/each}}
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">        
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button style="margin-bottom:5px;" class="btn-save btn btn-block btn-primary"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script> --%>

<script id="delay_info_modal_template" type="text/x-handlebars-template">
    <style>
        .modal-wider {
            width:780px;
            margin-left:-390px;
            margin-top:-30px;
        }

        .clickeable-row{
            cursor:pointer; 
        }
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_info_modal_title" /></h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid" style="font-size:12px;">
            <div class="row-fluid">
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="line_label" /></span><span style="margin-left:8px;">{{line}}</span>
                </div>
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="machine_label" /></span><span style="margin-left:8px;">{{productionItem}}</span>
                </div>
                {{#if batchEnabled}}
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="batch_label" /></span><span style="margin-left:8px;">{{batchNumber}}</span>
                </div>
                <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
                {{/if}}
            </div>
            <div class="row-fluid">
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="start_label" /></span><span style="margin-left:8px;">{{startDate}} {{startTime}}</span>
                </div>
                <div style="display:inline-block;margin-right:20px;">
                    <span style="display:inline-block;"><asp:Localize runat="server" meta:resourcekey="duration_label" /></span><span style="margin-left:8px;">{{durationText}}</span>
                </div>
                <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="row-fluid pages-container" style="min-height:200px;">
                {{#each pages}}
                <div data-pageNum="{{pageNum}}" class="row-fluid hide">
                    {{#each rows}}
                    <div class="row-fluid text-center" style="margin-top:8px;">
                        {{#each columns}}
                            <div class="span4"><button style="width:100%;min-height:80px;" data-id="{{id}}" class="btn btn-delay-code">{{text}}</button></div>
                        {{/each}}
                    </div>
                    {{/each}}
                </div>
                {{/each}}
            </div>
        </div>
    </div>
    <div style="margin-top:20px;" class="modal-footer noselect">        
        <div class="row-fluid">
            <div class="span4">
                <div class="pull-left">
                    <button class="btn btn-default btn-arrow-left"><i class="fa fa-arrow-left fa-3x"></i></button>
                </div>
            </div>
            <div class="span4">
                <button style="height:52px;" class="btn-close btn-block btn btn-large"><asp:Localize runat="server" meta:resourcekey="close_label" /></button>
            </div>
            <div class="span4">
                <div class="pull-right">
                    <button class="btn btn-default btn-arrow-right"><i class="fa fa-arrow-right fa-3x"></i></button>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="delay_info_modal_template_loading" type="text/x-handlebars-template">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_info_modal_title" /></h3>
    </div>
    <div style="max-height:450px;min-height:350px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;"><asp:Localize runat="server" meta:resourcekey="loading_label" /></span>
                </div>
            </div>
        </div>
    </div>
</script>

