﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
            <div class="span4" >
                <div style="text-align: left;">
                    <button id="backNavBtn" style="margin-left:5px;margin-top:7px;" class="btn btn-nav btn-primary" >
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                    </button>          
                    <label class="control-label" style="width:200px;">
                        <div id="heat-picker-multi-select"></div>
                    </label>
                    <button id="forwardNavBtn" class="btn btn-nav btn-primary" style="margin-top:7px">
                        <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                    </button>
                </div>
            </div> 
            <div class="span7" style="margin-top:7px;">
                <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-30px;"></div>
            </div>
            <div class="span1" style="margin-top:7px;">
                <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right:20px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>
             <%--   <button id="printBtn" class="btn btn-primary hide"  style="margin-bottom:5px;margin-left:100px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                    <i class="fa fa-print"></i>
                </button>--%>
            </div>
           
           
       </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>

    <div class="main-data-container" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="center-box-small">
            <div class="row-fluid box-container-small" style="margin-top:10px;">  
                <div class="data-container-small">
                    <h5 class="grid-title-small" data-bind="text:  coalesce(mainData_lmf, '-'),"></h5>
                </div>        
            </div>
        </div>
        
    </div>

    
    <div class="tables-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">   
        <div class="span4">
            <table class="grid-styles table">
                    <thead>
                    <tr>
                        <th colspan="2">Information</th>
                    </tr>
                </thead>
                <tbody> 
                        <tr>
                        <td>Melt Order</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(mainData_meltOrder, '-'),"></span></td>
                    </tr>
                     <tr>
                        <td>Argon Car</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_argonCar, '-'),"></span></td>
                    </tr>
                    <tr>
                        <td>Lance: Used / Volume</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_argonLanceUsedAndVolume, '-'),"></span></td>
                    </tr>
                        <tr>
                        <td>Argon: Volume 1 / Volume 2 </td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_argonVolumes, '-'),"></span></td>
                    </tr>
                    <tr>
                        <td>Power On</td>                                
                        <td>
                                <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_powerOn, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>                   
                    <tr>
                        <td>Power Off</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_powerOff, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                      <tr>
                        <td>MWH</td>                                
                        <td> 
                            <span class="info-field-value"  data-bind="text:  coalesce(secondaryData2_energy, '-'),"></span>
                           
                        </td>
                    </tr>
                    <tr>
                        <td>Treatment Time</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_treatmentTime, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <span>Preparation Time</span>
                            <span class="bullet pull-left phase-1-color"></span>
                        </td>                                
                        <td> 
                                       
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_preparationTime, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                        <tr>
                        <td>
                            <span class="bullet pull-left phase-2-color"></span>
                            <span>Heating Time</span> 
                        </td>                                
                        <td>              
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_heatingTime, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                        <tr>
                        <td>
                            <span class="bullet pull-left phase-3-color"></span>
                            <span>Last Time</span>

                        </td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_lastStage, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="process-phases-chart-container row-fluid print-phases-chart" data-bind="collection: $phases, itemView: 'phaseChartView'" style="margin-top: -14px;"></div>
                
               
            <div class="alloys-grid-container items-grid-container" style="margin-top:10px;"></div>  
        </div>
        <div class="span8" > 
            
            <div class="row-fluid">
                <div class="span6">
                        <div class="probes-items-grid-container items-grid-container" ></div>
                </div>
                <div class="span6">
                        
                    <div class="heatings-items-grid-container  items-grid-container" ></div>
                </div>
            </div>
             
            <div class="chart-container" style="position: relative;width:94%"  data-bind="classes: { hide: any(not(hasData), isLoading), }">        
                <canvas id="myChart"></canvas>  
            </div>
        </div>          
    </div>
   



</div>




<script id="alloysTableViewTemplate" type="text/x-handlebars-template">
    <td class="spanrow1" data-bind="text:dumpStart"></td>
    <td data-bind="text:materialName"></td>
    <td data-bind="text:weightPV"></td>
    <td data-bind="text:weightSP"></td>
    <td data-bind="text:binNumber"></td>
    <td data-bind="text:sourceCode"></td>
</script>
    

<script id="phase_chart_view" type="text/x-handlebars-template">
    <div data-bind="text: '', css: { width: format('$1%', mathDiv(mathMul(percentage, 1), 1)), }, attr: { 'class': format('phases-chart-item phase-$1-color', order), },"></div>

</script>

   
<script id="move_addition_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="classes: { hide: not(moveMode), }" ><asp:Localize runat='server' meta:resourcekey='move_addition_modal_title' /></h3>        
        <h3 data-bind="classes: { hide: not(changeMode), }" ><asp:Localize runat='server' meta:resourcekey='change_addition_modal_title' /></h3>        
        <h3 data-bind="classes: { hide: not(addMode), }" ><asp:Localize runat='server' meta:resourcekey='create_addition_modal_title' /></h3>        
        <h3 data-bind="classes: { hide: not(removeMode), }" ><asp:Localize runat='server' meta:resourcekey='remove_addition_modal_title' /></h3>        
    
    </div>
    <div style="max-height:400px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:390px;padding-bottom:0;" class="modal-body">
            
             <div class="alloys-grid-container items-grid-container" data-bind="classes: {hide: addMode}"></div>
            <%-- MOVE OPTION --%>
            <div class="move-mode" data-bind="classes: { hide: not(moveMode), }" >
                <div class="row-fluid" style="text-align:center;">
                    <div style="margin-bottom:0px; text-align:left;" class="span4 control-group form-inline modal-label">
                        <asp:Localize runat=server meta:resourcekey=select_heat_label />
                    </div>
                    <div style="float:left;width:100%" class="control-group form-inline">      
                        <select style="width:100%;" data-bind="value: siblingProcessId, options: siblingProcesses"></select> 
                    </div>
                </div>         
            </div> 
            <%-- CHANGE / ADD OPTIONS --%>
            <div class="change-mode" data-bind="classes: { hide: any(moveMode,removeMode), }">
                 <div class="row-fluid" style="text-align:center;">
                    <div style="margin-bottom:0px; text-align:left;" class="span4 control-group form-inline modal-label">
                        <asp:Localize runat=server meta:resourcekey=select_material_label />
                    </div>
                    <div style="float:left;width:100%" class="control-group form-inline">      
                        <select style="width:100%;" data-bind="value: materialId, options: materials"></select> 
                    </div>
                </div>   
                <div class="row-fluid">
                    <div class="span6">
                        <div style="margin-bottom:0px; text-align:left;" class="span4 control-group form-inline modal-label">
                            <asp:Localize runat=server meta:resourcekey=weight_label />
                        </div>
                        <input type="text" data-bind="value: weight" style="width: 90%"/>
                    </div>
                    <div class="span6">
                        <div style="margin-bottom:0px; text-align:left;" class="span4 control-group form-inline modal-label">
                            <asp:Localize runat=server meta:resourcekey=weight_setpoint_label />
                        </div>
                        <input type="text" data-bind="value: weightSP" style="width: 90%"/>
                    </div>
                </div>
            </div>
            <%-- COMMENT (Mandatory) --%>
           
            <div class="row-fluid" style="text-align:center;">
                 <div style="margin-top:5px; margin-bottom:0px; text-align:left;" class="span4 control-group form-inline modal-label">
                    <asp:Localize runat=server meta:resourcekey=add_comment_label />
                </div>
                <div style="float:left;width:100%" class="control-group form-inline">      
                    <textarea id="comment-textarea" style="width: 98%; height: 90px !important;resize: none;"></textarea>
                </div>
            </div>
        </div>
      
    </div>
    <div class="modal-footer">

        <button id="acceptBtn" class="btn btn-primary" data-bind="disabled: not(commentEnabled)">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>