﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/delays/delays-1/delays-1.css") %>" rel="stylesheet" />

<style>

    .clickeable-row{
        cursor:pointer; 
    }

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

    .backgrid tr td{
        overflow:visible !important; 
    }

    .backgrid tr td button{
        font-size:12px !important;
    }

    .toolbar-filter {
        display:inline-block;
    }

    .infinite-scrolling-loading-poster {
        width:100%;
        text-align:center;
        font-size:14px;
        margin-bottom:15px;
    }

</style>

<div class="container-fluid">
    <div class="span12">
        <div class="row-fluid">
            <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
                <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
            <div class="delays-grid-container infinite-container hide">
            </div>
            <div class="infinite-scrolling-loading-poster hide">
                <span>Loading...</span>
            </div>
        </div>
    </div>
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        <div class="span4">
            <div class="btn-group">
                <button data-preventclick="true" class="action-source-btn btn dropdown-toggle" data-toggle="dropdown" data-open="false">
                    <i style="font-size:16px;position:relative;top:3px;" class="fa fa-ellipsis-h"></i>
                </button>
                <ul style="min-width:100px !important;z-index:99999999999;" data-preventclick="true" class="dropdown-menu action-source-dropdown" style="font-size: 12px;">
                    <li style="cursor:pointer;">
                        <a class="btn-dropdown-action-option ds-option-edit" data-option="ds-edit"><asp:Localize runat="server" meta:resourcekey="declare_label" /></a>
                    </li>
                    {{HBExp "#if split"}}
                    <li style="cursor:pointer;">
                        <a class="btn-dropdown-action-option ds-option-split" data-option="ds-split"><asp:Localize runat="server" meta:resourcekey="split_label" /></a>
                    </li>
                    {{HBExp "/if"}}
                    {{HBExp "#if join"}}
                    <li style="cursor:pointer;">
                        <a class="btn-dropdown-action-option ds-option-join" data-option="ds-join"><asp:Localize runat="server" meta:resourcekey="join_label" /></a>
                    </li>
                    {{HBExp "/if"}}
                </ul>
            </div>
        </div>
    </div>
</script>

</script>

<script type="text/x-handlebars-template" id="subnavbar_controls">
    <div class="span6">
        <div>
            <div style="width:200px;display:inline-block;top:4px;position:relative;">
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="from_label" /></span>
                </div>
                <div style="width:150px;float:left;margin-left:-10px;" class="from-date-control-container">
                </div>
            </div>
            <div style="width:200px;display:inline-block;top:4px;position:relative;">
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                </div>
                <div style="width:150px;float:left;margin-left:-10px;" class="to-date-control-container">
                </div>
            </div>
        </div>
    </div>
    <div class="span6">
        <div class="subnavbar-right-toolbar">
            <div style="display: inline-block; height: 40px;" class="pull-right">
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="line_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(lineProductionItemId), options: lines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_lines_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="machine_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(machineProductionItemId), options: machines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_machines_label />', value: -1 }" id="select1" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div style="position:relative; top:-3px;margin-left:8px;" class="toolbar-filter">
                    <button style="margin-top:0;" class="btn btn-export-to-excel" type="button">
                        <span class="excel-export-state fa fa-file-excel-o"></span>
                        <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                    </button>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="delay_split_info_modal_loading" type="text/x-handlebars-template">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_information_title" /></h3>
    </div>
    <div style="max-height:450px;min-height:350px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;"><asp:Localize runat="server" meta:resourcekey="loading_label" /></span>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="delay_split_info_modal_template" type="text/x-handlebars-template">
    <style>
    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_information_title" /></h3>
    </div>
    <div style="max-height:470px;" class="modal-body noselect">
        <div class="row-fluid">
            <div style="display:inline-block;margin-right:20px;">
                <span style="font-weight:600;display:inline-block;"><asp:Localize runat="server" meta:resourcekey="line_label" /></span><span style="margin-left:8px;">{{line}}</span>
            </div>
            <div style="display:inline-block;margin-right:20px;">
                <span style="font-weight:600;display:inline-block;"><asp:Localize runat="server" meta:resourcekey="machine_label" /></span><span style="margin-left:8px;">{{productionItem}}</span>
            </div>
            <div style="width:100%;height:1px;background-color:#eeeeee;margin-top:4px;margin-bottom:6px;"></div>
        </div>
        <div class="row-fluid">
            <div class="span8">
                <div class="control-group">
                    <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="start_label" /></label>
                    <div class="controls">
                        <div data-modelattr="start" class="datetime-picker"></div>
                    </div>
                </div>

                <div class="control-group">
                    <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="end_label" /></label>
                    <div class="controls">
                        <div data-modelattr="end" class="datetime-picker"></div>
                    </div>
                </div>

            </div>
            <div class="span4">
                <!-- Text input-->
                <div class="control-group">
                  <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="duration_label" /></label>
                  <span>{{durationText}}</span>
                </div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="control-group">
                <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="batch_label" /></label>
                <div class="controls">
                    <select class="batchIds-select input-large selectpicker">
                        {{#each batchIds}}
                        <option {{selected ../batchId value}} value="{{value}}">{{label}}</option>
                        {{/each}}
                    </select>
                </div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="control-group">
                <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="code_label" /></label>
                <div class="controls">
                    <select class="delaycodes-select input-large selectpicker">
                        <option {{selected delayCodeId "-1"}} value="-1"><asp:Localize runat="server" meta:resourcekey="not_declared_category_label" /></option>
                        {{#each delayCodesSelect}}
                        <option {{selected ../delayCodeId value}} value="{{value}}">{{label}}</option>
                        {{/each}}
                    </select>
                </div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="span12">
                <!-- Textarea -->
                <div class="control-group">
                  <label class="control-label" for="textarea"><asp:Localize runat="server" meta:resourcekey="comments_label" /></label>
                  <div class="controls">                     
                    <textarea class="comments-textarea span12" name="textarea">{{comments}}</textarea>
                  </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">        
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-save btn btn-block btn-primary"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script> 

<script id="delay_split_split_action_template" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-slider/css/bootstrap-slider.min.css") %>" rel="stylesheet" />
    <style>
        #split_delay_slider .slider-selection {
	        background: #479dc4;
        }

        /*#split_delay_slider .slider-track-low {
            background: #479dc4;
        }*/
        
        #split_delay_slider .slider-track-high {
            background: #00ff90;
        }

        #split_delay_slider .slider-handle {
	        border-bottom-color: blue;
        }

        .tooltip-main.tooltip > .tooltip-inner {background-color: #e8e8e8;color:#000;}
        .tooltip-main.tooltip > .tooltip-arrow {border-bottom-color:#e8e8e8 !important; border-top-color:#e8e8e8 !important}

        .gray-tooltip.tooltip > .tooltip-inner {background-color: #b6b6b6;color:#000;}
        .gray-tooltip.tooltip > .tooltip-arrow {border-bottom-color:#b6b6b6 !important}

        .slider .top.tooltip {
            margin-top:-43px;
        }

    </style>
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>Split Delay</h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid text-center">
            <span class="muted"><asp:Localize runat="server" meta:resourcekey="drag_to_change_duration_label" /></span>
        </div>
        <div class="row-fluid">
            <div class="pull-left" style="margin-left:10px;">
                <span style="font-size:10px;margin-left:2px;">{{start_date}}</span><br />
                <span style="font-size:14px;">{{start_time}}</span>
            </div>
            <div class="pull-right" style="margin-right:10px;">
                <span style="font-size:10px;margin-left:2px;">{{end_date}}</span><br />
                <span style="font-size:14px;">{{end_time}}</span>
            </div>
        </div>
        <div style="height:50px;" class="row-fluid">
            <div class="span12">
                <div class="span10" style="margin:0 auto;position:relative;float:none;clear:both;">
                    <div class="span12 slider-container" style="display:inline-block;">
                        <div class="slider-arrow-left" style="display:inline-block;width:5%;text-align:right;top:1px;position:relative;">
                            <i style="cursor:pointer;" class="fa fa-arrow-left"></i>
                        </div>
                        <input type="text" class="slider" style="width:90%;display:inline-block;" value="" 
                            data-slider-id="split_delay_slider" 
                            id="split_delay_slider_original" data-slider-tooltip="hover" />
                        <div class="slider-arrow-right" style="display:inline-block;text-align:left;top:1px;position:relative;width:3%;">
                            <i style="cursor:pointer;" class="fa fa-arrow-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6">
                    <button id="delay_split_modal_split_btn" class="btn btn-block btn-primary"><asp:Localize runat="server" meta:resourcekey="split_label" /></button>
                </div>
                <div class="span6">
                    <button id="delay_split_modal_cancel_btn" class="btn btn-block btn-close"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>

