﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">
    <style>
        .backgrid th{
            font-size:12px !important;
        }

        .backgrid tr{
            font-size:12px !important;
        }

        .backgrid td {
            width:150px !important; 
        }
        .toolbar-filter {
            display:inline-block;
        }
    </style>

    <div style="margin-top:-20px;" class="container-fluid">
        <div class="row-fluid">
            <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
                <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                    <div class="bar" style="width: 100%;"></div>
                </div>
            </div>
        </div>
        <div class="row-fluid main-content hide">
            <div class="row-fluid">
                <div class="span12">
                    <h4><asp:Localize runat="server" meta:resourcekey="time_summary_title" /></h4>
                    <div style="width:100%;height:1px;background-color:#ccc;margin-top:0px;margin-bottom:2px;"></div>
                    <div class="row-fluid">
                        <div class="time-summary-grid-container">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="row-fluid">
                    <%--<h4><asp:Localize runat="server" meta:resourcekey="time_summary_title" /></h4>--%>
                    <div style="width:100%;height:1px;background-color:#ccc;margin-top:2px;margin-bottom:2px;"></div>
                </div>
                <div class="row-fluid">
                    <div style="height:300px;" class="delays-chart-container span12"></div>
                </div>
                <div class="row-fluid">
                    <span style="font-size:14px;font-weight:bold;" class="total-time-span"></span>
                </div>
            </div>
        </div>
    </div>
</script>

<script type="text/x-handlebars-template" id="subnavbar_controls">
    <div class="span4">
        <div>
            <div style="width:200px;display:inline-block;top:4px;position:relative;">
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="from_label" /></span>
                </div>
                <div style="width:150px;float:left;margin-left:-10px;" class="from-date-control-container">
                </div>
            </div>
            <div style="width:200px;display:inline-block;top:4px;position:relative;">
                <div style="width:50px;float:left;text-align:right;">
                    <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                </div>
                <div style="width:150px;float:left;margin-left:-10px;" class="to-date-control-container">
                </div>
            </div>
        </div>
    </div>
    <div class="span8">
        <div class="subnavbar-right-toolbar">
            <div style="display: inline-block; height: 40px;" class="pull-right">
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="line_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(lineProductionItemId), options: lines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_lines_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="machine_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(machineProductionItemId), options: machines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_machines_label />', value: -1 }" id="select1" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="product_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(productId), options: products, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_products_label />', value: -1 }" id="select2" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div class="toolbar-filter">
                    <label style="display: inline-block; margin-left: 10px; line-height: 40px;"><asp:Localize runat="server" meta:resourcekey="shift_combo_label" /></label>
                    <select style="margin-left: 10px; top: 3px; position: relative;" data-bind="value: integer(shiftId), options: shifts, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_shifts_label />', value: -1 }" id="select3" name="selectbasic" class="input-small">
                    </select>
                </div>
            </div>
        </div>
    </div>
</script>