﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
            <div class="span4">                
                <div style="text-align: left;">
                    <button id="backNavBtn" style="margin-left:5px;" class="btn btn-nav btn-primary">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                    </button>          
                    <label class="control-label" style="width:200px;">
                         <div id="heat-picker-multi-select"></div>
                   </label>
                    <button id="forwardNavBtn" class="btn btn-nav btn-primary" >
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                    </button>
                </div>       
           
            </div>
            <div class="span8 row-fluid">
                <div class="span7">
                    <label style="margin-left:10px;margin-bottom:0 !important; ">
                        <asp:Localize runat="server" meta:resourcekey="type_label" /> 
                            <select data-bind=" value: typeId, options: types, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_type_label />', value: '-'}" style="width:100px;margin-top:0px;">
                            </select>
                    </label>
                    <label style="margin-left:10px;margin-bottom:0 !important; ">
                        <asp:Localize runat="server" meta:resourcekey="source_label" /> 
                            <select data-bind=" value: sourceId, options: sources, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_all_label />', value: '-'}" style="width:100px;margin-top:0px;">
                            </select>
                    </label>
                     <label class="control-label">
                        <asp:localize runat="server" meta:resourcekey="search_label" />
                        <input type="text" class="input-large clear-search" id="search" style="margin-top:-4px; width:150px;" placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
                    </label>  
                </div>
                <div class="span4">
                    <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-30px;"></div>
                </div>
            
                <div class="span1">                
                    <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                        <i class="fa fa-refresh"></i>
                    </button>
                </div>
            


            </div>
       </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>

    <div class="row-fluid"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-bottom:20px;">
        <div class="span1"></div>
        <div class="span10">
            <button class="btn btn-nav btn-primary pull-right" id="addBtn">Add Comment</button>
            <div class="log-grid-container items-grid-container"></div>
        </div>
    </div>


    
 
    

</div>

<script id="add_new_comment_template" type="text/x-handlebars-template">
  <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>    
        <h3 data-bind="text: title"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">                
                <div class="control-group form-inline">
                    <textarea data-bind="value: comment" class="comment-textarea"></textarea>
                </div>
            </div>
           
        </div>
      
    </div>
    <div class="modal-footer">

           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>