﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span6">
            <h5><asp:Localize runat="server" meta:resourcekey="delay_codes_title" /></h5>
            <div style="margin-bottom:5px;">
                <button class="btn btn-mini btn-add-menu">
                    <asp:Localize runat="server" meta:resourcekey="add_menu_label" />
                </button>
                <button class="btn btn-mini btn-add-screen">
                    <asp:Localize runat="server" meta:resourcekey="add_screen_label" />
                </button>
            </div>
            <div style="height:500px;overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span6">
            <div class="screen-configuration-container row-fluid">
            </div>
        </div>
    </div>
</div>

</script>

<script id="screen_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="row-fluid">
                <h5><asp:Localize runat="server" meta:resourcekey="screen_label" /> [ {{name}} ]</h5>
                <hr />
            </div>
            <div class="row-fluid">
                <form class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                        <div class="controls">
                            <input type="text" data-bind="value: name, events: ['keyup']" />
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="textinput"><asp:Localize runat="server" meta:resourcekey="description_label" /></label>
                        <div class="controls">
                            <textarea rows="5" data-bind="value: description,events:['keyup']">
                            </textarea>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="checkboxes"><asp:Localize runat="server" meta:resourcekey="enabled_label" /></label>
                        <div class="controls">
                            <input data-bind="checked: enabled" type="checkbox" name="checkboxes" id="checkbox-1">
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="files_label" /></label>
                        <div class="controls">
                            <select multiple="multiple" data-bind="options: filesBinding" class="input-large files-select">
                            </select>
                            <div class="row-fluid" style="margin-top:10px;">
                                <div class="add-file-form" id="add-file">
                                    <form enctype="multipart/form-data">
                                        <span style="margin-top:5px;" class="btn btn-success fileinput-button">
                                            <i class="glyphicon glyphicon-plus"></i>
                                            <span><asp:Localize runat="server" meta:resourcekey="add_file_btn_label" /></span>
                                            <input multiple id="fileinput" style="position:absolute;top:-100px;" type="file" name="files[]">
                                        </span>
                                        <button style="margin-top:5px;" disabled="disabled" type="button" class="btn btn-danger btn-remove-file"><asp:Localize runat="server" meta:resourcekey="remove_file_btn_label" /></button>
                                        <button style="margin-top:5px;" disabled="disabled" type="button" class="btn btn-info btn-download-file"><asp:Localize runat="server" meta:resourcekey="download_file_btn_label" /></button>
                                    </form>
                                </div>
                                <div class="row-fluid review-file-form hide">
                                    <div class="span6">
                                        <input class="input-file-filename span12" type="text" disabled="disabled" />
                                    </div>
                                    <div class="span6">
                                        <button type="button" class="btn btn-success span6 btn-upload-file">Upload</button>
                                        <button type="button" class="btn btn-default span6 btn-cancel-upload-file">Cancel</button>
                                    </div>
                                </div>
                                <div class="row-fluid file-upload-progress hide">
                                    <div class="row-fluid">
                                        <div class="span6">
                                            <div class="progress progress-info progress-striped active">
                                                <div class="bar file-upload-progress-bar" style="width: 0%"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row-fluid">
                                        <p class="text-info"><asp:Localize runat="server" meta:resourcekey="file_uploading_message" />Uploading...</p>
                                    </div>
                                </div>
                                <div class="row-fluid file-upload-failed hide">
                                    <p class="text-error"><asp:Localize runat="server" meta:resourcekey="licence_upload_failed_message" />file upload failed. Something went wrong.</p>
                                    <button class="btn btn-default btn-cancel-upload-file"><asp:Localize runat="server" meta:resourcekey="licence_upload_failed_try_again" /></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div style="margin-top:8px;margin-bottom:20px;" class="row-fluid">
            <div class="span6 offset3">
                <a href="!/screenbuilder/editor/{{id}}" class="btn btn-info btn-block">
                    <asp:Localize runat="server" meta:resourcekey="open_editor_label" />
                </a>
            </div>
        </div>
        <%--<hr />
        <div style="margin-top:8px;margin-bottom:20px;" class="row-fluid">
            <a class="btn btn-danger btn-medium pull-right">
                <asp:Localize runat="server" meta:resourcekey="remove_screen_label" />
            </a>
        </div>--%>
    </div>
</script>

<script id="storage_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="row-fluid">
                <h5><asp:Localize runat="server" meta:resourcekey="storage_configuration_title" /></h5>
                <hr />
            </div>
            <div class="row-fluid">
                <form class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label" for="selectbasic"><asp:Localize runat="server" meta:resourcekey="files_label" /></label>
                        <div class="controls">
                            <select multiple="multiple" data-bind="options: filesBinding" class="input-large files-select">
                            </select>
                            <div class="row-fluid" style="margin-top:10px;">
                                <div class="add-file-form" id="Div1">
                                    <form enctype="multipart/form-data">
                                        <span class="btn btn-success fileinput-button">
                                            <i class="glyphicon glyphicon-plus"></i>
                                            <span><asp:Localize runat="server" meta:resourcekey="add_file_btn_label" /></span>
                                            <input multiple id="fileinput" style="position:absolute;top:-100px;" type="file" name="files[]">
                                        </span>
                                        <button disabled="disabled" type="button" class="btn btn-danger btn-remove-file"><asp:Localize runat="server" meta:resourcekey="remove_file_btn_label" /></button>
                                    </form>
                                </div>
                                <div class="row-fluid review-file-form hide">
                                    <div class="span6">
                                        <input class="input-file-filename span12" type="text" disabled="disabled" />
                                    </div>
                                    <div class="span6">
                                        <button type="button" class="btn btn-success span6 btn-upload-file">Upload</button>
                                        <button type="button" class="btn btn-default span6 btn-cancel-upload-file">Cancel</button>
                                    </div>
                                </div>
                                <div class="row-fluid file-upload-progress hide">
                                    <div class="row-fluid">
                                        <div class="span6">
                                            <div class="progress progress-info progress-striped active">
                                                <div class="bar file-upload-progress-bar" style="width: 0%"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row-fluid">
                                        <p class="text-info"><asp:Localize runat="server" meta:resourcekey="file_uploading_message" />Uploading...</p>
                                    </div>
                                </div>
                                <div class="row-fluid file-upload-failed hide">
                                    <p class="text-error"><asp:Localize runat="server" meta:resourcekey="licence_upload_failed_message" />file upload failed. Something went wrong.</p>
                                    <button class="btn btn-default btn-cancel-upload-file"><asp:Localize runat="server" meta:resourcekey="licence_upload_failed_try_again" /></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</script>