USE [IHBoxSystem]
GO
CREATE ROLE thermalprofile_readWrite AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'thermalprofile_readWrite', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'thermalprofile_readWrite', 'SDI/australtek'
GO


USE [IHBoxSystem]
GO
CREATE ROLE thermalprofile_read AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'thermalprofile_read', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'thermalprofile_read', 'SDI/australtek'
GO




EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [thermalprofile_read] -- The role
,@name = N'securedsp-MES.GetAutocompleteHeats' -- the procedure
,@value = N'' 
GO



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [thermalprofile_read] -- The role
,@name = N'securedsp-MES.GetNavigatedHeat' -- the procedure
,@value = N'' 
GO




EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [thermalprofile_read] -- The role
,@name = N'securedsp-MES.GetThermalProfile' -- the procedure
,@value = N'' 
GO




declare @parent int, @result_routeId INT
select @parent=id from [FrontEnd].[Menu] where name='MES'

INSERT INTO [FrontEnd].[Routes]
		   ([Route]
		   ,[ModuleName]
		   ,[ModulePath]
		   ,[RequiredRole]
	   )
	 VALUES
		   (
		   '!/thermal-profile(/:heatName)(/)'
		   , 'thermal-profile'
		   , 'custom-screens/thermal-profile/'
		   , 'thermalprofile_read'           
		   )
		   SET @result_routeId = @@IDENTITY
INSERT INTO [FrontEnd].[Menu]
		   ([Parent]
		   ,[Name]
		   ,[RouteID]
		   ,[SortOrder]
		   ,[Enabled]
		   ,[Visible]
		   ,[RequiredRole]
		   ,[Group]
		  )
	 VALUES
		   (
		   @parent
		   ,'Thermal Profile'
		   ,@result_routeId 
		   ,1
		   ,1
		   ,1
		   ,'thermalprofile_read'
		   ,NULL
		 )
GO

/*------------------------------------------------------Profiles------------------------------------------------------*/
USE [IHBoxSystem]
GO

DECLARE @ModuleId INT

INSERT INTO [SECURITY].[Modules]
		   ([Code]
		   ,[Name])
	 VALUES
		   ('thermal_profile'
		   ,'Thermal Profile')

		  SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'readWrite'
		   ,'Read/Write'
		   ,'thermalprofile_read')

		   		   
INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'read'
		   ,'Read'
		   ,'thermalprofile_readWrite')
GO

/*---------------------------------------------------------------------------------------------------------------------------------------------*/



