﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.Catalog = classRef = superRef.extend({
            defaults: {
                id: null,

                active: null,
                description: null,
                name: null,
            },

            parse: function (obj) {
                return {
                    id: obj.Id,

                    active: obj.Active,
                    description: $.trim(obj.Description),
                    name: $.trim(obj.Name),
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.Catalogs = classRef = superRef.extend({
            model: Main.Models.Catalog,

            comparator: 'name',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});