﻿define([
  'app',
  'modules/process/process',
],
function (app, Process) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Process.Models.Process;
        superProto = superRef.prototype;
        Main.Models.EafProcess = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    start: null,
                    startTap: null,
                    endTap: null,
                    end: null,
                    electrode1Changed: null,
                    electrode2Changed: null,
                    electrode3Changed: null,
                    electrode1ChangeId: null,
                    electrode2ChangeId: null,
                    electrode3ChangeId: null,
                    arcLengthSettingId: 0,
                    arcLengthSettingName: null,
                    energy: null,
                    furnaceHeatsCount: null,
                    furnaceCode: null,
                    furnaceName: null,
                    heel: null,
                    operatorId: 0,
                    operatorName: null,
                    powerOff: null,
                    powerOn: null,
                    pourbackHeatId: null,
                    pourbackHeatName: null,
                    pourbackWeight: null,
                    regulationModeId: 0,
                    regulationModeName: null,
                    steelWeight: null,
                    tappingTime: null,
                    tapToTap: null,
                    melter: null,
                    powerProgram:null,
                    burnerProgram: null,
                    boreInTime:null,
                    meltTime: null, 
                    refineTime: null,
                    chargeWeight: null,
                    ncc1: null,
                    ncc2: null,
                    ncc3: null,
                    caveIn1: null,
                    caveIn2: null,
                    caveIn3: null,
                    ladleArgon: null,
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.EAF.GetProcesses',
                getNext: app.DatabaseNames.MES + '.EAF.GetNextProcess',
                removeManualVariable: app.DatabaseNames.MES + '.EAF.RemoveProcessManualVariable',
                ship: app.DatabaseNames.MES + '.EAF.ShipProcessManual',
                update: app.DatabaseNames.MES + '.EAF.UpdateProcessManual',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    start: obj.StartString,
                    startTap: obj.StartTapString,
                    endTap: obj.EndTapString,
                    end: obj.EndString,
                    energy: obj.Energy,
                    furnaceHeatsCount: obj.FurnaceHeatsCount,
                    furnaceCode: obj.FurnaceCode,
                    furnaceName: obj.FurnaceName,
                    electrode1Changed: obj.Electrode1Changed,
                    electrode2Changed: obj.Electrode2Changed,
                    electrode3Changed: obj.Electrode3Changed,
                    heel: obj.Heel,
                    operatorId: obj.OperatorId,
                    operatorName: obj.OperatorName,
                    pourbackHeatId: obj.PourbackHeatId,
                    pourbackHeatName: obj.PourbackHeatName,
                    pourbackWeight: obj.PourbackWeight,
                    arcLengthSettingId: obj.ArcLengthSettingId,
                    arcLengthSettingName: obj.ArcLengthSettingName,
                    powerOff: obj.PowerOff,
                    powerOn: obj.PowerOn,
                    regulationModeId: obj.RegulationModeId,
                    regulationModeName: obj.RegulationModeName,
                    steelWeight: obj.SteelWeight,
                    tappingTime: obj.TappingTime,
                    tapToTap: obj.TapToTap,
                    mwhMin: obj.MwhMin,
                    melter: obj.Melter,
                    powerProgram: obj.PowerProgram,
                    burnerProgram: obj.BurnerProgram,
                    boreInTime: obj.BoreInTime,
                    meltTime: obj.MeltTime,
                    refineTime: obj.RefineTime,
                    chargeWeight: obj.ChargeWeight,
                    ncc1:    obj.Ncc1,
                    ncc2:    obj.Ncc2,
                    ncc3:    obj.Ncc3,
                    caveIn1: obj.CaveIn1,
                    caveIn2: obj.CaveIn2,
                    caveIn3: obj.CaveIn3,
                    argon: obj.Argon,
                });
            },
            reset: function (opt) {
                this.set(classRef.prototype.defaults, opt);
            },
        });

    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Process.Collections.Processes;
        superProto = superRef.prototype;

        Main.Collections.EafProcesses = classRef = superRef.extend({
            model: Main.Models.EafProcess,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if ((resp) && (resp.Table)) {
                                opt.success(_.map(resp.Table, function (obj) { return classRef.prototype.model.prototype.parse(obj, resp.Table1); }));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch eaf processes.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },            
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});