﻿define([
  'app',
'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.Heat = classRef = superRef.extend({
            defaults: {
                id: null,

                gradeId: null,
                gradeName: null,
                ladleId: null,
                ladleName: null,
                name: null,
                initialGradeId: null,
                initialGradeName: null,
                statusCode: null,
                statusName: null,
                steelWeight: null,
            },

            procedures: _.extend(superProto.procedures, {
                get: app.DatabaseNames.MES + '.MES.GetHeats',
            }),

            parse: function (obj) {
                return {
                    id: obj.Id,

                    gradeId: obj.GradeId,
                    gradeName: obj.GradeName,
                    ladleId: obj.LadleId,
                    ladleName: obj.LadleName,
                    name: obj.Name,
                    initialGradeId: obj.InitialGradeId,
                    initialGradeName: obj.InitialGradeName,
                    statusCode: obj.StatusCode,
                    statusName: obj.StatusName,
                    steelWeight: obj.SteelWeight,
                };
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.Heats = classRef = superRef.extend({
            model: Main.Models.Heat,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if ((resp) && (resp.Table)) {
                                opt.success(_.map(resp.Table, function (obj) { return classRef.prototype.model.prototype.parse(obj); }));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch heats.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});