<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/pages/ref/ref-ladle-history/ref-ladle-history.css")%>" rel="stylesheet" />

<link href="<%= ResolveUrl("~/assets/ag-grid/ag-grid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />


<style>

 /* Page content */
 .content-container{
            padding-top: 0px !important;
        }
        #subnavbar-inner{
            display:none !important;
        }
        /*Page Title */
       .professional-title {
            font-size: 22px;
            font-weight: 400;
            color: #202124;
            padding-bottom: 1px;
            border-bottom: 1px solid #dadce0;
            margin-bottom: 2px;
            font-family: 'Roboto', Arial, sans-serif;
        }
        /*date picker*/
        .date-picker{
            border:none !important;
            margin-bottom: 0px !important;
            -webkit-box-shadow:none !important;
            box-shadow: none !important;
            width: 100px;
            text-align: center;
        }
        .ladle-drop-down{
            width: 120px;
            height: 37.78px;
            padding: 0px !important;
            text-align: center;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .spinner {
            animation: spin 1s linear infinite;
            transform-origin: center;
        }

</style>



<h2 class="professional-title">Ladle Equipment History</h2>

<div class="bg-white shadow-md rounded-lg p-2 mb-4">
    <div data-bind="classes: { hide: isPageLoading }">
        <div class="bg-white shadow-md rounded-lg mb-2">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2 mb-2">
                    <div class="flex flex-wrap items-center space-x-1">
                        <div class="flex flex-col">
                            <div class="flex items-center">
                                <label for="dateTbx" class="ml-2 mr-2 text-sm font-medium text-gray-700">Start</label>
                                <div class="flex items-center border border-gray-300 rounded-md">
                                    <input type="text" id="dateStartTbx" class="input-date date-picker pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                                    <button id="calendarStartBtn" class="px-2 py-2 border-l border-gray-300 hover:bg-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>


                        <div class="flex flex-col"></div>
                            <div class="flex items-center">
                                <label for="dateTbx" class="ml-2 mr-2 text-sm font-medium text-gray-700">End</label>
                                <div class="flex items-center border border-gray-300 rounded-md">
                                    <input type="text" id="dateEndTbx" class="input-date date-picker pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                                    <button id="calendarEndBtn" class="px-2 py-2 border-l border-gray-300 hover:bg-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                    </div>
                    <div class="flex flex-col">
                        <div class="flex items-center">
                            <label class="ml-2 mr-2 text-sm font-medium text-gray-700">Ladle</label>
                            <select data-bind="value: ladleId, options: ladles" class="block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md ladle-drop-down">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="flex space-x-2 mb-2">
                    <button id="refreshBtn" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded flex items-center justify-center" style="width: 150px; height: 36.5px; font-size: 14px;">
                        <div data-bind="classes: { hide: isLoading }">
                            <span>Refresh</span>
                        </div>
                        <div data-bind="classes: { hide: not(isLoading) }">
                            <div class="flex items-center">
                                <svg class="h-5 w-5 mr-3" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <g class="spinner">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" fill="none"/>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"/>
                                    </g>
                                </svg>
                                <span>Loading...</span>
                            </div>

                        </div>
                    </button>
                    <button id="exportExcelBtn" class="bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded flex items-center justify-center" style="width: 150px; height: 36.5px; font-size: 14px;">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm3.293-7.707a1 1 0 011.414 0L9 10.586V3a1 1 0 112 0v7.586l1.293-1.293a1 1 0 111.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                        <span>Export Excel</span>
                    </button>
                </div>
            </div>

        </div>
        <div class="mx-auto">
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;">
                <div class="processes-grid-container ag-theme-alpine w-full" style="height: 75vh;border:1px solid #ccc"></div>
            </div>
            <div class="mt-4 flex justify-end">
            </div>
        </div>
    </div>

    <div data-bind="classes: { hide: not(isPageLoading) }">
        <div class="bg-white shadow-md rounded-lg mb-2">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2 mb-2">
                    <div class="flex flex-wrap items-center space-x-1">
                        <div class="skeleton-input w-40 h-10 bg-gray-200 rounded-md"></div>
                        <div class="skeleton-input w-40 h-10 bg-gray-200 rounded-md"></div>
                    </div>
                    <div class="skeleton-select w-32 h-10 bg-gray-200 rounded-md"></div>
                </div>
                <div class="flex space-x-2 mb-2">
                    <div class="skeleton-button w-36 h-9 bg-gray-200 rounded"></div>
                    <div class="skeleton-button w-36 h-9 bg-gray-200 rounded"></div>
                </div>
            </div>
        </div>
        <div class="mx-auto">
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;">
                <div class="skeleton-grid w-full h-64vh bg-gray-200"></div>
            </div>
        </div>
    </div>
</div>

<!-- Comment Edit Modal -->
<div id="commentModal" class="fixed inset-0 z-50 hidden">
    <div class="fixed inset-0 bg-black bg-opacity-40"></div>
    <div class="fixed inset-0 flex items-center justify-center">
        <div class="relative bg-white rounded-lg shadow-xl w-full max-w-lg mx-4">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Edit Comments</h3>
                <p class="text-sm text-gray-500 mt-1">Heat ID: <span id="modalHeatId" class="font-medium"></span></p>
            </div>
            <div class="px-6 py-4">
                <div class="mb-4">
                    <label for="sentByInput" class="block text-sm font-medium text-gray-700 mb-1">Sent By</label>
                    <input type="text" id="sentByInput" class="w-full px-3 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" style="height: 42px;" placeholder="Enter name...">  
                </div>
                <div class="mb-4">
                    <label for="completedByInput" class="block text-sm font-medium text-gray-700 mb-1">Completed By</label>
                    <input type="text" id="completedByInput" class="w-full px-3 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" style=" height: 42px;" placeholder="Enter name...">
            </div>
                <div class="mb-4">
                    <label for="commentsInput" class="block text-sm font-medium text-gray-700 mb-1">Comments on Plugs or Plates</label>
                    <textarea id="commentsInput" rows="4" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Enter comments..."></textarea>
                </div>
            </div>
            <div class="px-6 py-4 border-t border-gray-200 flex justify-end space-x-3">
                <button id="modalCancelBtn" class="px-4 py-2 bg-white border border-gray-300 text-gray-700 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-gray-500">
                    Cancel
                </button>
                <button id="modalSaveBtn" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    Save
                </button>
            </div>
        </div>
    </div>
</div>

