﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="sulpher_print" type="text/x-handlebars-template">
<link href="<%= ResolveUrl("~/app/templates/modal-sulpher-print/modal-sulpher-print.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/select2/select2.min.css") %>" rel="stylesheet" />
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span style="font-weight: bold;" data-bind="text: Title"></span>
        </h4>
    </div>
    <div class="modal-body">
        <div class="row-fluid firstMainRow">
            <div class="span4">
                <div class="row-fluid">
                    <div id="heatNumberDiv" class="form-group span5">
                        <label for="heatNumber">Heat Number:</label>
                        <input disabled type="text" class="form-control" data-bind="value: HeatNumber">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>

                    </div>
                    <div class="span1"></div>
                    <div id="ratedByDiv" class="form-group span6">
                        <label for="ratedBy">Rated By</label>
                        <%--<select class="selectRatedBy" data-bind=" value: ratedById, options: ratedByNames" >  </select>--%>
                       <select 
                            id="RatedBy" 
                            name="RatedBy" 
                            class="formbold-form-select"
                            >
                        </select>


                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                </div>
                <div class="row-fluid">
                    <div id="gradeDiv" class="form-group">
                        <label for="grades">Grade:</label>
                        <input disabled type="text" class="form-control" data-bind="value: Grade">
                        <%-- <span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                </div>
                <div class="row-fluid">
                    <div id="dateDiv" class="form-group">
                        <label for="date">Date:</label>
                        <input disabled type="text" class="form-control" data-bind="value: Date">
                        <%-- <span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span4">
                        <div id="strandDiv" class="form-group">
                            <label for="strand">Strand:</label>
                            <input disabled id="strand" class="form-control" data-bind="value: Strand">
                        </div>
                    </div>
                    <div class="span1"></div>
                    <div class="span4">
                        <div id="cutDiv" class="form-group">
                            <label for="cut">Cut:</label>
                            <input disabled id="cut" class="form-control" data-bind="value: Cut">
                        </div>
                    </div>
                </div>
            </div>
            <div class="span1"></div>
            <div class="span6 numberDiv">
                <div class="row-fluid">
                    <div id="d1Div" class="form-group span2">
                        <label for="d1">D1</label>
                        <input type="number" class="form-control" data-bind="value: d1Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div class="span6"></div>
                    <div id="d2Div" class="form-group span2">
                        <label for="d2">D2</label>
                        <input type="number" class="form-control" data-bind="value: d2Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                </div>
                <div class="row-fluid">
                    <div id="w1Div" class="form-group span2">
                        <label for="w1">W1</label>
                        <input type="number" class="form-control" data-bind="value: w1Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="w2Div" class="form-group span2">
                        <label for="w2">W2</label>
                        <input type="number" class="form-control" data-bind="value: w2Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="w3Div" class="form-group span2">
                        <label for="w3">W3</label>
                        <input type="number" class="form-control" data-bind="value: w3Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="w4Div" class="form-group span2">
                        <label for="w4">W4</label>
                        <input type="number" class="form-control" data-bind="value: w4Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="w5Div" class="form-group span2">
                        <label for="w5">W5</label>
                        <input type="number" class="form-control" data-bind="value: w5Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                </div>
                <div class="row-fluid">
                    <div id="h1Div" class="form-group span2">
                        <label for="h1">H1</label>
                        <input type="number" class="form-control" data-bind="value: h1Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="h2Div" class="form-group span2">
                        <label for="h2">H2</label>
                        <input type="number" class="form-control" data-bind="value: h2Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="h3Div" class="form-group span2">
                        <label for="h3">H3</label>
                        <input type="number" class="form-control" data-bind="value: h3Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="h4Div" class="form-group span2">
                        <label for="h4">H4</label>
                        <input type="number" class="form-control" data-bind="value: h4Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                    <div id="h5Div" class="form-group span2">
                        <label for="h5">H5</label>
                        <input type="number" class="form-control" data-bind="value: h5Input">
                        <%--<span data-bind="text: recurrenceLabel"></span>--%>
                    </div>
                </div>
            </div>
        </div>
        <div class="row-fluid">
            <table class="sulfurTable">
                <thead>
                    <tr>
                        <th>Standard Only</th>
                        <th class="text-left">Rating</th>
                        <th class="text-left">Type</th>
                        <th class="text-left">Depth</th>
                        <th class="text-left">Side</th>
                        <th class="text-left">Surface Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Surface Cracks</td>
                        <td class="text-left ratingSelect">
                            <select data-bind=" value: surfaceCracksRatingId, options: rating" style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left typeSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left depthSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left sideSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                         <td class="text-left surfaceTypeSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Subsurface Cracks</td>
                        <td class="text-left ratingSelect">
                            <select data-bind=" value: subsurfaceCracksRatingId, options: rating" style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left typeSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left depthSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left sideSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Pinholes</td>
                        <td class="text-left ratingSelect">
                            <select data-bind=" value: pinholesRatingId, options: rating" style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left"></td>
                        <td class="text-left"></td>
                         <td class="text-left"></td>
                        <td class="text-left"></td>
                    </tr>  
                    <tr>
                        <td>Internal Cracks</td>
                        <td class="text-left ratingSelect">
                            <select data-bind=" value: internalCracksRatingId, options: rating" style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left typeSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left depthSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left sideSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Center Cracks</td>
                        <td class="text-left ratingSelect">
                            <select data-bind=" value: centerCracksRatingId, options: rating" style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left typeSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left depthSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Center Segregation</td>
                        <td class="text-left ratingSelect">
                            <select data-bind=" value: centerSegregationId, options: rating" style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left typeSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td class="text-left depthSelect">
                            <select disabled style="width: 60px; margin-top: 0px;">
                            </select>
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>

        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>
