﻿/*! backbone.caseinsensitive router*/
define(
    ["backbone", "underscore"],
function (Backbone, _) {

    _ = this._;

    _.extend(Backbone.History.prototype, {

        getFragment: function (fragment, forcePushState) {
            // Cached regex for stripping a leading hash/slash and trailing space.
            var routeStripper = /^[#\/]|\s+$/g;

            // Cached regex for stripping leading and trailing slashes.
            var rootStripper = /^\/+|\/+$/g;

            // Cached regex for detecting MSIE.
            var isExplorer = /msie [\w.]+/;

            // Cached regex for removing a trailing slash.
            var trailingSlash = /\/$/;

            if (fragment == null) {
                if (this._hasPushState || !this._wantsHashChange || forcePushState) {
                    fragment = this.location.pathname;
                    var root = this.root.replace(trailingSlash, '');
                    if (!fragment.toUpperCase().indexOf(root.toUpperCase())) fragment = fragment.substr(root.length);
                } else {
                    fragment = this.getHash();
                }
            }
            return fragment.replace(routeStripper, '');
        }

    }); 

}); 