﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<% 
    string callback = Request.QueryString["callback"];
    bool check = Convert.ToBoolean(Request.QueryString["check_single_page"]);

    if (!String.IsNullOrEmpty(callback) && check)
    {
        StringBuilder sb = new StringBuilder();
        sb.Append(callback + "(");
        sb.Append("{ single_page: 'OK' }");
        sb.Append(");");

        Context.Response.Clear();
        Context.Response.ContentType = "application/json";
        Context.Response.Write(sb.ToString());
        Context.Response.End();
    }
%>

<!DOCTYPE html>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion(); 
</script>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    String selectedLanguage = (lang != null) ? lang.Value : "en";

    string langCode = Request.QueryString["lang"];
    int langCodeInt = 0;
    Int32.TryParse(langCode, out langCodeInt);
    try
    {
        CultureInfo queryLang = new CultureInfo(langCodeInt);
        selectedLanguage = queryLang.TwoLetterISOLanguageName;
    }
    catch (Exception ex)
    {
    }

    try
    {
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
    catch (Exception ex)
    {
        selectedLanguage = "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }

    if (Request.Cookies["siteLanguage"] != null) Request.Cookies.Remove("siteLanguage");

    HttpCookie langCookie = new HttpCookie("siteLanguage", selectedLanguage);
    langCookie.Expires = DateTime.Now.AddDays(30);
    Response.Cookies.Add(langCookie);

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30));
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>
<html>
    <head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta charset="utf-8" />
    <meta name="description" content="" />

    <title>Network Overview</title>

    <script src="<%
        Response.Write(ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Scripts/IndustrialDashboard-debug.js?v=" + version)); 
    %>" type="text/javascript"></script> 

    <link type="text/css" href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Styles/IndustrialDashboard.css?v=" + version) %>" rel="stylesheet" />

    <script type="text/javascript">
        var _Includer = new window.Includer({
            Widgets: [
                'SecurityLogin'
            ]
            , XML: { Available: false }
            , Theme: "DZSupervision"
        });
    </script>

    <script>
        var configPath = "<%= ResolveUrl("~/app/")%>"; 
    </script>

    <%--jquery--%>
    <script src="<%= ResolveUrl("~/assets/libs/jam/jquery/dist/jquery.js") %>"></script>

    <!-- nprogress bar for ajax loading feedback -->
    <link href="<%= ResolveUrl("~/assets/libs/js/nprogress/nprogress.css") %>" rel="stylesheet" />
    <script src="<%= ResolveUrl("~/assets/libs/js/nprogress/nprogress.js") %>"></script>

    <!--bootstrap-->
    <link href="<%= ResolveUrl("~/assets/bootstrap/css/custom-bootstrap.min.css") %>" rel="stylesheet" />
    <%--<link href="<%= ResolveUrl("~/assets/bootstrap-3.2.0/css/bootstrap.min.css") %>" rel="stylesheet" />--%>
    <link href="<%= ResolveUrl("~/assets/css/font-awesome/css/font-awesome.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/font-awesome-4.2.0/css/font-awesome.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/font-awesome-animation-0.0.7/css/font-awesome-animation.css") %>" rel="stylesheet" />

    <link href="<%= ResolveUrl("~/assets/bootstrap/css/bootstrap-responsive.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/index-ui.css?v=" + version) %>" rel="stylesheet" />
    <%--<link href="<%= ResolveUrl("~/assets/css/index-ui-flat.css") %>" rel="stylesheet" />--%>
    <%--<link href="<%= ResolveUrl("~/assets/css/index-ui-flat2.css") %>" rel="stylesheet" />--%>

    <link href="<%= ResolveUrl("~/assets/css/index-ui-template.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/animate.css") %>" rel="stylesheet" />

    <script src="<%= ResolveUrl("~/assets/libs/js/require.js") %>"></script>
    <script src="<%= "network-overview.js?v=" + version %>"></script>
    </head>
    <body style="height:100%; width:98%; margin:0; padding:0; position:fixed;text-align:center;background-color:#fff !important;">
        <span style="font-size:22px;top:20px;position:relative;" id="loading_poster">
            Loading...
        </span>
        <div style="margin-top:1%;" class="container">

        </div>
    </body>
</html>