﻿using System.Collections.Generic;
using System.Data;
using System.Linq;

public static class DataSet2JSON
{
    private static object RowsToDictionary(this DataTable table)
    {
        var columns = table.Columns.Cast<DataColumn>().ToArray();
        return table.Rows.Cast<DataRow>().Select(r => columns.ToDictionary(c => c.ColumnName, c => r[c]));
    }
    public static Dictionary<string, object> ToDictionary(this DataTable table)
    {
        return new Dictionary<string, object>
       {
           { table.TableName, table.RowsToDictionary() }
       };
    }
    public static Dictionary<string, object> ToDictionary(this DataSet data)
    {
        return data.Tables.Cast<DataTable>().ToDictionary(t => t.TableName, t => t.RowsToDictionary());
    }
}
