﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/account-information/circle-progress.css") %>" rel="stylesheet" />
<%--<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-select/bootstrap-select.min.css") %>" rel="stylesheet" />--%>

<style type="text/css">

</style>

<div>
    <div class="row-fluid">
        <div class="span6">
            <h4 style="margin-top:0;"><asp:Localize runat="server" meta:resourcekey="tags_info_title" /></h4>
            <div class="row-fluid span12">
                <div class="span4">
                    <div class="row-fluid">
                        <div class="radial-progress" style="float:left;" id="circle-progress-tagsinuse" data-progress="0">
	                        <div class="circle">
		                    <div class="mask full">
			                    <div class="fill"></div>
		                    </div>
		                    <div class="mask half">
			                    <div class="fill"></div>
			                    <div class="fill fix"></div>
		                    </div>
	                        </div>
	                        <div class="inset">
		                        <div class="percentage">
			                        <div class="numbers"><span>-</span><span>0%</span><span>1%</span><span>2%</span><span>3%</span><span>4%</span><span>5%</span><span>6%</span><span>7%</span><span>8%</span><span>9%</span><span>10%</span><span>11%</span><span>12%</span><span>13%</span><span>14%</span><span>15%</span><span>16%</span><span>17%</span><span>18%</span><span>19%</span><span>20%</span><span>21%</span><span>22%</span><span>23%</span><span>24%</span><span>25%</span><span>26%</span><span>27%</span><span>28%</span><span>29%</span><span>30%</span><span>31%</span><span>32%</span><span>33%</span><span>34%</span><span>35%</span><span>36%</span><span>37%</span><span>38%</span><span>39%</span><span>40%</span><span>41%</span><span>42%</span><span>43%</span><span>44%</span><span>45%</span><span>46%</span><span>47%</span><span>48%</span><span>49%</span><span>50%</span><span>51%</span><span>52%</span><span>53%</span><span>54%</span><span>55%</span><span>56%</span><span>57%</span><span>58%</span><span>59%</span><span>60%</span><span>61%</span><span>62%</span><span>63%</span><span>64%</span><span>65%</span><span>66%</span><span>67%</span><span>68%</span><span>69%</span><span>70%</span><span>71%</span><span>72%</span><span>73%</span><span>74%</span><span>75%</span><span>76%</span><span>77%</span><span>78%</span><span>79%</span><span>80%</span><span>81%</span><span>82%</span><span>83%</span><span>84%</span><span>85%</span><span>86%</span><span>87%</span><span>88%</span><span>89%</span><span>90%</span><span>91%</span><span>92%</span><span>93%</span><span>94%</span><span>95%</span><span>96%</span><span>97%</span><span>98%</span><span>99%</span><span>100%</span></div>
		                        </div>
	                        </div>
                        </div>
                    </div>
                </div>
                <div style="font-size:16px;margin-left:-20px;margin-top:30px;" class="span8">
                    <div class="row-fluid">
                        <div class="span4 text-right"><span style="font-weight:bold;">{{tags_used}}</span></div>
                        <div class="span8"><span><asp:Localize runat="server" meta:resourcekey="tags_used_label" /></span></div>
                    </div>
                    <div class="row-fluid">
                        <div class="span4 text-right"><span style="font-weight:bold;">{{tags_configured}}</span></div>
                        <div class="span8"><span><asp:Localize runat="server" meta:resourcekey="tags_configured_label" /></span></div>
                    </div>
                    <div class="row-fluid">
                        <div class="span4 text-right"><span style="font-weight:bold;">{{tags_licensed}}</span></div>
                        <div class="span8"><span><asp:Localize runat="server" meta:resourcekey="tags_licensed_label" /></span></div>
                    </div>
                </div>
            </div>
            <div class="row-fluid">
                <div class="span6">
                    <h5 style="margin:0;"><asp:Localize runat="server" meta:resourcekey="tags_circle_progress_comment" /></h5>
                </div>
            </div>
        </div>
        <div class="span6">
            <div class="row-fluid"> 
                <h4 style="margin-top:0;"><asp:Localize runat="server" meta:resourcekey="db_space_info_title" /></h4>
                <div class="row-fluid span12">
                    <div class="span4">
                        <div class="row-fluid">
                            <div class="radial-progress" style="float:left;" id="circle-progress-dbspace" data-progress="0">
	                            <div class="circle">
		                        <div class="mask full">
			                        <div class="fill"></div>
		                        </div>
		                        <div class="mask half">
			                        <div class="fill"></div>
			                        <div class="fill fix"></div>
		                        </div>
	                            </div>
	                            <div class="inset">
		                            <div class="percentage">
			                            <div class="numbers"><span>-</span><span>0%</span><span>1%</span><span>2%</span><span>3%</span><span>4%</span><span>5%</span><span>6%</span><span>7%</span><span>8%</span><span>9%</span><span>10%</span><span>11%</span><span>12%</span><span>13%</span><span>14%</span><span>15%</span><span>16%</span><span>17%</span><span>18%</span><span>19%</span><span>20%</span><span>21%</span><span>22%</span><span>23%</span><span>24%</span><span>25%</span><span>26%</span><span>27%</span><span>28%</span><span>29%</span><span>30%</span><span>31%</span><span>32%</span><span>33%</span><span>34%</span><span>35%</span><span>36%</span><span>37%</span><span>38%</span><span>39%</span><span>40%</span><span>41%</span><span>42%</span><span>43%</span><span>44%</span><span>45%</span><span>46%</span><span>47%</span><span>48%</span><span>49%</span><span>50%</span><span>51%</span><span>52%</span><span>53%</span><span>54%</span><span>55%</span><span>56%</span><span>57%</span><span>58%</span><span>59%</span><span>60%</span><span>61%</span><span>62%</span><span>63%</span><span>64%</span><span>65%</span><span>66%</span><span>67%</span><span>68%</span><span>69%</span><span>70%</span><span>71%</span><span>72%</span><span>73%</span><span>74%</span><span>75%</span><span>76%</span><span>77%</span><span>78%</span><span>79%</span><span>80%</span><span>81%</span><span>82%</span><span>83%</span><span>84%</span><span>85%</span><span>86%</span><span>87%</span><span>88%</span><span>89%</span><span>90%</span><span>91%</span><span>92%</span><span>93%</span><span>94%</span><span>95%</span><span>96%</span><span>97%</span><span>98%</span><span>99%</span><span>100%</span></div>
		                            </div>
	                            </div>
                            </div>
                        </div>
                    </div>
                    <div style="font-size:16px;margin-left:-20px;margin-top:30px;" class="span8">
                        <div class="row-fluid">
                            <div class="span4 text-right"><span style="font-weight:bold;">{{db_available_space_string}}</span></div>
                            <div class="span8"><span><asp:Localize runat="server" meta:resourcekey="db_available_space_label" /></span></div>
                        </div>
                        <div class="row-fluid">
                            <div class="span4 text-right"><span style="font-weight:bold;">{{db_used_space_string}}</span></div>
                            <div class="span8"><span><asp:Localize runat="server" meta:resourcekey="db_used_space_label" /></span></div>
                        </div>
                        <div class="row-fluid">
                            <div class="span4 text-right"><span style="font-weight:bold;">{{db_total_space_string}}</span></div>
                            <div class="span8"><span><asp:Localize runat="server" meta:resourcekey="db_total_space_label" /></span></div>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span6">
                        <h5 style="margin:0;"><asp:Localize runat="server" meta:resourcekey="db_space_circle_progress_comment" /></h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row-fluid">
        <div class="span6"> 
            <div style="margin-bottom:0;" class="row-fluid">
                <h4><asp:Localize runat="server" meta:resourcekey="account_info_title" /></h4>
                <table style="margin-bottom:5px;" class="table">
                    <tbody>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="accinfo_label_number" /></td>
                            <td>{{account_number}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="row-fluid">
                <h4 style="margin-top:0;margin-bottom:10px;"><asp:Localize runat="server" meta:resourcekey="license_info_label" /></h4>
                <table class="table table-bordered" style="display:inline-block;max-height:110px;overflow-y:auto;font-size:12px;margin-bottom:5px;">
                    <thead>
                        <tr>
                            <th><asp:Localize runat="server" meta:resourcekey="date_label" /></th>
                            <th><asp:Localize runat="server" meta:resourcekey="tags_label" /></th>
                            <th><asp:Localize runat="server" meta:resourcekey="key_label" /></th>
                        </tr>
                    </thead>
                    <tbody>
                        {{#each licenses}}
                            <tr>
                                <td>{{timestamp}}</td>
                                <td>{{tags}}</td>
                                <td>{{key}}</td>
                            </tr>
                        {{/each}}
                    </tbody>
                </table>
            </div>
            <div style="margin-top:0;margin-bottom:5px;" class="row-fluid">
                <table class="table">
                    <tbody>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="software_agents" /></td>
                            <td>
                                {{#if sw_enabled}}
                                <i class="fa fa-check" style="font-size:24px;color:#00ff00;" aria-hidden="true"></i>
                                {{else}}
                                <i class="fa fa-times" style="font-size:24px;color:#ff0000;" aria-hidden="true"></i>
                                {{/if}}
                            </td>
                            <td>{{sw_valid_text}}</td>
                            <td>{{sw_key}}</td>
                        </tr>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="hardware_agents" /></td>
                            <td>
                                {{#if hw_enabled}}
                                <i class="fa fa-check" style="font-size:24px;color:#00ff00;" aria-hidden="true"></i>
                                {{else}}
                                <i class="fa fa-times" style="font-size:24px;color:#ff0000;" aria-hidden="true"></i>
                                {{/if}}
                            </td>
                            <td>{{hw_valid_text}}</td>
                            <td>{{hw_key}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="row-fluid">
                <div class="row-fluid add-license-form <% Response.Write((Request.IsLocal) ? "hide" : ""); %>">
                    <form id="license_form" enctype="multipart/form-data">
                        <span class="btn btn-success fileinput-button">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span><asp:Localize runat="server" meta:resourcekey="add_new_license_btn_label" /></span>
                            <input accept=".bin" id="license_fileinput" style="position:absolute;top:-100px;" type="file" name="files[]">
                        </span>
                    </form>
                </div>
                <div class="row-fluid review-license-form hide">
                    <div class="span6">
                        <input class="input-license-filename span12" type="text" disabled="disabled" />
                    </div>
                    <div class="span6">
                        <button class="btn btn-success span6 btn-upload-license">Upload</button>
                        <button class="btn btn-default span6 btn-cancel-upload-license">Cancel</button>
                    </div>
                </div>
                <div class="row-fluid license-upload-progress hide">
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="progress progress-info progress-striped active">
                                <div class="bar license-upload-progress-bar" style="width: 0%"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <p class="text-info"><asp:Localize runat="server" meta:resourcekey="license_uploading_message" />Uploading...</p>
                    </div>
                </div>
                <div class="row-fluid license-upload-failed hide">
                    <p class="text-error"><asp:Localize runat="server" meta:resourcekey="licence_upload_failed_message" />License upload failed. Something went wrong.</p>
                    <button class="btn btn-default btn-cancel-upload-license"><asp:Localize runat="server" meta:resourcekey="licence_upload_failed_try_again" /></button>
                </div>
                <div class="row-fluid license-server-logs hide">
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="progress progress-info progress-striped active">
                                <div class="bar" style="width: 100%"></div>
                            </div>
                        </div>
                    </div>
                    <div class="license-upload-successful-message hide">
                        <p class="text-success"><%--Upload Successful, waiting for server to respond...--%><asp:Localize runat="server" meta:resourcekey="license_upload_success_message" /></p>
                    </div>
                    <div class="license-detected-on-server-message hide">
                        <p class="text-info"><%--License detected on server...--%><asp:Localize runat="server" meta:resourcekey="license_detected_on_server_message" /></p>
                    </div>
                    <div class="license-upgrade-process-started hide">
                        <p class="text-info"><%--License upgrade process started...--%><asp:Localize runat="server" meta:resourcekey="license_upgrade_process_started_message" /></p>
                    </div>
                    <div class="license-upgrade-success-message hide">
                        <p class="text-info"><%--Success! License upgraded.--%><asp:Localize runat="server" meta:resourcekey="license_upgrade_success_message" /></p>
                    </div>
                    <div class="license-upgrade-failed-message hide">
                        <p class="text-error pull-left"><%--Error, something failed.--%><asp:Localize runat="server" meta:resourcekey="license_upgrade_failed_message" /></p>
                        <button style="margin-left:10px;" class="btn btn-default btn-cancel-upload-license"><asp:Localize runat="server" meta:resourcekey="btn_upgrade_failed_label" /></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="span6">
            <div class="row-fluid">
                <div>
                    <h4 class="pull-left"><asp:Localize runat="server" meta:resourcekey="user_info_title" /></h4>
                    <button style="margin-left:10px;" class="btn btn-default btn-edit-user-info"><i class="fw-icon-edit fw-icon-large"></i></button>
                    <div class="pull-left hide btn-group-edit-section">
                        <button style="margin-left:10px;" class="btn btn-success btn-save-user-info"><asp:Localize runat="server" meta:resourcekey="btn_save_user_info_label" /></button>
                        <button style="margin-left:10px;" class="btn btn-default btn-cancel-edit-user-info"><asp:Localize runat="server" meta:resourcekey="btn_cancel_edit_user_info" /></button>
                    </div>
                </div>
                <table class="table user-info-section">
                    <tbody>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="uinfo_label_username" /></td>
                            <td><span data-editname="username" data-editdatatype="text">{{username}}</span></td>
                        </tr>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="uinfo_label_name" /></td>
                            <td><span data-editable="editable" data-editname="name" data-editdatatype="text">{{name}}</span></td>
                        </tr>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="uinfo_label_lastname" /></td>
                            <td><span data-editable="editable" data-editname="lastname" data-editdatatype="text">{{lastname}}</span></td>
                        </tr>
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="uinfo_label_timezone" /></td>
                            <td>
                                <span data-editable="editable" data-editname="timezone" data-editdatatype="select" data-editselectoptions="{{timezones}}">{{timezone}}{{#if detected_timezone}} [{{detected_timezone}}]{{/if}}</span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="row-fluid">
                <button class="btn btn-primary btn-change-password"><asp:Localize runat="server" meta:resourcekey="change_password_btn_label" /></button>
            </div>
            <div style="margin-top:10px;" class="row-fluid">
                <h4><asp:Localize runat="server" meta:resourcekey="system_info_label" /></h4>
                <table class="table table-bordered">
                    <tr>
                        <td><asp:Localize runat="server" meta:resourcekey="system_name_label" /></td>
                        <td><% =System.Environment.GetEnvironmentVariable("COMPUTERNAME") %></td>
                    </tr>
                    <tr>
                        <td><asp:Localize runat="server" meta:resourcekey="system_box_version_label" /></td>
                        <td><% = WebAppVersion.GetBoxVersion() %></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<script id="modal_change_password" type="text/x-handlebars-template">
    <div>
        <form class="form-change-password form-horizontal" novalidate>
            <fieldset>
                <legend class=""><asp:localize runat="server" meta:resourcekey="change_password_legend" /></legend>
                <div class="row-fluid">
                    <!-- Current Password -->
                    <div class="control-group">
                        <label class="control-label" for="currentpassword"><asp:localize runat="server" meta:resourcekey="currentpassword_form_label" /></label>
                        <div class="controls">
                            <input data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" type="password" name="currentpassword" placeholder="" value="" class="input currentpassword-input" required>
                        </div>
                    </div>

                    <!-- New Password -->
                    <div class="control-group">
                        <label class="control-label" for="currentpassword"><asp:localize runat="server" meta:resourcekey="newpassword_form_label" /></label>
                        <div class="controls">
                            <input data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" type="password" name="newpassword" placeholder="" value="" class="input newpassword-input" required>
                        </div>
                    </div>

                    <!-- Confirm Password -->
                    <div class="control-group">
                        <label class="control-label" for="confirm_newpassword"><asp:localize runat="server" meta:resourcekey="confirmnewpassword_form_label" /></label>
                        <div class="controls">
                            <input data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-validation-matches-match="newpassword" data-validation-matches-message="<asp:localize runat="server" meta:resourcekey="mustmatch_validation_message" />" type="password" name="confirm_newpassword" placeholder="" value="" class="input confirm-newpassword-input" required>
                        </div>
                    </div>
                </div>
            </fieldset>
        </form>
    </div>
</script>

</script>

