﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<% 
    if (Session["SecurityData"] == null)
    {
        Session["SecurityData"] = WebApp.GetSecurityData();
    }
    
    WebApp.SecurityData securityData = (WebApp.SecurityData) Session["SecurityData"]; 
%>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-select/bootstrap-select.min.css") %>" rel="stylesheet" />

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-colorpicker/css/bootstrap-colorpicker.css") %>" rel="stylesheet" />

<style>

    /*.table-layout-fixed{
        table-layout:fixed; 
    }*/

    .backgrid th{
        font-size:12px !important;
    }

    .backgrid tr{
        font-size:12px !important;
    }

        .backgrid tr td{
            /*overflow:visible !important;*/
        }

        .backgrid tr td button{
            font-size:12px !important;
        }

    .large-cell {
        width:200px !important;
    }

    .backgrid .agentName{
        width:50px !important;
    }
    
    .backgrid .name{
        min-width:150px !important; 
    }

    .backgrid .alias{
        min-width:150px !important; 
    }

    /*.backgrid .alias{
        width:70px !important; 
    }

    .backgrid .lineColor{
        width:50px !important; 
    }

    .backgrid .scanRate {
        width:50px !important; 
    }

    .backgrid .dataType {
        width:50px !important; 
    }

    .backgrid .unit {
        width:50px !important; 
    }

    .backgrid .minUnit {
        width:50px !important; 
    }

    .backgrid .maxUnit {
        width:50px !important; 
    }

    .backgrid .enabled {
        width:50px !important; 
    }

    .backgrid .lastValue {
        width:50px !important; 
    }*/

    .span-color-picker-cell > i{
        border:1px solid #000000; 
    }

    .table tbody tr.success>td{background-color:#dff0d8;}
    .table tbody tr.error>td{background-color:#f2dede;}
    .table tbody tr.warning>td{background-color:#fcf8e3;}
    .table tbody tr.info>td{background-color:#d9edf7;}
    .table tbody tr.lock>td{background-color:#bebebe;opacity:0.5;}
    .table-hover tbody tr.success:hover > td{background-color:#d0e9c6;}
    .table-hover tbody tr.error:hover > td{background-color:#ebcccc;}
    .table-hover tbody tr.warning:hover > td{background-color:#faf2cc;}
    .table-hover tbody tr.info:hover > td{background-color:#c4e3f3;}
    .table-hover tbody tr.lock:hover > td{background-color:#bebebe;color:#000;}

    .status-cell{
        background-color:#fff !important; 
        opacity:1 !important; 
    }

    .affix-theader{
        position:fixed;
    }

    .affix-theader th{
        width:50px;
    }

</style>

<div>
    <div class="row-fluid">
        <div style="display:none;margin-top:7%;" class="row-fluid loading-poster text-center">
            <h4 style="display:none" class="loading-text" ><asp:Localize ID="Localize1" runat="server" meta:resourcekey="loading_text" /></h4>
            <h4 style="display:none" class="searching-text" ><asp:Localize ID="Localize2" runat="server" meta:resourcekey="searching_text" /></h4>
            <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                <div class="bar" style="width: 100%;"></div>
            </div>
        </div>
        <div class="infinite-container tags-grid-container">
        </div>
    </div>    
</div>

<script id="subnav_buttons_left_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        <div class="span6">
            <div id="cg_search" style="margin-top:5px;" class="control-group form-inline">
                <label class="control-label" style="margin-right:2px;" for="searchTerm_input">
                    <asp:Localize runat="server" meta:resourcekey="search_input_label" />
                </label>
                <input value="{{searchTerm}}" type="text" id="searchTerm_input" class="input-medium">
            </div>
        </div>
        <div class="span6">
            <div style="position: relative; top: 10px;">
                <label class="checkbox"><input {{checked showOnlyEnabledTags}} id="show_only_enabled_tags_checkbox" type="checkbox"> 
                    <asp:Localize runat="server" meta:resourcekey="show_only_enabled_tags_checkbox_label" />
                </label>
            </div>
        </div>
    </div>        
</script>

<script id="subnav_buttons_right_template" type="text/x-handlebars-template">
    
    <div class="span7">
        <select id="agentsSelect" class="selectpicker span12">
        </select>
    </div>
    <div class="span5">
        <button <% if (WebApp.IsDemo()){ %> disabled="disabled" <% } %> 
            <% if (!securityData.GetModuleActionValue("ihconfiguration_tags_configuration", "write")){ %>
                disabled="disabled" title="<asp:Localize runat="server" meta:resourcekey="readonly_saveconfiguration_label" />"
            <% } %>
            data-loading-text="<asp:Localize runat='server' meta:resourcekey='saveConfiguration_btn_loading' />" 
            id="saveConfiguration_button" class="btn btn-primary">
                <asp:Localize runat="server" meta:resourcekey="saveConfiguration_btn" />
        </button>
    </div>

</script>