USE [IHBoxSystem]
GO
CREATE ROLE caster_equipments_readWrite AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_equipments_readWrite', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_equipments_readWrite', 'SDI/australtek'
GO


USE [IHBoxSystem]
GO
CREATE ROLE caster_equipments_read AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_equipments_read', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'caster_equipments_read', 'SDI/australtek'
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_equipments_read] -- The role
,@name = N'securedsp-CAS.GetCurrentEquipment' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_equipments_readWrite] -- The role
,@name = N'securedsp-CAS.GetCurrentEquipment' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_equipments_read] -- The role
,@name = N'securedsp-CAS.ChangeCurrentEquipment' -- the procedure
,@value = N'' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [caster_equipments_readWrite] -- The role
,@name = N'securedsp-CAS.ChangeCurrentEquipment' -- the procedure
,@value = N'' 
GO




declare @parent int, @result_routeId INT
select @parent=id from [FrontEnd].[Menu] where name='CASTER'

INSERT INTO [FrontEnd].[Routes]
		   ([Route]
		   ,[ModuleName]
		   ,[ModulePath]
		   ,[RequiredRole]
	   )
	 VALUES
		   (
		   '!/caster-equipments(/)'
		   , 'caster-equipments'
		   , 'custom-screens/caster-equipments/'
		   , 'caster_equipments_read'           
		   )
		   SET @result_routeId = @@IDENTITY
INSERT INTO [FrontEnd].[Menu]
		   ([Parent]
		   ,[Name]
		   ,[RouteID]
		   ,[SortOrder]
		   ,[Enabled]
		   ,[Visible]
		   ,[RequiredRole]
		   ,[Group]
		  )
	 VALUES
		   (
		   @parent
		   ,'Caster Equipments'
		   ,@result_routeId 
		   ,1
		   ,1
		   ,1
		   ,'caster_equipments_read'
		   ,NULL
		 )
GO

/*------------------------------------------------------Profiles------------------------------------------------------*/
USE [IHBoxSystem]
GO

DECLARE @ModuleId INT

INSERT INTO [SECURITY].[Modules]
		   ([Code]
		   ,[Name])
	 VALUES
		   ('caster-equipments'
		   ,'Caster Equipments')

		  SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'readWrite'
		   ,'Read/Write'
		   ,'caster_equipments_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','caster_equipments_read')
GO


