USE [IHBoxSystem]
GO

/* README 


*/

declare @parent int
select @parent=id from [FrontEnd].[Menu] where name='EAF'

delete from [FrontEnd].[Routes] where [ModuleName]='eaf-components-history'
delete from [FrontEnd].[Menu] where [Name]='EAF Components History'


INSERT INTO [FrontEnd].[Routes]
           ([Route]
           ,[ModuleName]
           ,[ModulePath]
           ,[RequiredRole]
       )
     VALUES
           (
		   '!/eaf-components-history(/:start)(/:end)(/:furnaceCode)'
           , 'eaf-components-history'
		   , 'custom-screens/eaf-components-history/'
           , 'EquipmentsRole'
           
		   )



INSERT INTO [FrontEnd].[Menu]
           ([Parent]
           ,[Name]
           ,[RouteID]
           ,[SortOrder]
           ,[Enabled]
           ,[Visible]
           ,[RequiredRole]
           ,[Group]
          )
     VALUES
           (
		   @parent
		   ,'EAF Components History'
           ,@@IDENTITY
           ,1
           ,1
           ,1
           ,'EquipmentsRole'
           ,NULL
         )
GO

USE IHBoxSystem

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [EquipmentsRole] -- The role
,@name = N'securedsp-EAF.GetComponentsHistoryWeb' -- the procedure
,@value = N'' 

Go



UPDATE EAF.catEquipmentLocations set [Name] = 'Breast Electrode' where [Name] = '4Tuber'