﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span12 row-fluid">
            <div class="span4">                
                <div style="text-align: left;">
                    <button id="backNavBtn" style="margin-left:5px;" class="btn btn-nav btn-primary">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
                    </button>          
                    <label class="control-label" style="width:200px;">
                         <div id="heat-picker-multi-select"></div>
                   </label>
                    <button id="forwardNavBtn" class="btn btn-nav btn-primary" >
                            <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
                    </button>
                </div>        
           
            </div>
            <div class="span4">
                <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-30px;"></div>
            </div>
            <div class="span3">                
                <div data-bind="classes: { hide: not(hasData_pouredbackLegend), }" >
                    <h6 data-bind="text: pouredbackLegend"></h6>
                </div>
            </div>
            <div class="span1">
                
                <button id="refreshBtn" class="btn btn-primary pull-right" style="margin-right:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>
            </div>
       </div>
    </div>
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>

    <div class="main-data-container" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="center-box-small">
            <div class="row-fluid box-container-small" style="margin-top:10px;">  
                <div class="data-container-small">
                    <h5 class="grid-title-small" data-bind="text:  coalesce(mainData_headerInfo, '-'),"></h5>
                </div>        
            </div>
        </div>
        
    </div>
    
     <div class="tables-container row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), }">   
        <div class="span4 ">
                      
            <table class="grid-styles table">
                    <thead>
                    <tr>
                        <th colspan="2">Information</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Melt Order</td>                                
                        <td> <span class="info-field-value" data-bind="text:  coalesce(mainData_meltOrder, '-'),"></span></td>
                    </tr>                   
                    <tr>
                        <td>MWH</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(mainData_energy, '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mwh_unit_legend /></span>
                        </td>
                    </tr> 
                     <tr>
                         <td>KWH/Ton</td>                                
                         <td> 
                             <span class="info-field-value" data-bind="text:  coalesce(mainData_kwhton, '-'),"></span>
                             <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_kwh_ton_unit_legend /></span>
                         </td>
                     </tr> 
                    <tr>
                        <td>Yield</td>
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_yield, '-'),"></span></td>
                    </tr>
                     <tr>
                        <td>Tap Weight | Drain Weight</td>
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_tapAndDrainWeight, '-'),"></span></td>
                    </tr>
                     <tr>
                        <td>Pourback</td>
                        <td> <span class="info-field-value" data-bind="text:  coalesce(mainData_pourbackInfo, '-'),"></span></td>
                    </tr>
                    <tr>
                        <td>Power On</td>                                
                        <td>
                                <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_powerOn, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>                   
                    <tr>
                        <td>Power Off</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_powerOff, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                    <tr>
                        <td>Tap To Tap</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(duration(secondaryData2_tapToTap, 's','m:s'), '-'),"></span>
                            <span class="info-unit-label"><asp:Localize runat=server meta:resourcekey=process_info_mm_ss_unit_legend /></span>
                        </td>
                    </tr>
                    <tr>
                        <td>Spray Ring Effectiveness (%) : Phase A | Phase B | Phase C</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:secondaryData2_PhaseSprayRingEffectiveness"></span>
                            
                        </td>
                    </tr>
                    <tr>
                        <td>Bypass Breaker Utilization</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:secondaryData2_BypassBreakerUtilization"></span>
                            <span class="info-unit-label">%</span>
                    
                        </td>
                    </tr>
                    <tr>
                        <td>Conditions for Bypass Breaker Maintained</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:secondaryData2_ConditionsBypassBreakerMaintained"></span> 
                            <span class="info-unit-label">%</span>
                        </td>
                    </tr>  
                
                    <tr>
                        <td>NCC 1 | NCC 2 | NCC 3</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(secondaryData2_nccs, '-'),"></span>
                        </td>
                    </tr>               
                   <tr>
                        <td>Cave In 1 | Cave In 2 | Cave In 3</td>                                
                        <td> 
                            <span class="info-field-value" data-bind="text:  coalesce(secondaryData2_caves, '-'),"></span>
                        </td>
                    </tr>  
                    <tr>
                        <td>Regulation Mode | Burner Program | Power Program</td>
                        <td> <span class="info-field-value" data-bind="text:  coalesce(secondaryData1_regulation_burner_power, '-'),"></span></td>
                    </tr>                            
              
                    <tr>
                        <td>Electrode A | Electrode B | Electrode C  </td>                                
                        <td>
                            <span class="info-field-value" data-bind="text:  coalesce(mainData_electrode1, '-'),"></span>
                            <span class="info-field-value" data-bind="text:  coalesce(mainData_electrode2, '-'),"></span>
                            <span class="info-field-value" data-bind="text:  coalesce(mainData_electrode3, '-'),"></span>
                            <%--<i class="fa process-info-field-value" style="margin-left: 30%;font-size: 20px;" data-bind="classes: { 'fa-check-square-o': secondaryData1_electrode1Changed, 'fa-square-o': not(secondaryData1_electrode1Changed), }," />
                            <i class="fa process-info-field-value" style="margin-left: 15%;font-size: 20px;" data-bind="classes: { 'fa-check-square-o': secondaryData1_electrode2Changed, 'fa-square-o': not(secondaryData1_electrode2Changed), }," />
                            <i class="fa process-info-field-value" style="margin-left: 15%;font-size: 20px;" data-bind="classes: { 'fa-check-square-o': secondaryData1_electrode3Changed, 'fa-square-o': not(secondaryData1_electrode3Changed), }," />
                       --%>
                        </td>
                    </tr>  
                    <tr>
                      <td>Tap Hold</td>
                      <td> <span class="info-field-value" data-bind="text:  coalesce(mainData_heatsOnTapHole, '-'),"></span></td>
                  </tr> 
                    <tr>
                        <td>Heats On Delta</td>
                        <td> <span class="info-field-value" data-bind="text:  coalesce(mainData_heatsOnDelta, '-'),"></span></td>
                    </tr> 

                </tbody>
            </table>


             <div class="process-alloys-grid-container items-grid-container"></div>
             <div class="process-temperatures-grid-container items-grid-container"></div> 
           
             <div class="process-buckets-grid-container items-grid-container"></div>

        </div>
        <div class="span8 row-fluid">
            <div class="span8">
                <div class="process-phases-grid-container items-grid-container"></div>                
                <div class="process-phases-chart-container row-fluid print-phases-chart" data-bind="collection: $phases, itemView: 'phaseChartView'"></div>
            </div>
            <div class="span4">                                
                <div class="process-injectors-grid-container items-grid-container"></div>
            </div>

             <div class="chart-container" style="position: relative;width:94%"  data-bind="classes: { hide: any(not(hasData), isLoading), }">        
                <canvas id="EAFChart"></canvas>  
            </div>

        </div>
     </div>

    

    <div class="row-fluid"  data-bind="classes: { hide: any(not(hasData),not(hasData_slagChemistries), isLoading), }" style="margin-top:10px">
        <div class="span4"></div>
        <div class="span8">
                  <table style="width:80%">
                <tr>
                <td class="not-border" style="width:30%"></td>
                <td class="not-border">
                    <label>
                        <strong>
                            <asp:localize runat="server" meta:resourcekey="structural_aims" />
                        </strong>
                    </label>
                </td>
                <td class="not-border">
                    <label>
                        <strong>
                            MgO:
                        </strong>
                        <span data-bind="text: Structural_MgO"></span>
                    </label>

                </td>
                <td class="not-border">
                    <label>
                        <strong>
                            FeO:
                        </strong>
                        <span data-bind="text: Structural_FeO"></span>
                    </label>
                </td>
                <td class="not-border">
                    <label>
                        <strong>
                            B3ratio:
                        </strong>
                        <span data-bind="text: Structural_B3"></span>
                    </label>
                </td>
                </tr>
                <tr>
                <td class="not-border" style="width:30%"></td>
                <td class="not-border">
                    <label>
                        <strong>
                            <asp:localize runat="server" meta:resourcekey="rail_aims" />
                        </strong>
                    </label>
                </td>
                <td class="not-border">
                    <label>
                        <strong>
                            MgO:
                        </strong>
                        <span data-bind="text: Rail_MgO"></span>
                    </label>

                </td>
                <td class="not-border">
                    <label>
                        <strong>
                            FeO:
                        </strong>
                        <span data-bind="text: Rail_FeO"></span>
                    </label>
                </td>
                <td class="not-border">
                    <label>
                        <strong>
                            B3ratio:
                        </strong>
                        <span data-bind="text: Rail_B3"></span>
                    </label>
                </td>
                </tr>
        </table>
            <div class="process-slag-chemistries-grid-container items-grid-container"></div>
        </div>
  
    </div>

    <!---Tables--->

  <%--  <div class="row-fluid span11 grids-containers" data-bind="classes: { hide: any(not(hasData), isLoading), }">
        <div class="span5 pull-left">
            <div class="process-phases-grid-container items-grid-container"></div>
            <div class="process-phases-chart-container row-fluid print-phases-chart" data-bind="collection: $phases, itemView: 'phaseChartView'"></div>
        </div>
         <div class="span3 pull-left">
            <div class="process-injectors-grid-container items-grid-container"></div>
        </div>
        <div class="span4 pull-left" data-bind="classes: { hide: not(hasData_pourback), }">            
            <div class="process-total-consumptions-grid-container items-grid-container"></div>
            <div class="process-pourback-grid-container items-grid-container"></div>

        </div>
         
     
    </div>--%>
<%--    <div class="row-fluid span11 grids-containers" data-bind="classes: { hide: any(not(hasData), isLoading), }">    
        <div class="span5 pull-left">
            <div class="process-temperatures-grid-container items-grid-container"></div>
        </div>
        <div class="span3 pull-left">            
             <div class="process-alloys-grid-container items-grid-container"></div>
        </div>
       <div class="span4 pull-left">
            <div class="process-buckets-grid-container items-grid-container"></div>
        </div>
      
   
    </div>   --%>
    <%--<div class="row-fluid span11 grids-containers">
        <div data-bind="classes: { hide: any(not(hasData),not(hasData_slagChemistries), isLoading), }">
            <table style="width:80%">
                  <tr>
                    <td class="not-border" style="width:30%"></td>
                    <td class="not-border">
                        <label>
                            <strong>
                                <asp:localize runat="server" meta:resourcekey="structural_aims" />
                            </strong>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                MgO:
                            </strong>
                            <span data-bind="text: Structural_MgO"></span>
                        </label>

                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                FeO:
                            </strong>
                            <span data-bind="text: Structural_FeO"></span>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                B3ratio:
                            </strong>
                            <span data-bind="text: Structural_B3"></span>
                        </label>
                    </td>
                  </tr>
                  <tr>
                    <td class="not-border" style="width:30%"></td>
                    <td class="not-border">
                        <label>
                            <strong>
                                <asp:localize runat="server" meta:resourcekey="rail_aims" />
                            </strong>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                MgO:
                            </strong>
                            <span data-bind="text: Rail_MgO"></span>
                        </label>

                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                FeO:
                            </strong>
                            <span data-bind="text: Rail_FeO"></span>
                        </label>
                    </td>
                    <td class="not-border">
                        <label>
                            <strong>
                                B3ratio:
                            </strong>
                            <span data-bind="text: Rail_B3"></span>
                        </label>
                    </td>
                  </tr>
            </table>
            <div class="process-slag-chemistries-grid-container items-grid-container"></div>
        </div>
    </div>--%>
    
    

</div>


<script id="phase_chart_view" type="text/x-handlebars-template">

    <div data-bind="text: coalesce(formattedDuration, ''), css: { width: format('$1%', mathDiv(mathMul(duration, 100), processDuration)), }, attr: { 'class': format('phases-chart-item phase-$1-color', order), },"></div>
    
</script>
