﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid">
    <span class="span2"></span>
    <%--<span class="span2 ladle-select-container"></span>--%>
    
    <span class="span6">        
        <label style="margin-left:10px;margin-bottom:0 !important; ">
            <select disabled data-bind=" value: ladleId, options: ladles," style="max-width: 90%; height: 40px; font-size: 24px; color: rgb(96, 96, 96);">
            </select>
        </label>
    </span>

    <span class="span2 history-button-container">
        <button class="btn btn-primary" id="historyButton" style="width: 9em; height: 4em">History</button>
    </span>
    <span class="span2 operation-container">
        <button  class="btn btn-primary" id="drainButton" style="width: 9em;height: 4em " >Drain</button>
    </span>
</div>

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>
<br />
<div class="row-fluid" data-bind="classes: { hide: any(not(hasData), isLoading), },">
    <div class="row-fluid">
        <span class="span1"></span>
        <span class="span10 items-grid-container"></span>
        <span class="span1"></span>
    </div>
    <div class="buttons-container">
    </div>
</div>


<script id="spare_part_modal" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: partName"></h3>
    </div>
    <div style="" class="modal-body">
        <div class="parts-container">
        </div>
    </div>
    <div style="" class="modal-footer">
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="override_heat_counter_dialog" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>Override</h3>
    </div>
    <div style="" class="modal-body">
        <div class="row-fluid" style="margin: 0 0 1em 0">
            <span><b data-bind="text: ladle" ></b> - <b data-bind= "text: partName"></b>, <b> Current Value: <span data-bind="text: counterLabel"></span></b></span>
        </div>
        <div class= "row-fluid" style="margin: 1em 0 1em 0">
            <span class="span4"><b>Next Value</b></span>
            <input type= "number" name="" id="nextValueInput" data-bind="value: counterValue">
        </div>
        <div class="row-fluid">
            <div class="row-fluid" style="margin: 0 0 .5em 0">
                Comment
            </div>
            <div class="row-fluid">
                <textarea name="" id="commentTxt" style="width:80%; height:10em"></textarea>
            </div>
        </div>
    </div>
    <div style="" class="modal-footer">
        <div class="row-fluid">
            <button id="overrideOkBtn" class="span4 btn btn-primary">Ok</button>
            <span class="span4"></span>
            <button id="overrideCancelBtn" class="span4 btn">Cancel</button>
        </div>
    </div>
</script>
