USE [IHBoxSystem]
GO

---------------------------------------- CREATE ROLES
IF DATABASE_PRINCIPAL_ID('lad_ladlesdashboard_write') IS NULL
BEGIN
	CREATE ROLE lad_ladlesdashboard_write;
end
go
IF DATABASE_PRINCIPAL_ID('lad_ladlesdashboard_read') IS NULL
BEGIN
	CREATE ROLE lad_ladlesdashboard_read;
end

---------------------------------------- CREATE MODULE 
declare @id int
insert into [Security].[Modules] (Code,[Name])
values ('ladles-dashboard' ,'Ladles Dashboard')

set @id = @@IDENTITY

insert into [Security].[ModuleActions] (ModuleID,Code,[Name],[Role])
values (@id,'readWrite','Read/Write','lad_ladlesdashboard_write')

insert into [Security].[ModuleActions] (ModuleID,Code,[Name],[Role])
values (@id,'read','Read','lad_ladlesdashboard_read')

delete from frontend.routes where ModuleName='ladles-dashboard'

INSERT INTO [FrontEnd].[Routes]
           ([Route]
           ,[ModuleName]
           ,[ModulePath]
           ,[RequiredRole]
       )
     VALUES
           (
		   '!/ladles-dashboard(/)'
           , 'ladles-dashboard'
		   , 'custom-screens/ladles-dashboard/'
           , 'lad_ladlesdashboard_read'       
		   )

		   USE [IHBoxSystem]
GO


delete from frontend.menu where  name = 'Ladles Dashboard'

INSERT INTO [FrontEnd].[Menu]
           ([Parent]
           ,[Name]
           ,[RouteID]
           ,[SortOrder]
           ,[Enabled]
           ,[Visible]
           ,[RequiredRole]
           ,[Group]
          )
     VALUES
           (
		   56
		   ,'Ladles Dashboard'
           ,@@IDENTITY
           ,1
           ,1
           ,1
           ,'lad_ladlesdashboard_read'
           ,NULL
           )
GO



EXEC sp_addrolemember 'lad_ladlesdashboard_write', 'admin'
EXEC sp_addrolemember 'lad_ladlesdashboard_read', 'admin'

go


EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetHeats'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetLadleDashboard'			  
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetLadlePositions'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetLadles'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetMeltOrders'			  
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.MoveMeltOrderPriority' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.MoveMeltOrderPriorityWeb' 


EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetHeats'					,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetLadleDashboard'			,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetLadlePositions'			,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetLadles'					,@value =  null	
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.GetMeltOrders'			  	,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.MoveMeltOrderPriority' 		,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_read] ,@name = N'securedsp-LAD.MoveMeltOrderPriorityWeb'	,@value =  null


EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.AssignHeatToLadleWeb'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.AssignMeltOrderToHeatWeb'			  
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ChangeLadleComponentsWeb'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ChangeLadlePositionWeb'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.DrainLadle'			  
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetEquipmentsPerType' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetLadleComponentHistoryWeb' 
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetLadleEquipmentDetailsWeb'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetLadles'			  
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.PourBackLadleWeb'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ReladleWeb'   
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ReturnLadleWeb'			  
EXEC sp_dropextendedproperty @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.UpsertHeatWeightsWeb' 


EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.AssignHeatToLadleWeb'   		,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.AssignMeltOrderToHeatWeb'		,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ChangeLadleComponentsWeb'   	,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ChangeLadlePositionWeb'   		,@value =  null	
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.DrainLadle'			  		,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetEquipmentsPerType'  		,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetLadleComponentHistoryWeb' 	,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetLadleEquipmentDetailsWeb'  	,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.GetLadles'			  			,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.PourBackLadleWeb'   			,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ReladleWeb'   					,@value =  null	
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.ReturnLadleWeb'			  	,@value =  null
EXEC sp_addextendedproperty  @level0type = N'USER' ,@level0name = [lad_ladlesdashboard_write] ,@name = N'securedsp-LAD.UpsertHeatWeightsWeb'  		,@value =  null





------------14-07-2022-----------

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lad_ladlesdashboard_write] -- The role
,@name = N'securedsp-LAD.SplitHeat' -- the procedure
,@value = N'' 
GO





------------19-10-2022-----------

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lad_ladlesdashboard_write] -- The role
,@name = N'securedsp-LAD.RemoveHeat' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lad_ladlesdashboard_write] -- The role
,@name = N'securedsp-LAD.CreateHeat' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO


-------------------------------------------------
----------------- 1/3/2023 ----------------------
-------------------------------------------------

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lad_ladlesdashboard_write] -- The role
,@name = N'securedsp-LAD.FixLadleNumberOnHeatWeb' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO


-------------------------------------------------
----------------- 14/4/2023 ----------------------
-------------------------------------------------
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lad_ladlesdashboard_write] -- The role
,@name = N'securedsp-LAD.ClearLadleWeb' -- the procedure
,@value = N'SendCurrentUser=TRUE' 
GO
