﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>
<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>
<div class="row-fluid" data-bind="classes: { hide: not(all(hasData, not(isLoading), isNull(itemId))), },">
    <div class="span8">
        <div class="row-fluid items-grid-container infinite-container"></div>
    </div>
    <div class="span4" data-bind="classes: { hide: (showMaterialSystemsGrid), }">
        <div class="row-fluid" style="margin-top:20%">
            <i class="fw-icon-arrow-left" style="font-size:180px;margin-left:10%;"></i>
        </div>
        <div class="row-fluid" style="text-align: center;">
            <h3 style="font-size:50px;line-height:50px;">
                <asp:localize runat="server" meta:resourcekey="no_item_selected" />
            </h3>
        </div>
        <div >     
            
        </div> 
    </div>
    <div class="span4" data-bind="classes: { hide: not(showMaterialSystemsGrid), }">
        <div class="row-fluid items-grid-container-systems" ></div>
    </div>
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=save_title />" class="btn btn-cell-action btn-small btn-save hide"><i class="fa fa-floppy-o"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=discard_title />" class="btn btn-cell-action btn-small btn-discard hide"><i class="fa fa-times"></i></button>
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_batch_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
    </div>
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">
            <button class="btn add-item" style="margin:0;" data-bind="classes: { hide: not(not(itemId)), },">
                <asp:Localize runat="server" meta:resourcekey="add_item_btn_label" />
            </button>
            <button id="refreshBtn" style="margin-left:10px;" class="btn btn-primary pull-right" data-bind="classes: { hide: not(not(itemId)), },">
                <i class="fa fa-refresh"></i>
            </button>
        </div>
    </div>
</script>