﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link class="css-load" href="<%= ResolveUrl("~/assets/libs/js/codemirror-5.22.0/lib/codemirror.css") %>" rel="stylesheet" />
<link class="css-load" href="<%= ResolveUrl("~/assets/libs/js/codemirror-5.22.0/addon/lint/lint.css") %>" rel="stylesheet" />
<link class="css-load" href="<%= ResolveUrl("~/assets/libs/js/codemirror-5.22.0/addon/hint/show-hint.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/screen-builder/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<style>

    .btn-on-frame {
        opacity:0.5;
    }

        .btn-on-frame:hover {
            opacity:1;
        }

        .btn-on-frame:active, btn-expand:focus {
            opacity:1;
        }

    .fullscreen {
        width:100% !important;
        margin-left:0 !important;
    }

        .fullscreen > div > .preview-frame {
            border:0 !important; 
        }

    .draggable-elem {
        cursor:move;
    }

    .expand-collapse-buttons {
        position:absolute;
        left:-23px;
        top:0;
        z-index:999;
    }

    .section-expanded > div > .expand-collapse-buttons {
        left:-18px;
        top:-10px;
    }

</style>

<div>
    <div class="row-fluid"> <!-- toolbar -->
    </div>
    <div class="row-fluid">
        <div class="span6 resize-height-to-fit editor-section section-normal"> <!-- code section -->
            <textarea style="display:none;" class="editor-container"></textarea>
        </div>
        <div class="span6 resize-height-to-fit preview-section section-normal"> <!-- preview section -->
            <div style="position:relative;width:100%;height:100%;">
                <div class="expand-collapse-buttons">
                    <div class="btn-preview-toolbar" data-toggle="tooltip" data-placement="right" title="<asp:Localize runat="server" meta:resourcekey="expand_btn_tooltip" />" >
                        <button disabled="disabled" type="button" class="btn btn-mini btn-on-frame btn-preview-toolbar btn-expand-frame">
                            <i class="fa fa-expand" aria-hidden="true"></i>
                        </button>
                    </div>
                    <div class="btn-preview-toolbar" data-toggle="tooltip" data-placement="right" title="<asp:Localize runat="server" meta:resourcekey="compress_btn_tooltip" />" >
                        <button type="button" class="btn btn-mini btn-on-frame btn-preview-toolbar btn-collapse-frame hide">
                            <i class="fa fa-compress" aria-hidden="true"></i>
                        </button>
                    </div>
                </div>
                <div style="position:absolute;right:0;top:0;z-index:999;display:inline-block;">
                    <div class="row-fluid">
                        <div class="btn-group btn-group-vertical">
                            <div style="padding-left:12px;" class="btn-preview-toolbar" data-toggle="tooltip" title="<asp:Localize runat="server" meta:resourcekey="external_link_btn_tooltip" />">
                                <button style="padding-right: 13px;padding-left: 12px;" disabled="disabled" type="button" class="btn btn-on-frame btn-preview-toolbar btn-open-preview">
                                    <i class="fa fa-external-link" aria-hidden="true"></i>
                                </button>
                            </div>
                            <div style="padding-left:12px;" class="btn-preview-toolbar" data-toggle="tooltip" title="<asp:Localize runat="server" meta:resourcekey="add_image_btn_tooltip" />">
                                <button disabled="disabled" type="button" class="btn btn-on-frame btn-preview-toolbar btn-add-image">
                                    <i class="fa fa-image" aria-hidden="true"></i>
                                </button>
                            </div>
                            <div style="padding-left:12px;" class="btn-preview-toolbar" data-toggle="tooltip" title="<asp:Localize runat="server" meta:resourcekey="add_tag_btn_tooltip" />" >
                                <button style="padding-right: 13px;padding-left: 14px;" disabled="disabled" type="button" class="btn btn-on-frame btn-preview-toolbar btn-add-tag">
                                <i class="fa fa-tag" aria-hidden="true"></i>
                            </button>
                            </div>
                            <div style="padding-left:12px;" class="btn-preview-toolbar" data-toggle="tooltip" title="<asp:Localize runat="server" meta:resourcekey="add_chart_btn_tooltip" />" >
                                <button style="padding-left: 12px;padding-right: 11px;" disabled="disabled" type="button" class="btn btn-on-frame btn-preview-toolbar btn-add-chart">
                                    <i class="fa fa-line-chart" aria-hidden="true"></i>
                                </button>
                            </div>
                            <div style="padding-left:12px;" class="btn-preview-toolbar" data-toggle="tooltip" title="<asp:Localize runat="server" meta:resourcekey="add_text_btn_tooltip" />" >
                                <button style="padding-left: 13px;padding-right: 14px;" disabled="disabled" type="button" class="btn btn-on-frame btn-preview-toolbar btn-add-text">
                                    <i class="fa fa-font" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <iframe class="preview-frame" style="position:relative;height:100%;width:100%;border:1px solid #ccc;"></iframe>
            </div>
        </div>
    </div>
</div>
</script>

<script id="viewer_tagviewer_template" type="text/x-handlebars-template">
    <style>
        tagviewer {
            position:absolute !important;
        }
        .tagviewer-el {
            display:inline-block; 
            width:auto; 
            height:auto;
        }
    </style>
    <span data-bind="text: concat(select(isNull(label), '', concat(label, ': ')), value, ' ', coalesce(unit, ''))"></span>
</script>

<script id="viewer_chartviewer_template" type="text/x-handlebars-template">
    <style>
        .chartviewer-el {
            display:inline-block; 
            width:auto; 
            height:auto;
        }
    </style>
    <div class="chart-canvas-container">
        <!--here goes chart-->
    </div>
</script>

<script id="screen_builder_editr_inline_toolbar_template" type="text/template">
    <style>
        .editor-editr-elem {
        }

            .editor-editr-elem:hover {
                outline:3px solid #ccc; 
            }

            .editor-editr-elem:hover > div.inline-toolbar {
                display:block; 
            }

        .inline-toolbar {
            position:absolute; 
            z-index:9999999999999999; 
            right:0; 
            top:-25px; 
            height:25px; 
            width:100%; 
            display:none;
        }
    </style>

    <div class="inline-toolbar">
        <div class="btn-group pull-right">
            {{#if hasLink}}
                <button title="<asp:Localize runat="server" meta:resourcekey="remove_link_toolbar_label" />" data-editor-editr-toolbar-btn-action="unlink" type="button" class="btn editor-editr-inline-toolbar-btn">
                    <i class="fa fa-chain-broken " aria-hidden="true"></i>
                </button>
            {{else}}
                <button title="<asp:Localize runat="server" meta:resourcekey="add_link_toolbar_label" />" data-editor-editr-toolbar-btn-action="link" type="button" class="btn editor-editr-inline-toolbar-btn">
                    <i class="fa fa-link" aria-hidden="true"></i>
                </button>
            {{/if}}

            <button title="<asp:Localize runat="server" meta:resourcekey="edit_toolbar_label" />" data-editor-editr-toolbar-btn-action="edit" type="button" class="btn editor-editr-inline-toolbar-btn"><i class="fa fa-edit" aria-hidden="true"></i></button>

            <button title="<asp:Localize runat="server" meta:resourcekey="move_up_toolbar_label" />" data-editor-editr-toolbar-btn-action="move-up" type="button" class="btn editor-editr-inline-toolbar-btn"><i class="fa fa-level-up" aria-hidden="true"></i></button>
            <button title="<asp:Localize runat="server" meta:resourcekey="move_down_toolbar_label" />" data-editor-editr-toolbar-btn-action="move-down" type="button" class="btn editor-editr-inline-toolbar-btn"><i class="fa fa-level-down" aria-hidden="true"></i></button>

            <button title="<asp:Localize runat="server" meta:resourcekey="remove_toolbar_label" />" data-editor-editr-toolbar-btn-action="remove" type="button" class="btn editor-editr-inline-toolbar-btn"><i class="fa fa-trash" aria-hidden="true"></i></button>
        </div>
    </div>
</script>

<script type="text/x-handlebars-template" id="screen_builder_add_image_selector">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            {{#ifEquals mode 'CREATE'}}
            <asp:Localize runat="server" meta:resourcekey="add_image_title" />
            {{else}}
            <asp:Localize runat="server" meta:resourcekey="update_image_title" />
            {{/ifEquals}}
        </h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid">
            <select multiple="multiple" data-bind="options: filesBinding" class="files-select span12">
            </select>
        </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-add btn btn-block btn-primary">
                        {{#ifEquals mode 'CREATE'}}
                        <asp:Localize runat="server" meta:resourcekey="btn_add_label" />
                        {{else}}
                        <asp:Localize runat="server" meta:resourcekey="btn_update_label" />
                        {{/ifEquals}}
                    </button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="btn_cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>

<script type="text/x-handlebars-template" id="screen_builder_add_link_selector">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="add_link_title" /></h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="type-selector">
                <label class="radio inline">
                  <input data-bind="checked: linkType" name="linkTypeRadios" type="radio" id="linkTypeRadio_system" value="systemScreen"> <asp:Localize runat="server" meta:resourcekey="link_system_screen_label" />
                </label>
                <label class="checkbox inline">
                  <input data-bind="checked: linkType" name="linkTypeRadios" type="radio" id="linkTypeRadio_trendingView" value="trendingView"> <asp:Localize runat="server" meta:resourcekey="link_trending_view_label" />
                </label>
                <label class="checkbox inline">
                  <input data-bind="checked: linkType" name="linkTypeRadios" type="radio" id="linkTypeRadio_url" value="url"> <asp:Localize runat="server" meta:resourcekey="link_url_label" />
                </label>
            </div>
        </div>
        <div class="row-fluid" style="margin-top:10px;">
            <div data-bind="toggle: equals(linkType, 'url')" class="row-fluid external-url-settings hide">
                <label>
                    <asp:Localize runat="server" meta:resourcekey="external_url_input_label" />
                    <input class="span12 external-url-input" type="text" style="margin-top:5px;" />
                </label>
            </div>
            <div data-bind="toggle: equals(linkType, 'systemScreen')" class="row-fluid system-screen-settings">
                <!--here goes system screens multiple select view-->
            </div>
            <div data-bind="toggle: equals(linkType, 'trendingView')" class="row-fluid trending-view-settings hide">
                <!--here goes trending views multiple select view-->
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-add btn btn-block btn-primary"><asp:Localize runat="server" meta:resourcekey="btn_add_label" /></button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="btn_cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>

    <div class="hide system-screens-select-template">
        <select style="height:250px;" multiple="multiple" class="system-screens-select span12">
            {{HBExp "#each screens"}}
                {{HBExp "#if children"}}
                <optgroup label="{{HBExp "name"}}">
                    {{HBExp "#if route"}}
                        <option value="{{HBExp "route"}}">{{HBExp "name"}}</option>
                    {{HBExp "/if"}}
                    {{HBExp "#each children"}}
                    <option value="{{HBExp "route"}}">{{HBExp "name"}}</option>
                    {{HBExp "/each"}}
                </optgroup>
                {{HBExp "else"}}
                <option value="{{HBExp "route"}}">{{HBExp "name"}}</option>
                {{HBExp "/if"}}
            {{HBExp "/each"}}
        </select>
    </div>
    
    <div class="hide trending-views-select-template">
        <select style="height:250px;" multiple="multiple" class="trending-views-select span12">
            {{HBExp "#each trendingViews"}}
                {{HBExp "#if children"}}
                <optgroup label="{{HBExp "name"}}">
                    {{HBExp "#if route"}}
                        <option value="{{HBExp "name"}}">{{HBExp "name"}}</option>
                    {{HBExp "/if"}}
                    {{HBExp "#each children"}}
                    <option value="{{HBExp "name"}}">{{HBExp "name"}}</option>
                    {{HBExp "/each"}}
                </optgroup>
                {{HBExp "else"}}
                <option value="{{HBExp "name"}}">{{HBExp "name"}}</option>
                {{HBExp "/if"}}
            {{HBExp "/each"}}
        </select>
    </div>
</script>

<script type="text/x-handlebars-template" id="screen_builder_add_tag_selector">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            {{#ifEquals mode 'CREATE'}}
            <asp:Localize runat="server" meta:resourcekey="add_tag_title" />
            {{else}}
            <asp:Localize runat="server" meta:resourcekey="edit_tag_title" />
            {{/ifEquals}}
        </h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <%--<div class="row-fluid">
            <select class="agent-select">
                {{HBExp "#each agents"}}
                    <optgroup label="{{HBExp "type"}}">
                        <option value="{{HBExp "id"}}">{{HBExp "type"}}: {{HBExp "name"}}</option>
                        {{HBExp "#each children"}}
                        <option value="{{HBExp "id"}}">{{HBExp "type"}}: {{HBExp "name"}}</option>
                        {{HBExp "/each"}}
                    </optgroup>
                {{HBExp "/each"}}
            </select>
        </div>--%>
        <div class="row-fluid">
            <input data-bind="value:searchQuery, events:['keyup', 'change']" type="text" class="search-query span12" placeholder="Search">
        </div>
        <div class="row-fluid" style="margin-top:10px;">
            <div class="tags-select-container">
                <!-- here goes tags select template -->
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-add btn btn-block btn-primary">
                        {{#ifEquals mode 'CREATE'}}
                        <asp:Localize runat="server" meta:resourcekey="btn_add_label" />
                        {{else}}
                        <asp:Localize runat="server" meta:resourcekey="btn_update_label" />
                        {{/ifEquals}}
                    </button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="btn_cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>

    <div class="hide tags-multiple-select-template">
        <select style="height:250px;" multiple="multiple" class="tags-select span12">
            {{HBExp "#each agents"}}
                <optgroup label="{{HBExp "name"}}">
                    {{HBExp "#each tags"}}
                    <option value="{{HBExp "id"}}">{{HBExp "name"}}</option>
                    {{HBExp "/each"}}
                </optgroup>
            {{HBExp "/each"}}
        </select>
    </div>
</script>

<script type="text/x-handlebars-template" id="screen_builder_chart_builder_modal">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            {{#ifEquals mode 'CREATE'}}
            <asp:Localize runat="server" meta:resourcekey="add_chart_title" />
            {{else}}
            <asp:Localize runat="server" meta:resourcekey="update_chart_title" />
            {{/ifEquals}}
        </h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid">
            <h4><asp:Localize runat="server" meta:resourcekey="chart_properties_title" /></h4>
            <%--<form class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="inputTitle"><asp:Localize runat="server" meta:resourcekey="chart_properties_title_label" /></label>
                    <div class="controls">
                        <input type="text" id="inputTitle" placeholder="">
                    </div>
                </div>
            </form>--%>
            <label>
                <asp:Localize runat="server" meta:resourcekey="chart_properties_title_label" />
                <input data-bind="value: chartTitle" style="margin-left:5px;" type="text" class="input-large" />
            </label>
        </div>
        <div class="row-fluid">
            <h4 style="margin-top:0;margin-bottom:2px;"><asp:Localize runat="server" meta:resourcekey="datetime_range_title" /></h4>            
            <h6><asp:Localize runat="server" meta:resourcekey="from_range_title" /></h6>
            <div class="from-picker"></div>
            <h6><asp:Localize runat="server" meta:resourcekey="to_range_title" /></h6>
            <div class="to-picker"></div>
        </div>
        <hr style="margin-top:2px;margin-bottom:0px;" />
        <div class="row-fluid">
            <h4><asp:Localize runat="server" meta:resourcekey="select_tags_title" /></h4>
            <div class="row-fluid">
                <input data-bind="value: searchQuery, events: ['keyup', 'change']" type="text" class="search-query span12" placeholder="Search">
            </div>
            <div class="row-fluid" style="margin-top:10px;">
                <div class="tags-select-container">
                    <!-- here goes tags select template -->
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-add btn btn-block btn-primary">
                        {{#ifEquals mode 'CREATE'}}
                        <asp:Localize runat="server" meta:resourcekey="btn_add_label" />
                        {{else}}
                        <asp:Localize runat="server" meta:resourcekey="btn_update_label" />
                        {{/ifEquals}}
                    </button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="btn_cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>

    <div class="hide tags-multiple-select-template">
        <select style="height:250px;" multiple="multiple" class="tags-select span12">
            {{HBExp "#each agents"}}
                <optgroup label="{{HBExp "name"}}">
                    {{HBExp "#each tags"}}
                    <option value="{{HBExp "id"}}">{{HBExp "name"}}</option>
                    {{HBExp "/each"}}
                </optgroup>
            {{HBExp "/each"}}
        </select>
    </div>
</script>

<script type="text/x-handlebars-template" id="screen_builder_add_text">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="add_text_title" /></h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="row-fluid hide">
            <div class="text-toolbar row-fluid">
                <div class="btn-group btn-group-horizontal">
                    <button type="button" class="btn btn-text-toolbar">
                        <i class="fa fa-bold" aria-hidden="true"></i>
                    </button>
                    <button type="button" class="btn btn-text-toolbar">
                        <i class="fa fa-italic" aria-hidden="true"></i>
                    </button>
                    <button type="button" class="btn btn-text-toolbar">
                        <i class="fa fa-underline" aria-hidden="true"></i>
                    </button>
                </div>
            </div>
        </div>
        <%--<hr />--%>
        <div class="row-fluid">
            <textarea id="content_textarea" name="content_textarea" style="height:350px;" class="content-textarea span12"></textarea>
            <%--<div data-bind="html:content, events: ['keyup', 'change']" contenteditable="true" style="height:350px;" class="content-textarea span12"></div>--%>
        </div>
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-add btn btn-block btn-primary"><asp:Localize runat="server" meta:resourcekey="btn_add_label" /></button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="btn_cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>