﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-min-max-cell/backgrid-valid-min-max-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">

         <div class="span12 row-fluid">
            <div class="span3">
                <div data-bind="classes: { hide: hasHeatName, }">
                    <label class="control-label" for="dateStartTbx">
                        <asp:localize runat="server" meta:resourcekey="dateStart_label" />
                    </label>
                    <label class="input-prepend">
                        <span class="add-on"><i class="icon-calendar"></i></span>
                        <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(from$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                    </label>
                    <label class="control-label" for="dateEndTbx">
                        <asp:localize runat="server" meta:resourcekey="dateEnd_label" />
                    </label>
                    <label class="input-prepend">
                        <span class="add-on"><i class="icon-calendar"></i></span>
                        <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(to$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                    </label>
                </div>
                <div data-bind="classes: { hide: not(hasHeatName), }">
                    <button id="periodViewBtn" class="btn btn-primary btn-left" style="margin-left:5px; width:100px;">
                        <asp:Localize runat="server" meta:resourcekey="period_view_btn_label" />
                    </button> 
                </div>
            </div>
            <div class="span8">
                <div class="navigation-buttons"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-left:-250px;"></div>
            </div>
            <div class="span1 row-fluid">
                <div class="span6">
                    <button id="refreshBtn" class="btn btn-primary" style="margin-left:-20px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                        <i class="fa fa-refresh"></i>
                    </button>
               </div>
               <div class="span6">
                    <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
                        <span class="excel-export-state fa fa-file-excel-o"></span>
                        <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                    </button>
               </div>
            </div>
       </div>
        
    </div>
    
</div>

<div class="row-fluid screen-content">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>

    <div class="form-inline element-limits text-center row-fluid" style="margin-top:2px;" data-bind="classes: { hideGrid: any(not(hasData), isLoading), }">
        <div class="span3"></div>
        <div class="span6">
            <table class="limits-table">
                <thead>
                    <tr>
                        <td style="width:50px !important;"></td>
                        <td><strong>Product</strong></td>
                        <td><strong>B3ratio</strong></td>
                        <td><strong>% MgO</strong></td>
                        <td><strong>% FeO</strong></td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="width:50px !important;"><strong>EAF A</strong></td>
                        <td><span data-bind="text: EAFA_Product"></span></td>
                        <td><span data-bind="text: EAFA_B3ratio"></span></td>
                        <td><span data-bind="text: EAFA_MgO"    ></span></td>
                        <td><span data-bind="text: EAFA_FeO"    ></span></td>
                    </tr>
                    <tr>
                        <td style="width:50px !important;"><strong>EAF B</strong></td>
                        <td><span data-bind="text: EAFB_Product"></span></td>
                        <td><span data-bind="text: EAFB_B3ratio"></span></td>
                        <td><span data-bind="text: EAFB_MgO"></span></td>
                        <td><span data-bind="text: EAFB_FeO"></span></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="span4"></div>
      
    </div>

    <div data-bind="classes: { hideGrid: any(not(hasData_EAFA), isLoading), }">
        <h4>EAF A</h4>
        <div class="row fluid">
            <div class="span8">
                <div class="items-grid-container backgrid-container infinite-container" id="EAFA" style="margin-top:1px; width:95%;margin-left:15px !important;" ></div>
            </div>
            <div class="span4">
                <div style="margin-left: -10%; margin-top:-50px;margin-bottom:-45px;" class="residuals_EAFA"></div>
            </div>

        </div>
    </div>
    <div data-bind="classes: { hideGrid: any(not(hasData_EAFB), isLoading), }">
        <h4 style="margin-top:5px;">EAF B</h4>
         <div class="row fluid">
            <div class="span8" style="margin-top:-10px;">
                <div class="items-grid-container-eaf-b backgrid-container infinite-container" id="EAFB" style="margin-top:1px; width:95%;margin-left:15px !important;" ></div>
            </div>
            <div class="span4">
                <div style="margin-left: -10%; margin-top:-50px;margin-bottom:-45px;" class="residuals_EAFB"></div>
            </div>

        </div>


<%--
        <div class="items-grid-container-eaf-b backgrid-container infinite-container" id="EAFB" style="margin-top:10px; width:945px;" ></div>
        <div style="margin-left: 0%;" class="residuals_EAFB"></div>--%>
    </div>



  
</div>
