﻿/// <reference path="http://localhost/IndustrialDashboard/Scripts/IndustrialDashboard-debug.js" />

//this main file will be the first one that's executed when the page loads, 
//it depends from app.js that it's gonna be available to use (or should be, adding it app to the require.js loader)
//app.js returns a global object that contains some stuff that's needed throughout the application.

require([
    //main app settings
    "app",

    //main router for the application
    "router",

    //main appController Module
    "modules/appController"

], function (app, Router, AppController) {
    
    // Define your master router on the application namespace and trigger all
    // navigation from this instance.
    // WARNING! Do not forget to add the optional slash at the end of each route to prevent issues if the routed
    //route has it or not.
    var app_routes = {
        "": "defaultRoute"
        , "!/user/logout(/)": "logout"
        , "!/user/signup(/)": "signup"
        , "!/help-center(/:action)(/:item)(/:subitem)(/)": "helpCenter"
        , "*notFound(/)": "notFound"
    };

    var dict = {};
    var route_IDs = app.getRoutes(null, true, false, null);
    _.each(route_IDs, function (t) {
        dict[t.Route] = t.Name; 
    }); 

    Core.Object.Extend(app_routes, dict);
    app_routes = dict;

    NProgress.configure({ ease: 'ease', speed: 500 });
    NProgress.configure({ trickleRate: 0.02, trickleSpeed: 300 });
    NProgress.configure({ showSpinner: false });

    app.router = new Router({
        routes: app_routes
        , routeIDs: route_IDs
    });

    app.models.appController = new AppController.Model();
    app.views.appController = new AppController.Views.Main({
        model: app.models.appController,
        callback: function () {
            // Trigger the initial route and enable HTML5 History API support, set the
            // root folder to '/' by default.  Change in app.js.
            Backbone.history.start({ pushState: true, root: app.root });

            $("#loading").hide();
        }, 
    });

    // All navigation that is relative should be passed through the navigate
    // method, to be processed by the router. If the link has a `data-bypass`
    // attribute, bypass the delegation completely.
    $(document).on("click", "a[href]:not([data-bypass])", function (evt) {
        // Get the absolute anchor href.
        var href = { prop: $(this).prop("href"), attr: $(this).attr("href") };
        // Get the absolute root.
        var root = location.protocol + "//" + location.host + app.root;

        // Ensure the root is part of the anchor href, meaning it's relative.
        if (href.prop.slice(0, root.length) === root) {
            // Stop the default event to ensure the link will not cause a page
            // refresh.
            evt.preventDefault();
            //href.attr = href.prop.slice(root.length); 
            href.attr = href.attr.replace(app.root, ""); 
            // `Backbone.history.navigate` is sufficient for all Routers and will
            // trigger the correct events. The Router's internal `navigate` method
            // calls this anyways.  The fragment is sliced from the root.
            Backbone.history.navigate(href.attr, true);
        }
    });

});