﻿define([
  'app',
  'modules/process/process',
],
function (app, Process) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Process.Models.Process;
        superProto = superRef.prototype;

        Main.Models.LfProcess = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    treatment: null,

                    start: null,
                    end: null,

                    energy: null,
                    lfHeatsCount: null,
                    ladleFurnaceCode: null,
                    ladleFurnaceName: null,
                    operatorId: 0,
                    operatorName: null,
                    //powerOff: null,
                    powerOn: null,
                }
            ),
            computeds: _.extend(
                {},
                superProto.computeds,
                {
                    heatNameTreatment: {
                        deps: ['heatName', 'treatment'],
                        get: function (heatName, treatment) {
                            return ((heatName) && (treatment))
                                        ? heatName + '.' + treatment.toString()
                                        : null;
                        },
                    },
                }
            ),
            procedures: {
                get: app.DatabaseNames.MES + '.LF.GetProcesses',
                getNext: app.DatabaseNames.MES + '.LF.GetNextProcess',
                removeManualVariable: app.DatabaseNames.MES + '.LF.RemoveProcessManualVariable',
                ship: app.DatabaseNames.MES + '.LF.ShipProcessManual',
                update: app.DatabaseNames.MES + '.LF.UpdateProcessManual',
            },

            parse: function (obj) {
                return _.extend(superProto.parse.apply(this, arguments), {
                    treatment: obj.Treatment,

                    start: obj.StartString,
                    end: obj.EndString,

                    energy: obj.Energy,
                    lfHeatsCount: obj.Lf,
                    ladleFurnaceCode: obj.LadleFurnaceCode,
                    ladleFurnaceName: obj.LadleFurnaceName,
                    operatorId: obj.OperatorId,
                    operatorName: obj.OperatorName,
                    //powerOff: obj.PowerOff,
                    powerOn: obj.PowerOn,
                });
            },
        });
        _.extend(classRef, {
            arriveHeat: function (options) {
                var qp = new QueryParameters(),
                    opt = _.extend(
                        { async: true, error: function () { }, success: function () { }, params: {}, },
                        options
                    );

                qp.Add('heatId', 'INT', opt.params.heatId);
                qp.Add('ladleFurnaceCode', 'INT', opt.params.ladleFurnaceCode);

                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.LF.ArriveHeatManual',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {
                                var model = new classRef();

                                if (model.parseResponse(resp, opt) == true) {
                                    opt.success(model, resp, options);
                                }
                                else {
                                    var msg = (resp.Message) ? resp.Message : 'SERVER_RESPONSE_NOT_VALID';

                                    opt.error(msg);
                                    console.error(new Error(msg).stack);
                                }
                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        onError: function (msg) {
                            try {
                                opt.error(msg);
                                console.error(new Error(msg).stack);
                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Async: opt.async,
                        Secured: true,
                    },
                    classRef.prototype.connectionString
                );
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Process.Collections.Processes;
        superProto = superRef.prototype;

        Main.Collections.LfProcesses = classRef = superRef.extend({
            model: Main.Models.LfProcess,
        });
        _.extend(classRef, {
            fetch: function (options) {
                var opt = _.extend(
                        { error: function () { }, success: function () { }, },
                        options
                    );

                classRef.prototype.getData.apply(classRef.prototype, [_.extend(
                    {},
                    opt,
                    {
                        success: function (resp) {
                            if ((resp) && (resp.Table)) {
                                opt.success(_.map(resp.Table, function (obj) { return classRef.prototype.model.prototype.parse(obj, resp.Table1); }));
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'Can not fetch lf processes.';

                                console.error(new Error(msg).stack);
                                opt.error(msg);
                            }
                        },
                    }
                )]);
            },            
        });
    })();

    Main.fetchHeatsToArrive = function (options) {
        var that = this,
                qp = new QueryParameters(),
                opt = _.extend(
                    {
                        async: true,
                        params: {},
                    },
                    options
                );

        for (var pname in opt.params)
            qp.Add(pname, 'VARCHAR', opt.params[pname]);

        Core.Json.CallProcedure(
            app.DatabaseNames.MES + '.LF.GetHeatsToArrive',
            qp,
            {
                onSuccess: function (resp) {
                    if ((resp) && (resp.Table)) {
                        var records = _.map(resp.Table, function (obj) {
                            return {
                                id: obj.Id,
                                name: obj.Name,
                                gradeId: obj.GradeId,
                                gradeName: obj.GradeName,
                                statusCode: obj.StatusCode,
                                statusName: obj.StatusName,
                                ladleId: obj.LadleId,
                                ladleName: obj.LadleName,
                                previousEquipmentName: obj.PreviousEquipmentName,
                                startTapTimestamp: obj.StartTapString,
                                endTapTimestamp: obj.EndTapString,
                                shipTimestamp: obj.ShipTimestampString,
                            };
                        })

                        opt.success(records, resp, opt);
                    }
                    else {
                        var msg = (resp.Message) ? resp.Message : 'SERVER_RESPONSE_NOT_VALID';

                        opt.error(that, msg);
                        console.error(new Error(msg).stack);
                    }
                },
                onError: function (msg) {
                    try {
                        opt.error(msg);
                        console.error(new Error(msg).stack);
                    }
                    catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                },
                Async: opt.async,
                Secured: true,
            },
            app.ConnectionStrings.app
        );
    };

    // Required, return the module for AMD compliance.
    return Main;

});