﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.SlagChemistrySample = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    heatId: null,
                    heatName: null,

                    comments: null,
                    operator: null,
                    order: null,
                    timestamp: null,
                    b3Max: null,
                    b3Min: null,
                    feOMax: null,
                    feOMin: null,
                    mgOMax: null,
                    mgOMin: null,
                    total: null,
                }
            ),
            procedures: {
                create: app.DatabaseNames.MES + '.LAB.CreateSlagChemistrySampleManual',
                get: app.DatabaseNames.MES + '.LAB.GetSlagChemistrySamples',
                update: app.DatabaseNames.MES + '.LAB.UpdateSlagChemistrySampleManual',
                remove: app.DatabaseNames.MES + '.LAB.RemoveSlagChemistrySample',
            },

            parse: function (obj) {
                var ret = {};

                _.each(app.slagChemistryElements, function (el) {
                    ret[el] = obj[el];
                });

                return _.extend(
                    ret,
                    {
                        id: obj.Id,

                        heatId: obj.HeatId,
                        heatName: obj.HeatName,

                        comments: obj.Comments,
                        operator: obj.Operator,
                        order: obj.Order,
                        timestamp: obj.TimestampString,
                        b3Max: obj.B3Max,
                        b3Min: obj.B3Min,
                        feOMax: obj.FeOMax,
                        feOMin: obj.FeOMin,
                        mgOMax: obj.MgOMax,
                        mgOMin: obj.MgOMin,
                        total: obj.Total,
                    }
                );
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.SlagChemistrySamples = classRef = superRef.extend({
            model: Main.Models.SlagChemistrySample,
            comparator: 'timestamp',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});