//SCREEN-BOILERPLATE
//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
    // Application variable, always include it to have access to app methods.
    'app',

    //templates-loader: this loads templates async.
    'js/templates-loader',
    'backgrid',
    'moment',

    'components/ag-grid/ag-grid-module',
    'backgrid/infinator',
    'backgrid/moment-cell',
    'backgrid/grouped-columns',

    "js/jquery.floatThead/jquery.floatThead",
    'js/jquery.contextMenu/jquery.contextMenu'
],
    function (app, T, Backgrid, moment, AgGridModule) {

        var Screen = { Models: {}, Views: {}, Collections: {} }

        Screen.Models.Main = Backbone.Epoxy.Model.extend({
            defaults: {
                start: new moment().subtract(2, 'days').format('YYYY-MM-DD'),
                end: new moment().format('YYYY-MM-DD'),
                heatName: null,
                hasData: false,
                isLoading: false,
                isPageLoading: false,
                grid: [],
                searchText: ''
            },
            computeds: {
                start$: {
                    deps: ['start'],
                    get: function (value) {
                        return value;
                    },
                    set: function (value) {
                        return { start: (value) ? new moment(value, app.translate(app, 'MM/DD/YYYY')).format('YYYY-MM-DD') : value, };
                    },
                },
                end$: {
                    deps: ['end'],
                    get: function (value) {
                        return value;
                    },
                    set: function (value) {
                        return { end: (value) ? new moment(value, app.translate(app, 'MM/DD/YYYY')).format('YYYY-MM-DD') : value, };
                    },
                },
            },
        });

        var CustomAgGridModule = AgGridModule.extend({
            initialize: function (options) {
                this.bus = options.bus;
                this.itemsColl = options.itemsColl;
                var that = this;
                
                // Override onCellClicked in gridOptions
                if (!options.gridOptions) options.gridOptions = {};
                options.gridOptions.onCellClicked = function(params) {
                    // Handle click on HeatNumber column
                    if (params.column && params.column.colDef.field === 'HeatNumber' && params.value) {
                        var heatNumber = params.value;
                        Backbone.history.navigate('!/caster-heat-report/' + heatNumber, { trigger: true });
                        return;
                    }
                    
                    // Call parent onCellClicked for other columns
                    AgGridModule.prototype.onCellClicked.call(that, params);
                };
                
                this.columnDefs = [
                    { 
                        field: 'HeatNumber', 
                        headerName: 'Heat Number', 
                        flex: 1, 
                        showFilter: true,
                        cellRenderer: this.heatNumberCellRenderer.bind(this),
                        cellStyle: { textAlign: 'center' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'LadleOpenTimeStamp', 
                        headerName: 'Ladle Open Time', 
                        flex: 1, 
                        minWidth: 150, 
                        showFilter: true, 
                        fieldType: 'Datetime', 
                        format: 'MM/DD HH:mm',
                        cellStyle: { textAlign: 'center' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'AbsoluteHumidity', 
                        headerName: 'Absolute Humidity (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'OneHourPreviousAverageAbsoluteHumidity', 
                        headerName: '1H Avg (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'TwoHourPreviousAverageAbsoluteHumidity', 
                        headerName: '2H Avg (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'ThreeHourPreviousAverageAbsoluteHumidity', 
                        headerName: '3H Avg (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'FourHourPreviousAverageAbsoluteHumidity', 
                        headerName: '4H Avg (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'FiveHourPreviousAverageAbsoluteHumidity', 
                        headerName: '5H Avg (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'SixHourPreviousAverageAbsoluteHumidity', 
                        headerName: '6H Avg (g/m³)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 4),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'OpenTemperature', 
                        headerName: 'Temperature (°C)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 2),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    },
                    { 
                        field: 'RelativeHumidityAtOpenOfHeat', 
                        headerName: 'Relative Humidity (%)', 
                        flex: 1, 
                        showFilter: false, 
                        valueFormatter: this.decimalFormatter.bind(this, 2),
                        cellStyle: { textAlign: 'right' },
                        headerClass: 'ag-header-cell-center'
                    }
                ];

                // Pass the columns to the options
                options.columnDefs = this.columnDefs;

                // Initialize ag-Grid
                AgGridModule.prototype.initialize.call(this, options);
            },
            decimalFormatter: function (decimals, params) {
                if (params.value == null || params.value === '') return '';
                return parseFloat(params.value).toFixed(decimals);
            },
            heatNumberCellRenderer: function (params) {
                if (!params.value) return '';
                return '<span class="heat-link" style="color: #007bff; cursor: pointer; text-decoration: underline;">' + params.value + '</span>';
            }
        });

        Screen.Views.Main = Backbone.Epoxy.View.extend({
            template: 'weather-tracking-summary',
            id: 'weather-tracking-summary',
            title: 'Weather Tracking Summary',
            events: function () {
                return {
                    'click #refreshBtn': this.refreshBtn_click,
                    'click #calendarStartBtn': this.calendarStartBtn_click,
                    'click #calendarEndBtn': this.calendarEndBtn_click,
                };
            },
            bindings: 'data-bind',
            bindingSources: null,
            grids: null,
            itemsColl: null,
            subviews: null,
            viewParams: null,

            initialize: function () {
                this.options.state = app.view_states.loading;
                this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

                var that = this;

                if (!this.model)
                    this.model = new Screen.Models.Main();

                // Init AgGridModule:
                this.agGridModule = new CustomAgGridModule({
                    itemsColl: this.itemsColl,
                    bus: this.bus,
                    rowData: [],
                    onChange: this.handleGridChange.bind(this),
                    onRemove: this.handleGridRemove.bind(this),
                    fileName: 'weather-tracking-summary-report',
                    screenTitle: 'Weather Tracking Summary Report',
                    isPageLoading: that.model.get('isPageLoading'),
                });
                this.grids = {};

                this.itemsColl = new Screen.Collections.Items();

                this.bindingSources = {};

                this.subviews = {};
                this.autoRefresh = {
                    enabled: null
                    , toid: null
                    , every: 5 * 1000
                };

                this.bindEvents();
                this.bus = _.extend({}, Backbone.Events);
            },
            handleGridChange: function (event) {
                // This function will be called when a cell value changes
            },
            handleGridRemove: function () {
                // This function will be called when the grid is being removed/destroyed
            },
            calendarStartBtn_click: function () {
                $('#dateStartTbx').datepicker('show');
            },
            calendarEndBtn_click: function () {
                $('#dateEndTbx').datepicker('show');
            },
            bindEvents: function () {
                this.listenTo(this.itemsColl, 'backgrid:rowclick', this.processes_backgrid_rowclick)
                    .listenTo(this.itemsColl, 'fetch', this.processes_ready)
                    .listenTo(this.model, 'triggerFetch', this.refreshBtn_click);
            },
            removeHighlightRow: function () {
                var previousIndex = this.model.get('index');
                var rowsView = this.model.get('grid').body.rows;

                if (rowsView && rowsView[previousIndex] && rowsView[previousIndex].$el)
                    rowsView[previousIndex].$el.removeClass("onRightClickSelectedRow");
            },
            _refresh: function (opt) {
                this.itemsColl.reset();
                this.model.set({
                    hasData: false,
                });

                if (this.autoRefresh.toid != null) {
                    clearTimeout(this.autoRefresh.toid);
                    this.autoRefresh.toid = null;
                }

                this.refreshProcesses(opt);

                if (this.autoRefresh.enabled == true) {
                    var that = this;

                    this.autoRefresh.toid = setTimeout(
                        function () { that._refresh(); },
                        this.autoRefresh.every
                    );
                }
            },
            refresh: function (viewParams) {
                var fixedParams = _.extend({}, Screen.Models.Main.prototype.defaults, viewParams);

                if (viewParams.start)
                    fixedParams.start = new moment(viewParams.start, 'YYYYMMDD').format('YYYY-MM-DD');
                if (viewParams.end)
                    fixedParams.end = new moment(viewParams.end, 'YYYYMMDD').format('YYYY-MM-DD');
                if (viewParams.heatName)
                    fixedParams.heatName = viewParams.heatName;

                this.model.set(fixedParams);

                this._refresh({
                    reset: true,
                    params: _.extend(
                        {},
                        fixedParams,
                        {}
                    ),
                });
            },
            render: function (container, viewParams) {
                var that = this;

                this.viewParams = viewParams;

                // Initialize the loading state
                that.model.set({ isPageLoading: true });

                var thatContainer = (this.options.container) ? this.options.container : container;
                this.options.container = thatContainer;

                //the screens have a custompath, so it has to be specified in the customPath variable that is
                //then sent to the template loader.
                var customPath = '/app/pages/weather-tracking-summary/';

                T.render.call(
                    this,
                    this.template,
                    function (tmp) {
                        if (!that.options.i18n) that.options.i18n = {};

                        app.getI18NJed(
                            that,
                            that.template,
                            function (i18nJED) {
                                //storing internationalization data
                                that.options.i18n[that.template] = i18nJED;

                                //loading the view and appending it to the views's $el.
                                that.$el.html(tmp());

                                that.applyBindings();

                                //start: the view was already loaded an is on a div element, but not appended to the main container
                                //here you can perform anything you want DOM related, by getting the dom element via that.$el.find('#id')
                                //or this.$('#id')

                                that.$el.find('.input-date').datepicker();

                                // Render the AgGridModule and append it to the container
                                that.agGridModule.render();
                                that.$el.find('.processes-grid-container').append(that.agGridModule.$el);

                                //appending view to the main container
                                that.append(thatContainer, that.$el);

                                //Set model with view params here to prevent changes on the model when the view bindings are applied.
                                var fixedParams = _.extend({}, viewParams);

                                if (fixedParams.start)
                                    fixedParams.start = new moment(fixedParams.start, 'YYYYMMDD').format('YYYY-MM-DD');
                                if (fixedParams.end)
                                    fixedParams.end = new moment(fixedParams.end, 'YYYYMMDD').format('YYYY-MM-DD');
                                if (fixedParams.heatName)
                                    fixedParams.heatName = fixedParams.heatName;

                                that.model.set(fixedParams);

                                //Call first refresh.
                                var params = that.model.toJSON();

                                that._refresh({
                                    reset: true,
                                    params: _.extend(
                                        {},
                                        params,
                                        {}
                                    ),
                                });

                                // Set loading state to false when everything is ready
                                that.model.set({ isPageLoading: false });
                            },
                            true,
                            customPath
                        );
                    },
                    customPath
                );
            },
            processes_ready: function () {
                try {
                    var that = this;
                    const collectionData = that.itemsColl;
                    setTimeout(
                        function () {
                            that.agGridModule.setRowDataAsCollection(collectionData);
                            that.agGridModule.hideOverlay();  // Hide loading overlay
                            that.model.set({
                                hasData: (that.itemsColl.length > 0),
                                isLoading: false,
                            });
                        },
                        100
                    );
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },

            search_keypress: function (e) {
                if (e.keyCode === 13) {
                    $('#search').blur();
                    this.refreshBtn_click();
                }
            },
            refreshProcesses: function (options) {
                var that = this,
                    attrs = this.model.toJSON(),
                    opt = _.extend({}, options, { params: {}, });

                if ((opt.refresh == true) || (opt.reset == true)) {
                    this.model.set('isLoading', true);
                    that.agGridModule.showLoadingOverlay();  // Show loading overlay
                }

                this.itemsColl.fetch({
                    start: attrs.start,
                    end: attrs.end,
                    heatName: (attrs.heatName && attrs.heatName != '') ? attrs.heatName : null,
                    searchText: attrs.searchText,
                    refresh: true,
                });
            },
            processes_backgrid_rowclick: function (model) {
                try {
                    // Can add navigation or detail view here if needed
                }
                catch (Error) { console.error(Error.stack); }
            },
            refreshBtn_click: function (e) {
                try {
                    var params = this.model.toJSON();
                    var urlParams = {
                        start: new moment(params.start, 'YYYY-MM-DD').format('YYYYMMDD'),
                        end: new moment(params.end, 'YYYY-MM-DD').format('YYYYMMDD'),
                    };
                    if (params.heatName) {
                        urlParams.heatName = params.heatName;
                    }
                    app.router.navigate(
                        app.router.resolveURL(
                            app.router.currentModule,
                            _.extend({}, urlParams),
                            false
                        ),
                        { trigger: false, replace: true }
                    );

                    this._refresh({
                        reset: true
                    });

                    window.scrollTo(0, 0);
                }
                catch (Error) { console.error(Error.stack); }
            },

            //Common functions
            append: function (container, el) {
                el = (el != null && el != undefined) ? el : this.$el;

                if (this.options.state == app.view_states.loading
                    || this.options.state == app.view_states.shown) {
                    //appending view to the main container and set state to shown

                    this.options.state = app.view_states.shown;
                    container.append(el);

                    this.options.onappend(this);
                }

                if (this.options.state == app.view_states.hidden) {
                    //append and remain hidden
                    container.append(el);
                }

                if (this.options.state == app.view_states.closed) {
                    //return without appending.
                    return;
                }
            },
            bindViewScopedEvents: function () {
                var that = this;
            },
            unbindViewScopedEvents: function () {

            },
            close: function () {
                this.options.state = app.view_states.closed;

                this.closeSubviews();
                this.remove();
                this.unbindViewScopedEvents();
                this.unbind();
            },
            closeSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.close();
                });
            },
            show: function () {
                this.options.state = app.view_states.shown;

                this.showSubviews();
                this.bindEvents();
                this.$el.show();
            },
            showSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.show();
                });
            },
            hide: function () {
                this.options.state = app.view_states.hidden;

                this.hideSubviews();

                this.$el.hide();
                this.unbind();
                this.stopListening();
            },
            hideSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.hide();
                });
            },
            preRender: function () {
                app.models.subnavbar.set("subnavbar", false);
            },
            reRender: function (viewParams) {
                try {
                    this.refresh(viewParams);
                } catch (Error) { }
            },
        });

        Screen.Collections.Items = Backbone.Collection.extend({
            isFetching: false,
            currentPage: 1,
            pageSize: 100,

            fixedParameters: [],

            fetch: function (params) {
                var that = this,
                    qp = new Core.Database.QueryParameters(),
                    options = params ? _.clone(params) : {};
                if (options.refresh) {
                    this.resetPagination(true);
                    this.fixedParameters = [
                        { Name: '@Start', Type: 'DATETIME', Value: params.start, },
                        { Name: '@End', Type: 'DATETIME', Value: params.end, },
                        { Name: '@HeatName', Type: 'VARCHAR', Value: params.heatName, },
                    ];
                }
                this.isFetching = true;

                _.each(this.fixedParameters, function (qpParams) {
                    qp.Add(qpParams.Name, qpParams.Type, qpParams.Value);
                });

                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.MES.GetWeatherTrackingSummary',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {

                                if ((resp) && (resp.Table)) {
                                    newColl = resp.Table;
                                    var method = (options.refresh) ? 'set' : 'add';
                                    that[method](newColl);
                                    that.trigger('fetch', that, newColl);

                                    if (newColl.length == 0 && method == 'add')
                                        that.currentPage--;

                                    that.isFetching = false;
                                }
                                else {
                                    if ((resp) && (resp.Message)) {
                                        console.error(new Error(resp.Message).stack);
                                        app.views.topMessages.showMessage('CALL TO DATABASE FAILED', { stay: 5000, });
                                    }
                                    else {
                                        app.views.topMessages.showMessage('SERVER RESPONSE NOT VALID', { stay: 5000, });
                                        console.error(new Error('SERVER_RESPONSE_NOT_VALID').stack);
                                    }
                                }
                            }
                            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
                        },
                        onFailure: function (resp) {
                            console.error(resp);
                            that.isFetching = false;
                        },
                        Secured: true,
                        Async: true,
                    },
                    app.ConnectionStrings.app
                );
                return this;
            },
            getNextPage: function (options) {
                if (!this.isFetching) {
                    this.currentPage++;
                    options = (_.isObject(options)) ? options : {};
                    this.fetch(options);
                }
            },
            resetPagination: function (force) {
                if (!this.isFetching || force == true) {
                    this.currentPage = 1;
                } else {
                    _.delay(this.resetPagination, 100);
                }
            },
        });

        // Required, return the module for AMD compliance.
        return Screen;
    });

